/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.replication.regionserver.ClaimReplicationQueueCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClaimReplicationQueueRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimReplicationQueueRemoteProcedure.class);
    private ServerName crashedServer;
    private String queue;

    public ClaimReplicationQueueRemoteProcedure() {
    }

    public ClaimReplicationQueueRemoteProcedure(ServerName crashedServer, String queue, ServerName targetServer) {
        this.crashedServer = crashedServer;
        this.queue = queue;
        this.targetServer = targetServer;
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        assert (this.targetServer.equals((Object)remote));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), ClaimReplicationQueueCallable.class, MasterProcedureProtos.ClaimReplicationQueueRemoteParameter.newBuilder().setCrashedServer(ProtobufUtil.toServerName((ServerName)this.crashedServer)).setQueue(this.queue).build().toByteArray()));
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CLAIM_REPLICATION_QUEUE_REMOTE;
    }

    @Override
    protected boolean complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Failed to claim replication queue {} of crashed server on server {} ", new Object[]{this.queue, this.crashedServer, this.targetServer, error});
            return false;
        }
        return true;
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.Builder builder = MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.newBuilder().setCrashedServer(ProtobufUtil.toServerName((ServerName)this.crashedServer)).setQueue(this.queue).setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer)).setState(this.state);
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException((Throwable)this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ClaimReplicationQueueRemoteStateData data = (MasterProcedureProtos.ClaimReplicationQueueRemoteStateData)serializer.deserialize(MasterProcedureProtos.ClaimReplicationQueueRemoteStateData.class);
        this.crashedServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getCrashedServer());
        this.queue = data.getQueue();
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
        this.state = data.getState();
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException((ErrorHandlingProtos.ForeignExceptionMessage)data.getError());
        }
    }
}

