/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScannerWithBulkload {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerWithBulkload.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    private static void createTable(Admin admin, TableName tableName) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        hcd.setMaxVersions(3);
        desc.addFamily(hcd);
        admin.createTable((TableDescriptor)desc);
    }

    @Test
    public void testBulkLoad() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        long l = EnvironmentEdgeManager.currentTime();
        Admin admin = TEST_UTIL.getAdmin();
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        Table table = this.init(admin, l, scan, tableName);
        Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoad/", "/temp/testBulkLoad/col/file", false);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            bulkload.doBulkLoad(hfilePath, admin, table, locator);
        }
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        result = this.scanAfterBulkLoad(scanner, result, "version2");
        Put put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version3")));
        table.put(put0);
        admin.flush(tableName);
        scanner = table.getScanner(scan);
        result = scanner.next();
        while (result != null) {
            List cells = result.getColumnCells(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
            for (Cell _c : cells) {
                if (!Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()).equals("row1")) continue;
                System.out.println(Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()));
                System.out.println(Bytes.toString((byte[])_c.getQualifierArray(), (int)_c.getQualifierOffset(), (int)_c.getQualifierLength()));
                System.out.println(Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
                Assert.assertEquals((Object)"version3", (Object)Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
            }
            result = scanner.next();
        }
        scanner.close();
        table.close();
    }

    private Result scanAfterBulkLoad(ResultScanner scanner, Result result, String expctedVal) throws IOException {
        while (result != null) {
            List cells = result.getColumnCells(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
            for (Cell _c : cells) {
                if (!Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()).equals("row1")) continue;
                System.out.println(Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()));
                System.out.println(Bytes.toString((byte[])_c.getQualifierArray(), (int)_c.getQualifierOffset(), (int)_c.getQualifierLength()));
                System.out.println(Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
                Assert.assertEquals((Object)expctedVal, (Object)Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
            }
            result = scanner.next();
        }
        return result;
    }

    private Path writeToHFile(long l, String hFilePath, String pathStr, boolean nativeHFile) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path hfilePath = new Path(hFilePath);
        fs.mkdirs(hfilePath);
        Path path = new Path(pathStr);
        HFile.WriterFactory wf = HFile.getWriterFactoryNoCache((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertNotNull((Object)wf);
        HFileContext context = new HFileContextBuilder().build();
        HFile.Writer writer = wf.withPath(fs, path).withFileContext(context).create();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version2"));
        if (nativeHFile) {
            kv.setSequenceId(9999999L);
        }
        writer.append((Cell)kv);
        if (nativeHFile) {
            writer.appendFileInfo(HStoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes((long)new Long(9999999L)));
        } else {
            writer.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)EnvironmentEdgeManager.currentTime()));
        }
        writer.close();
        return hfilePath;
    }

    private Table init(Admin admin, long l, Scan scan, TableName tableName) throws Exception {
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        Put put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
        table.put(put0);
        admin.flush(tableName);
        Put put1 = new Put(Bytes.toBytes((String)"row2"));
        put1.add((Cell)new KeyValue(Bytes.toBytes((String)"row2"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
        table.put(put1);
        admin.flush(tableName);
        put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version1")));
        table.put(put0);
        admin.flush(tableName);
        admin.compact(tableName);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        List cells = result.getColumnCells(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
        Assert.assertEquals((long)1L, (long)cells.size());
        Cell _c = (Cell)cells.get(0);
        Assert.assertEquals((Object)"version1", (Object)Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
        scanner.close();
        return table;
    }

    @Test
    public void testBulkLoadWithParallelScan() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        final long l = EnvironmentEdgeManager.currentTime();
        final Admin admin = TEST_UTIL.getAdmin();
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        scan.setCaching(1);
        final Table table = this.init(admin, l, scan, tableName);
        final Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoadWithParallelScan/", "/temp/testBulkLoadWithParallelScan/col/file", false);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        final LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    Put put1 = new Put(Bytes.toBytes((String)"row5"));
                    put1.add((Cell)new KeyValue(Bytes.toBytes((String)"row5"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version0")));
                    table.put(put1);
                    try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
                        bulkload.doBulkLoad(hfilePath, admin, table, locator);
                    }
                    latch.countDown();
                }
                catch (TableNotFoundException tableNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        latch.await();
        this.scanAfterBulkLoad(scanner, result, "version1");
        scanner.close();
        table.close();
    }

    @Test
    public void testBulkLoadNativeHFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        long l = EnvironmentEdgeManager.currentTime();
        Admin admin = TEST_UTIL.getAdmin();
        TestScannerWithBulkload.createTable(admin, tableName);
        Scan scan = this.createScan();
        Table table = this.init(admin, l, scan, tableName);
        Path hfilePath = this.writeToHFile(l, "/temp/testBulkLoadNativeHFile/", "/temp/testBulkLoadNativeHFile/col/file", true);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.mapreduce.bulkload.assign.sequenceNumbers", true);
        LoadIncrementalHFiles bulkload = new LoadIncrementalHFiles(conf);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            bulkload.doBulkLoad(hfilePath, admin, table, locator);
        }
        ResultScanner scanner = table.getScanner(scan);
        Result result = scanner.next();
        result = this.scanAfterBulkLoad(scanner, result, "version2");
        Put put0 = new Put(Bytes.toBytes((String)"row1"));
        put0.add((Cell)new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"), l, Bytes.toBytes((String)"version3")));
        table.put(put0);
        admin.flush(tableName);
        scanner = table.getScanner(scan);
        result = scanner.next();
        while (result != null) {
            List cells = result.getColumnCells(Bytes.toBytes((String)"col"), Bytes.toBytes((String)"q"));
            for (Cell _c : cells) {
                if (!Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()).equals("row1")) continue;
                System.out.println(Bytes.toString((byte[])_c.getRowArray(), (int)_c.getRowOffset(), (int)_c.getRowLength()));
                System.out.println(Bytes.toString((byte[])_c.getQualifierArray(), (int)_c.getQualifierOffset(), (int)_c.getQualifierLength()));
                System.out.println(Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
                Assert.assertEquals((Object)"version3", (Object)Bytes.toString((byte[])_c.getValueArray(), (int)_c.getValueOffset(), (int)_c.getValueLength()));
            }
            result = scanner.next();
        }
        scanner.close();
        table.close();
    }

    private Scan createScan() {
        Scan scan = new Scan();
        scan.setMaxVersions(3);
        return scan;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

