/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSProcDispatcher
extends RSProcedureDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RSProcDispatcher.class);
    private static final AtomicInteger i = new AtomicInteger();

    public RSProcDispatcher(MasterServices master) {
        super(master);
    }

    protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
        if (!this.master.getServerManager().isServerOnline(serverName)) {
            this.submitTask((Runnable)((Object)new DeadRSRemoteCall(serverName, remoteProcedures)));
        } else {
            this.submitTask((Runnable)((Object)new TestExecuteProceduresRemoteCall(serverName, remoteProcedures)));
        }
    }

    private class DeadRSRemoteCall
    extends RSProcedureDispatcher.ExecuteProceduresRemoteCall {
        public DeadRSRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            super((RSProcedureDispatcher)RSProcDispatcher.this, serverName, remoteProcedures);
        }

        public void run() {
            this.remoteCallFailed((MasterProcedureEnv)RSProcDispatcher.this.master.getMasterProcedureExecutor().getEnvironment(), (IOException)((Object)new RegionServerStoppedException("Server " + this.getServerName() + " is not online")));
        }
    }

    class TestExecuteProceduresRemoteCall
    extends RSProcedureDispatcher.ExecuteProceduresRemoteCall {
        public TestExecuteProceduresRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            super((RSProcedureDispatcher)RSProcDispatcher.this, serverName, remoteProcedures);
        }

        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
            int j = i.addAndGet(1);
            LOG.info("sendRequest() req: {} , j: {}", (Object)request, (Object)j);
            if (j == 12 || j == 22) {
                try {
                    this.getRsAdmin().executeProcedures(null, request);
                }
                catch (ServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            if (j >= 10 && j <= 15 || j >= 18 && j <= 23) {
                throw new ConnectionClosedException("test connection closed error...");
            }
            try {
                return this.getRsAdmin().executeProcedures(null, request);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }

        private AdminProtos.AdminService.BlockingInterface getRsAdmin() throws IOException {
            return RSProcDispatcher.this.master.getServerManager().getRsAdmin(this.getServerName());
        }
    }
}

