/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RSProcDispatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestProcDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TestProcDispatcher.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcDispatcher.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ServerName rs0;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.master.rsproc.dispatcher.class", RSProcDispatcher.class.getName());
        TEST_UTIL.startMiniCluster(3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        rs0 = cluster.getRegionServer(0).getServerName();
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam1")).build();
        int startKey = 0;
        int endKey = 80000;
        TEST_UTIL.getAdmin().createTable(tableDesc, Bytes.toBytes((int)startKey), Bytes.toBytes((int)endKey), 9);
    }

    @Test
    public void testRetryLimitOnConnClosedErrors() throws Exception {
        HbckChore hbckChore = new HbckChore((MasterServices)TEST_UTIL.getHBaseCluster().getMaster());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Admin admin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        List puts = IntStream.range(10, 50000).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)("val_" + i)))).collect(Collectors.toList());
        table.put(puts);
        admin.flush(tableName);
        admin.compact(tableName);
        Thread.sleep(3000L);
        HRegionServer hRegionServer0 = cluster.getRegionServer(0);
        HRegionServer hRegionServer1 = cluster.getRegionServer(1);
        HRegionServer hRegionServer2 = cluster.getRegionServer(2);
        int numRegions0 = hRegionServer0.getNumberOfOnlineRegions();
        int numRegions1 = hRegionServer1.getNumberOfOnlineRegions();
        int numRegions2 = hRegionServer2.getNumberOfOnlineRegions();
        hbckChore.choreForTesting();
        HbckReport hbckReport = hbckChore.getLastReport();
        Assert.assertEquals((long)0L, (long)hbckReport.getInconsistentRegions().size());
        Assert.assertEquals((long)0L, (long)hbckReport.getOrphanRegionsOnFS().size());
        Assert.assertEquals((long)0L, (long)hbckReport.getOrphanRegionsOnRS().size());
        HRegion region0 = !hRegionServer0.getRegions().isEmpty() ? (HRegion)hRegionServer0.getRegions().get(0) : (HRegion)hRegionServer1.getRegions().get(0);
        for (HRegion region : hRegionServer1.getRegions()) {
            TEST_UTIL.getAdmin().move(region.getRegionInfo().getEncodedNameAsBytes(), rs0);
        }
        TEST_UTIL.getAdmin().move(region0.getRegionInfo().getEncodedNameAsBytes());
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        TEST_UTIL.waitFor(5000L, 1000L, () -> {
            LOG.info("numRegions0: {} , numRegions1: {} , numRegions2: {}", new Object[]{numRegions0, numRegions1, numRegions2});
            LOG.info("Online regions - server0 : {} , server1: {} , server2: {}", new Object[]{cluster.getRegionServer(0).getNumberOfOnlineRegions(), cluster.getRegionServer(1).getNumberOfOnlineRegions(), cluster.getRegionServer(2).getNumberOfOnlineRegions()});
            LOG.info("Num of successfully completed procedures: {} , num of all procedures: {}", (Object)master.getMasterProcedureExecutor().getProcedures().stream().filter(masterProcedureEnvProcedure -> masterProcedureEnvProcedure.getState() == ProcedureProtos.ProcedureState.SUCCESS).count(), (Object)master.getMasterProcedureExecutor().getProcedures().size());
            LOG.info("Num of SCPs: " + master.getMasterProcedureExecutor().getProcedures().stream().filter(proc -> proc instanceof ServerCrashProcedure).count());
            return numRegions0 + numRegions1 + numRegions2 == cluster.getRegionServer(0).getNumberOfOnlineRegions() + cluster.getRegionServer(1).getNumberOfOnlineRegions() + cluster.getRegionServer(2).getNumberOfOnlineRegions() && master.getMasterProcedureExecutor().getProcedures().stream().filter(masterProcedureEnvProcedure -> masterProcedureEnvProcedure.getState() == ProcedureProtos.ProcedureState.SUCCESS).count() == (long)master.getMasterProcedureExecutor().getProcedures().size() && master.getMasterProcedureExecutor().getProcedures().stream().filter(proc -> proc instanceof ServerCrashProcedure).count() > 0L;
        });
        TEST_UTIL.waitFor(5000L, 1000L, () -> {
            hbckChore.choreForTesting();
            HbckReport report = hbckChore.getLastReport();
            return report.getInconsistentRegions().isEmpty() && report.getOrphanRegionsOnFS().isEmpty() && report.getOrphanRegionsOnRS().isEmpty();
        });
    }
}

