/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestBucketCacheRefCnt {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBucketCacheRefCnt.class);
    private static final String IO_ENGINE = "offheap";
    private static final long CAPACITY_SIZE = 0x2000000L;
    private static final int BLOCK_SIZE = 1024;
    private static final int[] BLOCK_SIZE_ARRAY = new int[]{64, 128, 256, 512, 1024, 2048, 4096, 8192};
    private static final String PERSISTENCE_PATH = null;
    private static final HFileContext CONTEXT = new HFileContextBuilder().build();
    private BucketCache cache;

    private static BucketCache create(int writerSize, int queueSize) throws IOException {
        return new BucketCache(IO_ENGINE, 0x2000000L, 1024, BLOCK_SIZE_ARRAY, writerSize, queueSize, PERSISTENCE_PATH);
    }

    private static MyBucketCache createMyBucketCache(int writerSize, int queueSize) throws IOException {
        return new MyBucketCache(IO_ENGINE, 0x2000000L, 1024, BLOCK_SIZE_ARRAY, writerSize, queueSize, PERSISTENCE_PATH);
    }

    private static MyBucketCache2 createMyBucketCache2(int writerSize, int queueSize) throws IOException {
        return new MyBucketCache2(IO_ENGINE, 0x2000000L, 1024, BLOCK_SIZE_ARRAY, writerSize, queueSize, PERSISTENCE_PATH);
    }

    private static HFileBlock createBlock(int offset, int size) {
        return TestBucketCacheRefCnt.createBlock(offset, size, ByteBuffAllocator.HEAP);
    }

    private static HFileBlock createBlock(int offset, int size, ByteBuffAllocator alloc) {
        return new HFileBlock(BlockType.DATA, size, size, -1L, ByteBuff.wrap((ByteBuffer)ByteBuffer.allocate(size)), true, (long)offset, 52, size, CONTEXT, alloc);
    }

    private static BlockCacheKey createKey(String hfileName, long offset) {
        return new BlockCacheKey(hfileName, offset);
    }

    private void disableWriter() {
        if (this.cache != null) {
            for (BucketCache.WriterThread wt : this.cache.writerThreads) {
                wt.disableWriter();
                wt.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testBlockInRAMCache() throws IOException {
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        this.disableWriter();
        String prefix = "testBlockInRamCache";
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                HFileBlock blk = TestBucketCacheRefCnt.createBlock(i, 1020);
                BlockCacheKey key = TestBucketCacheRefCnt.createKey("testBlockInRamCache", i);
                Assert.assertEquals((long)1L, (long)blk.refCnt());
                this.cache.cacheBlock(key, (Cacheable)blk);
                Assert.assertEquals((long)(i + 1), (long)this.cache.getBlockCount());
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Cacheable block = this.cache.getBlock(key, false, false, false);
                try {
                    Assert.assertEquals((long)3L, (long)blk.refCnt());
                    Assert.assertEquals((long)3L, (long)block.refCnt());
                    Assert.assertEquals((Object)blk, (Object)block);
                }
                finally {
                    block.release();
                }
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Assert.assertEquals((long)2L, (long)block.refCnt());
            }
            for (i = 0; i < 10; ++i) {
                BlockCacheKey key = TestBucketCacheRefCnt.createKey("testBlockInRamCache", i);
                Cacheable blk = this.cache.getBlock(key, false, false, false);
                Assert.assertEquals((long)3L, (long)blk.refCnt());
                Assert.assertFalse((boolean)blk.release());
                Assert.assertEquals((long)2L, (long)blk.refCnt());
                Assert.assertTrue((boolean)this.cache.evictBlock(key));
                Assert.assertEquals((long)1L, (long)blk.refCnt());
                Assert.assertTrue((boolean)blk.release());
                Assert.assertEquals((long)0L, (long)blk.refCnt());
            }
        }
        finally {
            this.cache.shutdown();
        }
    }

    private static void waitUntilFlushedToCache(BucketCache bucketCache, BlockCacheKey blockCacheKey) throws InterruptedException {
        while (!bucketCache.backingMap.containsKey(blockCacheKey) || bucketCache.ramCache.containsKey(blockCacheKey)) {
            Thread.sleep(100L);
        }
        Thread.sleep(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockInBackingMap() throws Exception {
        ByteBuffAllocator alloc = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020, alloc);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testHFile-00", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            TestBucketCacheRefCnt.waitUntilFlushedToCache(this.cache, key);
            Assert.assertEquals((long)1L, (long)blk.refCnt());
            Cacheable block = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((boolean)(block instanceof HFileBlock));
            Assert.assertTrue((((HFileBlock)block).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            block.retain();
            Assert.assertEquals((long)3L, (long)block.refCnt());
            Cacheable newBlock = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((boolean)(newBlock instanceof HFileBlock));
            Assert.assertTrue((((HFileBlock)newBlock).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)newBlock.refCnt());
            Assert.assertFalse((boolean)newBlock.release());
            Assert.assertEquals((long)3L, (long)newBlock.refCnt());
            Assert.assertEquals((long)3L, (long)block.refCnt());
            this.cache.evictBlock(key);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            this.cache.evictBlock(key);
            Assert.assertEquals((long)2L, (long)block.refCnt());
            Assert.assertFalse((boolean)block.release());
            Assert.assertEquals((long)1L, (long)block.refCnt());
            Cacheable newestBlock = this.cache.getBlock(key, false, false, false);
            Assert.assertNull((Object)newestBlock);
            Assert.assertEquals((long)1L, (long)block.refCnt());
            Assert.assertTrue((((HFileBlock)newBlock).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertTrue((boolean)block.release());
            Assert.assertEquals((long)0L, (long)block.refCnt());
            Assert.assertEquals((long)0L, (long)newBlock.refCnt());
        }
        finally {
            this.cache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInBucketCache() throws IOException {
        ByteBuffAllocator alloc = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020, alloc);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testHFile-00", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            Assert.assertTrue((blk.refCnt() == 1 || blk.refCnt() == 2 ? 1 : 0) != 0);
            Cacheable block1 = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((block1.refCnt() >= 2 ? 1 : 0) != 0);
            Assert.assertTrue((((HFileBlock)block1).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Cacheable block2 = this.cache.getBlock(key, false, false, false);
            Assert.assertTrue((((HFileBlock)block2).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
            Assert.assertTrue((block2.refCnt() >= 3 ? 1 : 0) != 0);
            this.cache.evictBlock(key);
            Assert.assertTrue((blk.refCnt() >= 1 ? 1 : 0) != 0);
            Assert.assertTrue((block1.refCnt() >= 2 ? 1 : 0) != 0);
            Assert.assertTrue((block2.refCnt() >= 2 ? 1 : 0) != 0);
            Cacheable block3 = this.cache.getBlock(key, false, false, false);
            if (block3 != null) {
                Assert.assertTrue((((HFileBlock)block3).getByteBuffAllocator() == alloc ? 1 : 0) != 0);
                Assert.assertTrue((block3.refCnt() >= 3 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)block3.release());
            }
            blk.release();
            boolean ret1 = block1.release();
            boolean ret2 = block2.release();
            Assert.assertTrue((ret1 || ret2 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)blk.refCnt());
            Assert.assertEquals((long)0L, (long)block1.refCnt());
            Assert.assertEquals((long)0L, (long)block2.refCnt());
        }
        finally {
            this.cache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarkStaleAsEvicted() throws Exception {
        this.cache = TestBucketCacheRefCnt.create(1, 1000);
        try {
            HFileBlock blk = TestBucketCacheRefCnt.createBlock(200, 1020);
            BlockCacheKey key = TestBucketCacheRefCnt.createKey("testMarkStaleAsEvicted", 200L);
            this.cache.cacheBlock(key, (Cacheable)blk);
            TestBucketCacheRefCnt.waitUntilFlushedToCache(this.cache, key);
            Assert.assertEquals((long)1L, (long)blk.refCnt());
            Assert.assertNotNull(this.cache.backingMap.get(key));
            Assert.assertEquals((long)1L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            Cacheable block1 = this.cache.getBlock(key, false, false, false);
            Assert.assertEquals((long)2L, (long)block1.refCnt());
            BucketEntry be1 = (BucketEntry)this.cache.backingMap.get(key);
            Assert.assertNotNull((Object)be1);
            Assert.assertEquals((long)2L, (long)be1.refCnt());
            Assert.assertFalse((boolean)this.cache.evictBucketEntryIfNoRpcReferenced(key, be1));
            Assert.assertEquals((long)2L, (long)block1.refCnt());
            Assert.assertEquals((long)2L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            block1.release();
            Assert.assertEquals((long)1L, (long)block1.refCnt());
            Assert.assertEquals((long)1L, (long)((BucketEntry)this.cache.backingMap.get(key)).refCnt());
            Assert.assertTrue((boolean)this.cache.evictBucketEntryIfNoRpcReferenced(key, be1));
            Assert.assertEquals((long)0L, (long)block1.refCnt());
            Assert.assertNull(this.cache.backingMap.get(key));
            Assert.assertEquals((long)0L, (long)this.cache.size());
        }
        finally {
            this.cache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplacingBlockAndGettingBlockConcurrently() throws Exception {
        ByteBuffAllocator byteBuffAllocator = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        MyBucketCache myBucketCache = TestBucketCacheRefCnt.createMyBucketCache(1, 1000);
        try {
            HFileBlock hfileBlock = TestBucketCacheRefCnt.createBlock(200, 1020, byteBuffAllocator);
            BlockCacheKey blockCacheKey = TestBucketCacheRefCnt.createKey("testTwoThreadConcurrent", 200L);
            myBucketCache.cacheBlock(blockCacheKey, (Cacheable)hfileBlock);
            TestBucketCacheRefCnt.waitUntilFlushedToCache(myBucketCache, blockCacheKey);
            Assert.assertEquals((long)1L, (long)hfileBlock.refCnt());
            Assert.assertTrue((!myBucketCache.ramCache.containsKey(blockCacheKey) ? 1 : 0) != 0);
            AtomicReference exceptionRef = new AtomicReference();
            Thread cacheBlockThread = new Thread(() -> {
                try {
                    HFileBlock newHFileBlock = TestBucketCacheRefCnt.createBlock(200, 1020, byteBuffAllocator);
                    myBucketCache.cacheBlock(blockCacheKey, (Cacheable)newHFileBlock);
                    TestBucketCacheRefCnt.waitUntilFlushedToCache(myBucketCache, blockCacheKey);
                }
                catch (Throwable exception) {
                    exceptionRef.set(exception);
                }
            });
            cacheBlockThread.setName("_cacheBlockThread");
            cacheBlockThread.start();
            String oldThreadName = Thread.currentThread().getName();
            HFileBlock gotHFileBlock = null;
            try {
                Thread.currentThread().setName("_getBlockThread");
                gotHFileBlock = (HFileBlock)myBucketCache.getBlock(blockCacheKey, false, false, false);
                Assert.assertTrue((boolean)gotHFileBlock.equals((Object)hfileBlock));
                Assert.assertTrue((gotHFileBlock.getByteBuffAllocator() == byteBuffAllocator ? 1 : 0) != 0);
                Assert.assertEquals((long)2L, (long)gotHFileBlock.refCnt());
                myBucketCache.cyclicBarrier.await();
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
            cacheBlockThread.join();
            Assert.assertTrue((exceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)gotHFileBlock.refCnt());
            Assert.assertTrue((boolean)gotHFileBlock.equals((Object)hfileBlock));
            Assert.assertTrue((myBucketCache.overwiteByteBuff == null ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache.freeBucketEntryCounter.get() == 0 ? 1 : 0) != 0);
            gotHFileBlock.release();
            Assert.assertEquals((long)0L, (long)gotHFileBlock.refCnt());
            Assert.assertTrue((myBucketCache.overwiteByteBuff != null ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache.freeBucketEntryCounter.get() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache.replaceCounter.get() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache.blockEvictCounter.get() == 1 ? 1 : 0) != 0);
        }
        finally {
            myBucketCache.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvictingBlockCachingBlockGettingBlockConcurrently() throws Exception {
        ByteBuffAllocator byteBuffAllocator = ByteBuffAllocator.create((Configuration)HBaseConfiguration.create(), (boolean)true);
        MyBucketCache2 myBucketCache2 = TestBucketCacheRefCnt.createMyBucketCache2(1, 1000);
        try {
            HFileBlock hfileBlock = TestBucketCacheRefCnt.createBlock(200, 1020, byteBuffAllocator);
            BlockCacheKey blockCacheKey = TestBucketCacheRefCnt.createKey("testThreeThreadConcurrent", 200L);
            AtomicReference cacheBlockThreadExceptionRef = new AtomicReference();
            Thread cacheBlockThread = new Thread(() -> {
                try {
                    myBucketCache2.cacheBlock(blockCacheKey, (Cacheable)hfileBlock);
                    myBucketCache2.writeThreadDoneCyclicBarrier.await();
                }
                catch (Throwable exception) {
                    cacheBlockThreadExceptionRef.set(exception);
                }
            });
            cacheBlockThread.setName("_cacheBlockThread");
            cacheBlockThread.start();
            AtomicReference evictBlockThreadExceptionRef = new AtomicReference();
            Thread evictBlockThread = new Thread(() -> {
                try {
                    myBucketCache2.evictBlock(blockCacheKey);
                }
                catch (Throwable exception) {
                    evictBlockThreadExceptionRef.set(exception);
                }
            });
            evictBlockThread.setName("_evictBlockThread");
            evictBlockThread.start();
            String oldThreadName = Thread.currentThread().getName();
            HFileBlock gotHFileBlock = null;
            try {
                Thread.currentThread().setName("_getBlockThread");
                gotHFileBlock = (HFileBlock)myBucketCache2.getBlock(blockCacheKey, false, false, false);
                Assert.assertTrue((boolean)gotHFileBlock.equals((Object)hfileBlock));
                Assert.assertTrue((gotHFileBlock.getByteBuffAllocator() == byteBuffAllocator ? 1 : 0) != 0);
                Assert.assertEquals((long)2L, (long)gotHFileBlock.refCnt());
                try {
                    myBucketCache2.putCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
            cacheBlockThread.join();
            evictBlockThread.join();
            Assert.assertTrue((cacheBlockThreadExceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertTrue((evictBlockThreadExceptionRef.get() == null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)gotHFileBlock.equals((Object)hfileBlock));
            Assert.assertEquals((long)1L, (long)gotHFileBlock.refCnt());
            Assert.assertTrue((myBucketCache2.overwiteByteBuff == null ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache2.freeBucketEntryCounter.get() == 0 ? 1 : 0) != 0);
            gotHFileBlock.release();
            Assert.assertEquals((long)0L, (long)gotHFileBlock.refCnt());
            Assert.assertTrue((myBucketCache2.overwiteByteBuff != null ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache2.freeBucketEntryCounter.get() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((myBucketCache2.blockEvictCounter.get() == 1 ? 1 : 0) != 0);
        }
        finally {
            myBucketCache2.shutdown();
        }
    }

    private static ByteBuff getOverwriteByteBuff(BucketEntry bucketEntry) {
        int byteSize = bucketEntry.getLength();
        byte[] data = new byte[byteSize];
        Arrays.fill(data, (byte)-1);
        return ByteBuff.wrap((ByteBuffer)ByteBuffer.wrap(data));
    }

    static class MyBucketCache2
    extends BucketCache {
        private static final String GET_BLOCK_THREAD_NAME = "_getBlockThread";
        private static final String CACHE_BLOCK_THREAD_NAME = "_cacheBlockThread";
        private static final String EVICT_BLOCK_THREAD_NAME = "_evictBlockThread";
        private final CyclicBarrier getCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier evictCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier putCyclicBarrier = new CyclicBarrier(2);
        private final CyclicBarrier writeThreadDoneCyclicBarrier = new CyclicBarrier(3);
        private final AtomicInteger blockEvictCounter = new AtomicInteger(0);
        private final AtomicInteger removeRamCounter = new AtomicInteger(0);
        private final AtomicInteger freeBucketEntryCounter = new AtomicInteger(0);
        private ByteBuff overwiteByteBuff = null;

        public MyBucketCache2(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath) throws IOException {
            super(ioEngineName, capacity, blockSize, bucketSizes, writerThreadNum, writerQLen, persistencePath);
        }

        protected void putIntoBackingMap(BlockCacheKey key, BucketEntry bucketEntry) {
            super.putIntoBackingMap(key, bucketEntry);
            try {
                this.evictCyclicBarrier.await();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            try {
                this.putCyclicBarrier.await();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void doDrain(List<BucketCache.RAMQueueEntry> entries, ByteBuffer metaBuff) throws InterruptedException {
            super.doDrain(entries, metaBuff);
            if (entries.size() > 0) {
                try {
                    this.writeThreadDoneCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
            if (Thread.currentThread().getName().equals(GET_BLOCK_THREAD_NAME)) {
                try {
                    this.getCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            Cacheable result = super.getBlock(key, caching, repeat, updateCacheMetrics);
            return result;
        }

        protected boolean removeFromRamCache(BlockCacheKey cacheKey) {
            boolean firstTime = false;
            if (Thread.currentThread().getName().equals(EVICT_BLOCK_THREAD_NAME)) {
                int count = this.removeRamCounter.incrementAndGet();
                boolean bl = firstTime = count == 1;
                if (firstTime) {
                    try {
                        this.evictCyclicBarrier.await();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            boolean result = super.removeFromRamCache(cacheKey);
            if (Thread.currentThread().getName().equals(EVICT_BLOCK_THREAD_NAME) && firstTime) {
                try {
                    this.getCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                try {
                    this.writeThreadDoneCyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        void blockEvicted(BlockCacheKey cacheKey, BucketEntry bucketEntry, boolean decrementBlockNumber, boolean evictedByEvictionProcess) {
            Assert.assertTrue((Thread.currentThread() == this.writerThreads[0] ? 1 : 0) != 0);
            this.blockEvictCounter.incrementAndGet();
            super.blockEvicted(cacheKey, bucketEntry, decrementBlockNumber, evictedByEvictionProcess);
        }

        void freeBucketEntry(BucketEntry bucketEntry) {
            this.freeBucketEntryCounter.incrementAndGet();
            super.freeBucketEntry(bucketEntry);
            this.overwiteByteBuff = TestBucketCacheRefCnt.getOverwriteByteBuff(bucketEntry);
            try {
                this.ioEngine.write(this.overwiteByteBuff, bucketEntry.offset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class MyBucketCache
    extends BucketCache {
        private static final String GET_BLOCK_THREAD_NAME = "_getBlockThread";
        private static final String CACHE_BLOCK_THREAD_NAME = "_cacheBlockThread";
        private final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
        private final AtomicInteger replaceCounter = new AtomicInteger(0);
        private final AtomicInteger blockEvictCounter = new AtomicInteger(0);
        private final AtomicInteger freeBucketEntryCounter = new AtomicInteger(0);
        private ByteBuff overwiteByteBuff = null;

        public MyBucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath) throws IOException {
            super(ioEngineName, capacity, blockSize, bucketSizes, writerThreadNum, writerQLen, persistencePath);
        }

        protected boolean shouldReplaceExistingCacheBlock(BlockCacheKey cacheKey, Cacheable newBlock) {
            this.replaceCounter.incrementAndGet();
            return true;
        }

        public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
            if (Thread.currentThread().getName().equals(GET_BLOCK_THREAD_NAME)) {
                try {
                    this.cyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            Cacheable result = super.getBlock(key, caching, repeat, updateCacheMetrics);
            return result;
        }

        protected void cacheBlockWithWaitInternal(BlockCacheKey cacheKey, Cacheable cachedItem, boolean inMemory, boolean wait) {
            if (Thread.currentThread().getName().equals(CACHE_BLOCK_THREAD_NAME)) {
                try {
                    this.cyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            if (Thread.currentThread().getName().equals(CACHE_BLOCK_THREAD_NAME)) {
                try {
                    this.cyclicBarrier.await();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            super.cacheBlockWithWaitInternal(cacheKey, cachedItem, inMemory, wait);
        }

        void blockEvicted(BlockCacheKey cacheKey, BucketEntry bucketEntry, boolean decrementBlockNumber, boolean evictedByEvictionProcess) {
            this.blockEvictCounter.incrementAndGet();
            super.blockEvicted(cacheKey, bucketEntry, decrementBlockNumber, evictedByEvictionProcess);
        }

        void freeBucketEntry(BucketEntry bucketEntry) {
            this.freeBucketEntryCounter.incrementAndGet();
            super.freeBucketEntry(bucketEntry);
            this.overwiteByteBuff = TestBucketCacheRefCnt.getOverwriteByteBuff(bucketEntry);
            try {
                this.ioEngine.write(this.overwiteByteBuff, bucketEntry.offset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

