/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MatcherPredicate;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.trace.hamcrest.AttributesMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.EventMatchers;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RPCTests.class, SmallTests.class})
public class TestCallRunner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCallRunner.class);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public OpenTelemetryRule otelRule = OpenTelemetryRule.create();
    private Configuration conf = null;

    @Before
    public void before() {
        HBaseTestingUtility util = new HBaseTestingUtility();
        this.conf = util.getConfiguration();
    }

    @Test
    public void testSimpleCall() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        TraceUtil.trace(() -> {
            CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
            cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            cr.run();
        }, (String)this.testName.getMethodName());
        Waiter.waitFor((Configuration)this.conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
    }

    @Test
    public void testCallCleanup() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)mockCall.disconnectSince()).thenReturn((Object)1L);
        TraceUtil.trace(() -> {
            CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
            cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            cr.run();
        }, (String)this.testName.getMethodName());
        ((ServerCall)Mockito.verify((Object)mockCall, (VerificationMode)Mockito.times((int)1))).cleanup();
    }

    @Test
    public void testCallRunnerDropDisconnected() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)mockCall.disconnectSince()).thenReturn((Object)1L);
        TraceUtil.trace(() -> {
            CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
            cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            cr.drop();
        }, (String)this.testName.getMethodName());
        ((ServerCall)Mockito.verify((Object)mockCall, (VerificationMode)Mockito.times((int)1))).cleanup();
        Waiter.waitFor((Configuration)this.conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)EventMatchers.hasName((String)"Client disconnect detected"))), (Matcher)SpanDataMatchers.hasEnded())));
    }

    @Test
    public void testCallRunnerDropConnected() {
        RpcServerInterface mockRpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        MetricsHBaseServer mockMetrics = (MetricsHBaseServer)Mockito.mock(MetricsHBaseServer.class);
        Mockito.when((Object)mockRpcServer.getMetrics()).thenReturn((Object)mockMetrics);
        Mockito.when((Object)mockRpcServer.isStarted()).thenReturn((Object)true);
        Mockito.when((Object)mockRpcServer.getListenerAddress()).thenReturn((Object)InetSocketAddress.createUnresolved("foo", 60020));
        ServerCall mockCall = (ServerCall)Mockito.mock(ServerCall.class);
        Mockito.when((Object)mockCall.disconnectSince()).thenReturn((Object)-1L);
        TraceUtil.trace(() -> {
            CallRunner cr = new CallRunner(mockRpcServer, (RpcCall)mockCall);
            cr.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            cr.drop();
        }, (String)this.testName.getMethodName());
        ((ServerCall)Mockito.verify((Object)mockCall, (VerificationMode)Mockito.times((int)1))).cleanup();
        ((MetricsHBaseServer)Mockito.verify((Object)mockMetrics)).exception((Throwable)Mockito.any(CallDroppedException.class));
        Waiter.waitFor((Configuration)this.conf, (long)TimeUnit.SECONDS.toMillis(5L), (Waiter.Predicate)new MatcherPredicate(() -> ((OpenTelemetryRule)this.otelRule).getSpans(), Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasEnded()))));
        MatcherAssert.assertThat((Object)this.otelRule.getSpans(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)this.testName.getMethodName()), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.ERROR), (Matcher)SpanDataMatchers.hasEvents((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)EventMatchers.hasName((String)"exception"), (Matcher)EventMatchers.hasAttributes((Matcher)AttributesMatchers.containsEntry((String)"exception.type", (String)CallDroppedException.class.getName()))))), (Matcher)SpanDataMatchers.hasEnded())));
    }
}

