/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRegionBypass {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionBypass.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionBypass.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private TableName tableName;

    @BeforeClass
    public static void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"cf"));
    }

    @Test
    public void testBypass() throws IOException, InterruptedException {
        Admin admin = TEST_UTIL.getAdmin();
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        List regions = admin.getRegions(this.tableName);
        for (Object ri : regions) {
            admin.unassign(ri.getRegionName(), false);
        }
        ArrayList<Long> pids = new ArrayList<Long>(regions.size());
        for (RegionInfo ri : regions) {
            StallingAssignProcedure p = new StallingAssignProcedure(env, ri, null, false, TransitRegionStateProcedure.TransitionType.ASSIGN);
            pids.add(TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)p));
        }
        for (Long pid : pids) {
            while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().isStarted(pid.longValue())) {
                Thread.sleep(100L);
            }
        }
        List ps = TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getProcedures();
        for (StallingAssignProcedure p : ps) {
            if (!(p instanceof StallingAssignProcedure)) continue;
            List bs = TEST_UTIL.getHbck().bypassProcedure(Arrays.asList(p.getProcId()), 1000L, true, false);
            for (Boolean b : bs) {
                LOG.info("BYPASSED {} {}", (Object)p.getProcId(), (Object)b);
            }
        }
        for (RegionInfo ri : regions) {
            try {
                admin.assign(ri.getRegionName());
            }
            catch (Throwable dnrioe) {
                LOG.info("Expected {}", dnrioe);
            }
        }
        while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
            Thread.sleep(100L);
        }
        for (RegionInfo ri : regions) {
            TEST_UTIL.getHbck().assigns(Arrays.asList(ri.getEncodedName()), true);
        }
        while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
            Thread.sleep(100L);
        }
        for (RegionInfo ri : regions) {
            Assert.assertTrue((String)ri.toString(), (boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionOnline(ri));
        }
    }

    public static class StallingAssignProcedure
    extends TransitRegionStateProcedure {
        public final CountDownLatch latch = new CountDownLatch(2);

        public StallingAssignProcedure() {
        }

        public StallingAssignProcedure(MasterProcedureEnv env, RegionInfo hri, ServerName assignCandidate, boolean forceNewPlan, TransitRegionStateProcedure.TransitionType type) {
            super(env, hri, assignCandidate, forceNewPlan, type);
            this.init(env);
        }

        private void init(MasterProcedureEnv env) {
            RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegion());
            regionNode.setProcedure((TransitRegionStateProcedure)this);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RegionStateTransitionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            switch (state) {
                case REGION_STATE_TRANSITION_GET_ASSIGN_CANDIDATE: {
                    LOG.info("LATCH1 {}", (Object)this.latch.getCount());
                    this.latch.countDown();
                    this.setNextState(MasterProcedureProtos.RegionStateTransitionState.REGION_STATE_TRANSITION_OPEN);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case REGION_STATE_TRANSITION_OPEN: {
                    if (this.latch.getCount() == 0L) {
                        LOG.info("LATCH3 {}", (Object)this.latch.getCount());
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.info("LATCH2 {}", (Object)this.latch.getCount());
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
    }
}

