/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.FastPathRpcHandler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RWQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcHandler;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class FastPathRWQueueRpcExecutor
extends RWQueueRpcExecutor {
    private final Deque<FastPathRpcHandler> readHandlerStack = new ConcurrentLinkedDeque<FastPathRpcHandler>();
    private final Deque<FastPathRpcHandler> writeHandlerStack = new ConcurrentLinkedDeque<FastPathRpcHandler>();
    private final Deque<FastPathRpcHandler> scanHandlerStack = new ConcurrentLinkedDeque<FastPathRpcHandler>();

    public FastPathRWQueueRpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, maxQueueLength, priority, conf, abortable);
    }

    @Override
    protected RpcHandler getHandler(String name, double handlerFailureThreshhold, int handlerCount, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, AtomicInteger failedHandlerCount, Abortable abortable) {
        Deque<FastPathRpcHandler> handlerStack = name.contains("read") ? this.readHandlerStack : (name.contains("write") ? this.writeHandlerStack : this.scanHandlerStack);
        return new FastPathRpcHandler(name, handlerFailureThreshhold, handlerCount, q, activeHandlerCount, failedHandlerCount, abortable, handlerStack);
    }

    @Override
    public boolean dispatch(CallRunner callTask) {
        RpcCall call = callTask.getRpcCall();
        boolean shouldDispatchToWriteQueue = this.isWriteRequest(call.getHeader(), call.getParam());
        boolean shouldDispatchToScanQueue = this.shouldDispatchToScanQueue(callTask);
        FastPathRpcHandler handler = shouldDispatchToWriteQueue ? this.writeHandlerStack.poll() : (shouldDispatchToScanQueue ? this.scanHandlerStack.poll() : this.readHandlerStack.poll());
        return handler != null ? handler.loadCallRunner(callTask) : this.dispatchTo(shouldDispatchToWriteQueue, shouldDispatchToScanQueue, callTask);
    }
}

