// Autogenerated Jamon implementation
// /home/taklwu/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 27, 1
import java.util.*;
// 28, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 29, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 30, 1
import org.apache.hadoop.hbase.ServerName;
// 31, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 32, 1
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
// 33, 1
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
// 34, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.ServerInfo;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String bcn;
  private final String bcv;
  private final String filter;
  private final String format;
  // 56, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = regionServer.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getBcn__IsNotDefault())
    {
      p_implData.setBcn("");
    }
    if(! p_implData.getBcv__IsNotDefault())
    {
      p_implData.setBcv("");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    bcn = p_implData.getBcn();
    bcv = p_implData.getBcv();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 39, 1
    if (format.equals("json") && bcn != null && bcn.length() > 0  )
    {
      // 39, 66
      jamonWriter.write("\n  ");
      // 40, 3
      {
        org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl(this.getTemplateManager());
        __jamon__var_8.renderNoFlush(jamonWriter, new CacheConfig(regionServer.getConfiguration()), regionServer.getConfiguration(), bcn, bcv, regionServer.getBlockCache().orElse(null)  );
      }
      // 40, 210
      jamonWriter.write("\n  ");
      // 41, 3
      return; 
    }
    // 42, 1
    else if (format.equals("json") )
    {
      // 42, 34
      jamonWriter.write("\n  ");
      // 43, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_9.setFilter(filter);
        __jamon__var_9.setFormat("json" );
        __jamon__var_9.renderNoFlush(jamonWriter);
      }
      // 43, 68
      jamonWriter.write("\n  ");
      // 44, 3
      return; 
    }
    // 45, 7
    jamonWriter.write("\n");
    // 46, 1
    
  ServerInfo serverInfo = ProtobufUtil.getServerInfo(null, regionServer.getRSRpcServices());
  ServerName serverName = ProtobufUtil.toServerName(serverInfo.getServerName());
  List<RegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(regionServer.getRSRpcServices());
  MasterAddressTracker masterAddressTracker = regionServer.getMasterAddressTracker();
  ServerName masterServerName = masterAddressTracker == null ? null
    : masterAddressTracker.getMasterAddress();
  int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();

    // 83, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
    // 88, 33
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
    // 88, 63
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/rs-status\">Home</a></li>\n                <li><a href=\"/processRS.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/rsOperationDetails.jsp\">Operation Details</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 119, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 119, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 121, 23
    jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
    // 131, 37
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 131, 53
    jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
    // 138, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl(this.getTemplateManager());
      __jamon__var_10.renderNoFlush(jamonWriter, regionServer.getMetrics().getRegionServerWrapper(), regionServer.getRpcServer().getMetrics().getHBaseServerWrapper(), regionServer.getRpcServer().getByteBuffAllocator());
    }
    // 140, 75
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Block Cache</h2>\n    ");
    // 145, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl(this.getTemplateManager());
      __jamon__var_11.renderNoFlush(jamonWriter, new CacheConfig(regionServer.getConfiguration()), regionServer.getConfiguration(), regionServer.getBlockCache().orElse(null) );
    }
    // 145, 179
    jamonWriter.write("\n    </section>\n\n    <section>\n    ");
    // 149, 5
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_12.setFilter(filter);
      __jamon__var_12.setParent("/rs-status" );
      __jamon__var_12.renderNoFlush(jamonWriter);
    }
    // 149, 76
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
    // 154, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl __jamon__var_13 = new org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl(this.getTemplateManager());
      __jamon__var_13.renderNoFlush(jamonWriter, regionServer, onlineRegions);
    }
    // 154, 86
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Replication Status</h1>\n    ");
    // 159, 5
    {
      org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl __jamon__var_14 = new org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl(this.getTemplateManager());
      __jamon__var_14.renderNoFlush(jamonWriter, regionServer);
    }
    // 159, 62
    jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>JVM Version</td>\n            <td>");
    // 172, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(JvmVersion.getVersion()), jamonWriter);
    // 172, 46
    jamonWriter.write("</td>\n            <td>JVM vendor and version</td>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
    // 177, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 177, 76
    jamonWriter.write(", revision=");
    // 177, 87
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 177, 147
    jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
    // 182, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 182, 73
    jamonWriter.write(", ");
    // 182, 75
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 182, 131
    jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>HBase Source Checksum</td>\n            <td>");
    // 187, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 187, 80
    jamonWriter.write("</td>\n            <td>HBase source SHA512 checksum</td>\n        </tr>\n        <tr>\n            <td>Hadoop Version</td>\n            <td>");
    // 192, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 192, 70
    jamonWriter.write(", revision=");
    // 192, 81
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 192, 135
    jamonWriter.write("</td>\n            <td>Hadoop version and revision</td>\n        </tr>\n        <tr>\n            <td>Hadoop Compiled</td>\n            <td>");
    // 197, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 197, 67
    jamonWriter.write(", ");
    // 197, 69
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 197, 119
    jamonWriter.write("</td>\n            <td>When Hadoop version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Hadoop Source Checksum</td>\n            <td>");
    // 202, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 202, 74
    jamonWriter.write("</td>\n            <td>Hadoop source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Version</td>\n            <td>");
    // 207, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 207, 64
    jamonWriter.write(", revision=");
    // 207, 75
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevisionHash()), jamonWriter);
    // 207, 127
    jamonWriter.write("</td>\n            <td>ZooKeeper client version and revision hash</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Compiled</td>\n            <td>");
    // 212, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 212, 66
    jamonWriter.write("</td>\n            <td>When ZooKeeper client version was compiled</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Quorum</td>\n            <td>");
    // 218, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 218, 39
    jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
    // 223, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getRegionServerCoprocessors())), jamonWriter);
    // 223, 92
    jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
    // 228, 17
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 228, 60
    jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
    // 234, 17
    if (masterServerName == null )
    {
      // 234, 49
      jamonWriter.write("\n                No master found\n                ");
    }
    // 236, 17
    else
    {
      // 236, 24
      jamonWriter.write("\n                ");
      // 237, 17
      
                String host = masterServerName.getHostname() + ":" + infoPort;
                String url = "//" + host + "/master-status";
                
      // 241, 17
      jamonWriter.write("<a href=\"");
      // 241, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 241, 35
      jamonWriter.write("\">");
      // 241, 37
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 241, 47
      jamonWriter.write("</a>\n                ");
    }
    // 242, 23
    jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n<script>\n$(document).ready(function()\n    {\n        $.tablesorter.addParser({\n            id: 'filesize',\n            is: function(s) {\n                return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n            },\n            format: function(s) {\n                var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                switch(suf) {\n                    case 'B':\n                        return num;\n                    case 'KB':\n                        return num * 1024;\n                    case 'MB':\n                        return num * 1024 * 1024;\n                    case 'GB':\n                        return num * 1024 * 1024 * 1024;\n                    case 'TB':\n                        return num * 1024 * 1024 * 1024 * 1024;\n                }\n            },\n            type: 'numeric'\n        });\n        $.tablesorter.addParser(\n        {\n            id: \"separator\",\n            is: function (s) {\n                return /^[0-9]?[0-9,]*$/.test(s);\n            },\n            format: function (s) {\n                return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n            },\n            type: \"numeric\"\n        });\n\n        $(\"#baseStatsTable\").tablesorter();\n        $(\"#requestStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'}\n            }\n        });\n        $(\"#storeStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'},\n                3: {sorter: 'filesize'},\n                4: {sorter: 'filesize'},\n                5: {sorter: 'filesize'},\n                6: {sorter: 'filesize'}\n            }\n        });\n        $(\"#compactionStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'},\n                2: {sorter: 'separator'}\n            }\n        });\n        $(\"#memstoreStatsTable\").tablesorter({\n            headers: {\n                1: {sorter: 'filesize'}\n            }\n        });\n    }\n);\n</script>\n</body>\n</html>\n");
  }
  
  
}
