// Autogenerated Jamon implementation
// /home/taklwu/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/ServerMetricsTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 25, 1
import java.util.*;
// 26, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 1
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
// 28, 1
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
// 29, 1
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
// 30, 1
import org.apache.hadoop.hbase.util.Bytes;
// 31, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 32, 1
import org.apache.hadoop.hbase.ServerName;
// 33, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 34, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 35, 1
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 36, 1
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 37, 1
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
// 38, 1
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;
// 39, 1
import java.lang.management.MemoryUsage;
// 40, 1
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;

public class ServerMetricsTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.Intf

{
  private final MetricsRegionServerWrapper mWrap;
  private final MetricsHBaseServerWrapper mServerWrap;
  private final ByteBuffAllocator bbAllocator;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public ServerMetricsTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    mWrap = p_implData.getMWrap();
    mServerWrap = p_implData.getMServerWrap();
    bbAllocator = p_implData.getBbAllocator();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 42, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_walStats\" data-toggle=\"tab\">WALs</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n        <li class=\"\"><a href=\"#tab_byteBuffAllocatorStats\" data-toggle=\"tab\">ByteBuffAllocator Stats</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
    // 54, 13
    {
      // 54, 13
      __jamon_innerUnit__baseStats(jamonWriter, mWrap );
    }
    // 54, 43
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
    // 57, 13
    {
      // 57, 13
      __jamon_innerUnit__memoryStats(jamonWriter, mWrap );
    }
    // 57, 45
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
    // 60, 13
    {
      // 60, 13
      __jamon_innerUnit__requestStats(jamonWriter, mWrap );
    }
    // 60, 46
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_walStats\">\n            ");
    // 63, 13
    {
      // 63, 13
      __jamon_innerUnit__walStats(jamonWriter, mWrap );
    }
    // 63, 42
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
    // 66, 13
    {
      // 66, 13
      __jamon_innerUnit__storeStats(jamonWriter, mWrap );
    }
    // 66, 44
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
    // 69, 13
    {
      // 69, 13
      __jamon_innerUnit__queueStats(jamonWriter, mWrap, mServerWrap);
    }
    // 69, 72
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_byteBuffAllocatorStats\">\n            ");
    // 72, 13
    {
      // 72, 13
      __jamon_innerUnit__byteBuffAllocatorStats(jamonWriter, bbAllocator);
    }
    // 72, 69
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 77, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 81, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Block locality (Secondary replicas)</th>\n        <th>Slow WAL Append Count</th>\n    </tr>\n    <tr>\n        <td>");
    // 91, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 91, 70
    jamonWriter.write("</td>\n        <td>");
    // 92, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumOnlineRegions()), jamonWriter);
    // 92, 46
    jamonWriter.write("</td>\n        <td>");
    // 93, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f",mWrap.getPercentFileLocal())), jamonWriter);
    // 93, 68
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 93, 77
    jamonWriter.write("</td>\n        <td>");
    // 94, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f",mWrap.getPercentFileLocalSecondaryRegions())), jamonWriter);
    // 94, 84
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 94, 93
    jamonWriter.write("</td>\n        <td>");
    // 95, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumWALSlowAppend()), jamonWriter);
    // 95, 46
    jamonWriter.write("</td>\n    </tr>\n</table>\n");
  }
  
  
  // 247, 1
  private void __jamon_innerUnit__byteBuffAllocatorStats(final java.io.Writer jamonWriter, final ByteBuffAllocator bbAllocator)
    throws java.io.IOException
  {
    // 251, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Total Heap Allocation</th>\n    <th>Total Pool Allocation</th>\n    <th>Heap Allocation Ratio</th>\n    <th>Total Buffer Count</th>\n    <th>Used Buffer Count</th>\n    <th>Buffer Size</th>\n</tr>\n<tr>\n    <td>");
    // 261, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(ByteBuffAllocator.getHeapAllocationBytes(bbAllocator, ByteBuffAllocator.HEAP), "B", 1)), jamonWriter);
    // 261, 137
    jamonWriter.write("</td>\n    <td>");
    // 262, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bbAllocator.getPoolAllocationBytes(), "B", 1)), jamonWriter);
    // 262, 96
    jamonWriter.write("</td>\n    <td>");
    // 263, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.3f", ByteBuffAllocator.getHeapAllocationRatio(bbAllocator, ByteBuffAllocator.HEAP) * 100)), jamonWriter);
    // 263, 121
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 263, 130
    jamonWriter.write("</td>\n    <td>");
    // 264, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bbAllocator.getTotalBufferCount()), jamonWriter);
    // 264, 48
    jamonWriter.write("</td>\n    <td>");
    // 265, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bbAllocator.getUsedBufferCount()), jamonWriter);
    // 265, 47
    jamonWriter.write("</td>\n    <td>");
    // 266, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bbAllocator.getBufferSize(), "B", 1)), jamonWriter);
    // 266, 87
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 100, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 104, 1
    long usedHeap = -1L;
  long maxHeap = -1L;
  final MemoryUsage usage = MemorySizeUtil.safeGetHeapMemoryUsage();
  if (usage != null) {
    maxHeap = usage.getMax();
    usedHeap = usage.getUsed();
  }

    // 113, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore On-Heap Size / Limit</th>\n        <th>Memstore Off-Heap Size / Limit</th>\n        <th>Memstore Data Size (On&&Off Heap)</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
    // 127, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(usedHeap, "B", 1)), jamonWriter);
    // 127, 68
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 130, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(maxHeap, "B", 1)), jamonWriter);
    // 130, 67
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 133, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemoryUsage(), "B", 1)), jamonWriter);
    // 133, 100
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 136, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(DirectMemoryUtils.getDirectMemorySize(), "B", 1)), jamonWriter);
    // 136, 99
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 139, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getOnHeapMemStoreSize(), "B", 1) + " / "
         + TraditionalBinaryPrefix.long2String(mWrap.getOnHeapMemStoreLimit(), "B", 1)), jamonWriter);
    // 140, 90
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 143, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getOffHeapMemStoreSize(), "B", 1) + " / "
         + TraditionalBinaryPrefix.long2String(mWrap.getOffHeapMemStoreLimit(), "B", 1)), jamonWriter);
    // 144, 91
    jamonWriter.write("\n    </td>\n    <td>\n        ");
    // 147, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getMemStoreSize(), "B", 1)), jamonWriter);
    // 147, 83
    jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
  }
  
  
  // 221, 1
  private void __jamon_innerUnit__queueStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap, final MetricsHBaseServerWrapper mServerWrap)
    throws java.io.IOException
  {
    // 226, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Length</th>\n    <th>Flush Queue Length</th>\n    <th>Priority Call Queue Length</th>\n    <th>General Call Queue Length</th>\n    <th>Replication Call Queue Length</th>\n    <th>Total Call Queue Size</th>\n\n</tr>\n<tr>\n    <td>");
    // 237, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getCompactionQueueSize()), jamonWriter);
    // 237, 45
    jamonWriter.write("</td>\n    <td>");
    // 238, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getFlushQueueSize()), jamonWriter);
    // 238, 40
    jamonWriter.write("</td>\n    <td>");
    // 239, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getPriorityQueueLength()), jamonWriter);
    // 239, 51
    jamonWriter.write("</td>\n    <td>");
    // 240, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getGeneralQueueLength()), jamonWriter);
    // 240, 50
    jamonWriter.write("</td>\n    <td>");
    // 241, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mServerWrap.getReplicationQueueLength()), jamonWriter);
    // 241, 54
    jamonWriter.write("</td>\n    <td>");
    // 242, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mServerWrap.getTotalQueueSize(), "B", 1)), jamonWriter);
    // 242, 91
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 201, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 205, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
    // 213, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
    // 213, 66
    jamonWriter.write("</td>\n    <td>");
    // 214, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getReadRequestsCount()), jamonWriter);
    // 214, 43
    jamonWriter.write("</td>\n    <td>");
    // 215, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getFilteredReadRequestsCount()), jamonWriter);
    // 215, 51
    jamonWriter.write("</td>\n    <td>");
    // 216, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getWriteRequestsCount()), jamonWriter);
    // 216, 44
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 177, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 181, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n<tr>\n    <td>");
    // 191, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumStores()), jamonWriter);
    // 191, 35
    jamonWriter.write("</td>\n    <td>");
    // 192, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumStoreFiles()), jamonWriter);
    // 192, 39
    jamonWriter.write("</td>\n    <td>");
    // 193, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getStoreFileIndexSize(), "B", 1)), jamonWriter);
    // 193, 89
    jamonWriter.write("</td>\n    <td>");
    // 194, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticIndexSize(), "B", 1)), jamonWriter);
    // 194, 91
    jamonWriter.write("</td>\n    <td>");
    // 195, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getTotalStaticBloomSize(), "B", 1)), jamonWriter);
    // 195, 91
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 153, 1
  private void __jamon_innerUnit__walStats(final java.io.Writer jamonWriter, final MetricsRegionServerWrapper mWrap)
    throws java.io.IOException
  {
    // 157, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. WAL Files</th>\n        <th>Size. WAL Files</th>\n        <th>WAL exclude DNs</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
    // 166, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(mWrap.getNumWALFiles()), jamonWriter);
    // 166, 37
    jamonWriter.write("</td>\n    <td>");
    // 167, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(mWrap.getWALFileSize(), "B", 1)), jamonWriter);
    // 167, 82
    jamonWriter.write("</td>\n    <td>\n        ");
    // 169, 9
    for (String exclude: mWrap.getWALExcludeDNs() )
    {
      // 169, 58
      jamonWriter.write("\n            ");
      // 170, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(exclude), jamonWriter);
      // 170, 26
      jamonWriter.write("<br>\n        ");
    }
    // 171, 16
    jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
  }
  
  
}
