/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.mockito.Mockito;

public class HConnectionTestingUtility {
    public static ClusterConnection getMockedConnection(Configuration conf) throws ZooKeeperConnectionException {
        ConnectionImplementation connection = (ConnectionImplementation)Mockito.mock(ConnectionImplementation.class);
        Mockito.when((Object)connection.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)connection.getRpcControllerFactory()).thenReturn(Mockito.mock(RpcControllerFactory.class));
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
        Mockito.when((Object)connection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        return connection;
    }

    public static ClusterConnection getMockedConnectionAndDecorate(Configuration conf, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client, ServerName sn, RegionInfo hri) throws IOException {
        ConnectionImplementation c = (ConnectionImplementation)Mockito.mock(ConnectionImplementation.class);
        Mockito.when((Object)c.getConfiguration()).thenReturn((Object)conf);
        ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration(conf);
        Mockito.when((Object)c.getConnectionConfiguration()).thenReturn((Object)connectionConfiguration);
        ((ConnectionImplementation)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(hri, sn);
        Mockito.when((Object)c.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyInt())).thenReturn((Object)new RegionLocations(new HRegionLocation[]{loc}));
        if (admin != null) {
            Mockito.when((Object)c.getAdmin((ServerName)Mockito.any())).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)c.getClient((ServerName)Mockito.any())).thenReturn((Object)client);
        }
        NonceGenerator ng = (NonceGenerator)Mockito.mock(NonceGenerator.class);
        Mockito.when((Object)c.getNonceGenerator()).thenReturn((Object)ng);
        AsyncProcess asyncProcess = new AsyncProcess((ClusterConnection)c, conf, RpcRetryingCallerFactory.instantiate((Configuration)conf, (MetricsConnection)c.getConnectionMetrics()), RpcControllerFactory.instantiate((Configuration)conf));
        Mockito.when((Object)c.getAsyncProcess()).thenReturn((Object)asyncProcess);
        Mockito.when((Object)c.getNewRpcRetryingCallerFactory(conf)).thenReturn((Object)RpcRetryingCallerFactory.instantiate((Configuration)conf, (RetryingCallerInterceptor)RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null, null));
        Mockito.when((Object)c.getRpcControllerFactory()).thenReturn(Mockito.mock(RpcControllerFactory.class));
        Table t = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)c.getTable((TableName)Mockito.any())).thenReturn((Object)t);
        ResultScanner rs = (ResultScanner)Mockito.mock(ResultScanner.class);
        Mockito.when((Object)t.getScanner((Scan)Mockito.any())).thenReturn((Object)rs);
        return c;
    }

    public static ClusterConnection getSpiedConnection(Configuration conf) throws IOException {
        ConnectionImplementation connection = (ConnectionImplementation)Mockito.spy((Object)new ConnectionImplementation(conf, null, null));
        return connection;
    }

    public static class SleepAtFirstRpcCall
    implements RegionCoprocessor,
    RegionObserver {
        static final AtomicLong ct = new AtomicLong(0L);
        static final String SLEEP_TIME_CONF_KEY = "hbase.coprocessor.SleepAtFirstRpcCall.sleepTime";
        static final long DEFAULT_SLEEP_TIME = 2000L;
        static final AtomicLong sleepTime = new AtomicLong(2000L);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            Configuration conf = env.getConfiguration();
            sleepTime.set(conf.getLong(SLEEP_TIME_CONF_KEY, 2000L));
        }

        public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment, Result result) throws IOException {
            if (ct.incrementAndGet() == 1L) {
                Threads.sleep((long)sleepTime.get());
            }
            return result;
        }

        public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append, Result result) throws IOException {
            if (ct.incrementAndGet() == 1L) {
                Threads.sleep((long)sleepTime.get());
            }
            return result;
        }
    }
}

