// Autogenerated Jamon implementation
// /home/apurtell/tmp/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/BackupMasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 23, 1
import java.util.*;
// 24, 1
import org.apache.hadoop.hbase.ServerName;
// 25, 1
import org.apache.hadoop.hbase.ClusterMetrics;
// 26, 1
import org.apache.hadoop.hbase.master.HMaster;
// 27, 1
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;

public class BackupMasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.Intf

{
  private final HMaster master;
  protected static org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public BackupMasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 29, 1
    if ((!master.isActiveMaster()) )
    {
      // 29, 35
      jamonWriter.write("\n    ");
      // 30, 5
      
    ServerName active_master = master.getActiveMaster().orElse(null);
    Preconditions.checkState(active_master != null, "Failed to retrieve active master's ServerName!");
    int activeInfoPort = master.getActiveMasterInfoPort();
    
      // 35, 5
      jamonWriter.write("<div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Backup Master <small>");
      // 37, 38
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 37, 80
      jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <h4>Current Active Master: <a href=\"//");
      // 40, 43
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active_master.getHostname()), jamonWriter);
      // 40, 76
      jamonWriter.write(":");
      // 40, 77
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(activeInfoPort), jamonWriter);
      // 40, 97
      jamonWriter.write("/master-status\"\n        target=\"_blank\">");
      // 41, 25
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active_master.getHostname()), jamonWriter);
      // 41, 58
      jamonWriter.write("</a><h4>\n");
    }
    // 42, 1
    else
    {
      // 42, 8
      jamonWriter.write("\n    <h2>Backup Masters</h2>\n\n    <table class=\"table table-striped\">\n    <tr>\n        <th>ServerName</th>\n        <th>Port</th>\n        <th>Start Time</th>\n    </tr>\n    ");
      // 51, 5
      
    Collection<ServerName> backup_masters = master.getBackupMasters();
    ServerName [] backupServerNames = backup_masters.toArray(new ServerName[backup_masters.size()]);
    Arrays.sort(backupServerNames);
    for (ServerName serverName : backupServerNames) {
      int infoPort = master.getBackupMasterInfoPort(serverName);
    
      // 58, 5
      jamonWriter.write("<tr>\n        <td><a href=\"//");
      // 59, 24
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
      // 59, 54
      jamonWriter.write(":");
      // 59, 55
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(infoPort), jamonWriter);
      // 59, 69
      jamonWriter.write("/master-status\"\n            target=\"_blank\">");
      // 60, 29
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
      // 60, 59
      jamonWriter.write("</a>\n        </td>\n        <td>");
      // 62, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getPort()), jamonWriter);
      // 62, 39
      jamonWriter.write("</td>\n        <td>");
      // 63, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(serverName.getStartcode())), jamonWriter);
      // 63, 54
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 65, 5
      
    }
    
      // 68, 5
      jamonWriter.write("<tr><td>Total:");
      // 68, 19
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(backupServerNames.length), jamonWriter);
      // 68, 49
      jamonWriter.write("</td>\n    </table>\n");
    }
    // 70, 7
    jamonWriter.write("\n");
  }
  
  
}
