/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.SerialReplicationChecker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestSerialReplicationChecker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSerialReplicationChecker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String PEER_ID = "1";
    private static ReplicationQueueStorage QUEUE_STORAGE;
    private static String WAL_FILE_NAME;
    private Connection conn;
    private SerialReplicationChecker checker;
    @Rule
    public final TestName name = new TestName();
    private TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
        QUEUE_STORAGE = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)UTIL.getConfiguration());
        QUEUE_STORAGE.addWAL(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_ID, WAL_FILE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.getPeerId()).thenReturn((Object)PEER_ID);
        Mockito.when((Object)source.getReplicationQueueStorage()).thenReturn((Object)QUEUE_STORAGE);
        this.conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.conn.isClosed()).thenReturn((Object)false);
        ((Connection)Mockito.doAnswer((Answer)new Answer<Table>(){

            public Table answer(InvocationOnMock invocation) throws Throwable {
                return UTIL.getConnection().getTable((TableName)invocation.getArgument(0));
            }
        }).when((Object)this.conn)).getTable((TableName)ArgumentMatchers.any(TableName.class));
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)source.getServer()).thenReturn((Object)server);
        this.checker = new SerialReplicationChecker(UTIL.getConfiguration(), source);
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    private WAL.Entry createEntry(RegionInfo region, long seqId) {
        WALKeyImpl key = (WALKeyImpl)Mockito.mock(WALKeyImpl.class);
        Mockito.when((Object)key.getTableName()).thenReturn((Object)this.tableName);
        Mockito.when((Object)key.getEncodedRegionName()).thenReturn((Object)region.getEncodedNameAsBytes());
        Mockito.when((Object)key.getSequenceId()).thenReturn((Object)seqId);
        WAL.Entry entry = (WAL.Entry)Mockito.mock(WAL.Entry.class);
        Mockito.when((Object)entry.getKey()).thenReturn((Object)key);
        return entry;
    }

    private Cell createCell(RegionInfo region) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(region.getStartKey()).setType(Cell.Type.Put).build();
    }

    @Test
    public void testNoBarrierCanPush() throws IOException {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 100L), this.createCell(region)));
    }

    private void addStateAndBarrier(RegionInfo region, RegionState.State state, long ... barriers) throws IOException {
        Put put = new Put(region.getRegionName(), EnvironmentEdgeManager.currentTime());
        if (state != null) {
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)state.name()));
        }
        for (int i = 0; i < barriers.length; ++i) {
            put.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER, put.getTimeStamp() - (long)barriers.length + (long)i, Bytes.toBytes((long)barriers[i]));
        }
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    private void setState(RegionInfo region, RegionState.State state) throws IOException {
        Put put = new Put(region.getRegionName(), EnvironmentEdgeManager.currentTime());
        put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)state.name()));
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    private void updatePushedSeqId(RegionInfo region, long seqId) throws ReplicationException {
        QUEUE_STORAGE.setWALPosition(UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName(), PEER_ID, WAL_FILE_NAME, 10L, (Map)ImmutableMap.of((Object)region.getEncodedName(), (Object)seqId));
    }

    private void addParents(RegionInfo region, List<RegionInfo> parents) throws IOException {
        Put put = new Put(region.getRegionName(), EnvironmentEdgeManager.currentTime());
        put.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, MetaTableAccessor.REPLICATION_PARENT_QUALIFIER, MetaTableAccessor.getParentsBytes(parents));
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    @Test
    public void testLastRegionAndOpeningCanNotPush() throws IOException, ReplicationException {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        this.addStateAndBarrier(region, RegionState.State.OPEN, 10L);
        Cell cell = this.createCell(region);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 100L), cell));
        this.setState(region, RegionState.State.OPENING);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 102L), cell));
        this.addStateAndBarrier(region, RegionState.State.OPEN, 50L);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 102L), cell));
        this.updatePushedSeqId(region, 49L);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 102L), cell));
        this.setState(region, RegionState.State.OPENING);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 104L), cell));
    }

    @Test
    public void testCanPushUnder() throws IOException, ReplicationException {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        this.addStateAndBarrier(region, RegionState.State.OPEN, 10L, 100L);
        this.updatePushedSeqId(region, 9L);
        Cell cell = this.createCell(region);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 20L), cell));
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.any(TableName.class));
        for (int i = 22; i < 100; i += 2) {
            Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, i), cell));
        }
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.any(TableName.class));
    }

    @Test
    public void testCanPushIfContinuous() throws IOException, ReplicationException {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        this.addStateAndBarrier(region, RegionState.State.OPEN, 10L);
        this.updatePushedSeqId(region, 9L);
        Cell cell = this.createCell(region);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 20L), cell));
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.any(TableName.class));
        for (int i = 21; i < 100; ++i) {
            Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, i), cell));
        }
        ((Connection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).getTable((TableName)ArgumentMatchers.any(TableName.class));
    }

    @Test
    public void testCanPushAfterMerge() throws IOException, ReplicationException {
        byte[] endKey = new byte[]{-1, 0, -1, -1, 1};
        RegionInfo regionA = RegionInfoBuilder.newBuilder((TableName)this.tableName).setEndKey(endKey).setRegionId(1L).build();
        RegionInfo regionB = RegionInfoBuilder.newBuilder((TableName)this.tableName).setStartKey(endKey).setRegionId(2L).build();
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).setRegionId(3L).build();
        this.addStateAndBarrier(regionA, null, 10L, 100L);
        this.addStateAndBarrier(regionB, null, 20L, 200L);
        this.addStateAndBarrier(region, RegionState.State.OPEN, 200L);
        this.addParents(region, Arrays.asList(regionA, regionB));
        Cell cell = this.createCell(region);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 300L), cell));
        this.updatePushedSeqId(regionB, 199L);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 300L), cell));
        this.updatePushedSeqId(regionA, 99L);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 300L), cell));
    }

    @Test
    public void testCanPushAfterSplit() throws IOException, ReplicationException {
        byte[] endKey = new byte[]{-1, 0, -1, -1, 1};
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).setRegionId(1L).build();
        RegionInfo regionA = RegionInfoBuilder.newBuilder((TableName)this.tableName).setEndKey(endKey).setRegionId(2L).build();
        RegionInfo regionB = RegionInfoBuilder.newBuilder((TableName)this.tableName).setStartKey(endKey).setRegionId(3L).build();
        this.addStateAndBarrier(region, null, 10L, 100L);
        this.addStateAndBarrier(regionA, RegionState.State.OPEN, 100L, 200L);
        this.addStateAndBarrier(regionB, RegionState.State.OPEN, 100L, 300L);
        this.addParents(regionA, Arrays.asList(region));
        this.addParents(regionB, Arrays.asList(region));
        Cell cellA = this.createCell(regionA);
        Cell cellB = this.createCell(regionB);
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(regionA, 150L), cellA));
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(regionB, 200L), cellB));
        this.updatePushedSeqId(region, 99L);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(regionA, 150L), cellA));
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(regionB, 200L), cellB));
    }

    @Test
    public void testCanPushEqualsToBarrier() throws IOException, ReplicationException {
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)this.tableName).build();
        this.addStateAndBarrier(region, RegionState.State.OPEN, 10L, 100L);
        Cell cell = this.createCell(region);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 10L), cell));
        Assert.assertFalse((boolean)this.checker.canPush(this.createEntry(region, 100L), cell));
        this.updatePushedSeqId(region, 99L);
        Assert.assertTrue((boolean)this.checker.canPush(this.createEntry(region, 100L), cell));
    }

    static {
        WAL_FILE_NAME = "test.wal";
    }
}

