/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.TestHRegion;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestHRegionWithInMemoryFlush
extends TestHRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionWithInMemoryFlush.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionWithInMemoryFlush.class);

    @Override
    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        boolean[] inMemory = new boolean[families.length];
        for (int i = 0; i < inMemory.length; ++i) {
            inMemory[i] = true;
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        return TEST_UTIL.createLocalHRegionWithInMemoryFlags(tableName, startKey, stopKey, conf, isReadOnly, durability, wal, inMemory, families);
    }

    @Override
    int getTestCountForTestWritesWhileScanning() {
        return 10;
    }

    @Override
    int getNumQualifiersForTestWritesWhileScanning() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testFlushAndMemstoreSizeCounting() throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        this.region = this.initHRegion(this.tableName, this.method, CONF, (byte[][])new byte[][]{family});
        WALFactory wals = new WALFactory(CONF, this.method);
        int count = 0;
        try {
            for (byte[] row : HBaseTestingUtility.ROWS) {
                Put put = new Put(row);
                put.addColumn(family, family, row);
                this.region.put(put);
                if (count++ % 1000 != 0) continue;
                ((CompactingMemStore)this.region.getStore((byte[])family).memstore).flushInMemory();
            }
            this.region.flush(true);
            Assert.assertEquals((long)0L, (long)this.region.getMemStoreDataSize());
            Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)this.region.getMemStoreHeapSize());
            Assert.assertEquals((long)0L, (long)this.region.getMemStoreOffHeapSize());
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(this.region);
            this.region = null;
            wals.close();
        }
    }
}

