/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestResultScannerCursor;
import org.apache.hadoop.hbase.client.AbstractTestScanCursor;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncResultScannerCursor
extends AbstractTestResultScannerCursor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncResultScannerCursor.class);
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractTestScanCursor.setUpBeforeClass();
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    public static void tearDownAfterClass() throws Exception {
        if (CONN != null) {
            CONN.close();
        }
        AbstractTestScanCursor.tearDownAfterClass();
    }

    @Override
    protected ResultScanner getScanner(Scan scan) throws Exception {
        return CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool()).getScanner(scan);
    }
}

