/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.GCMultipleMergedRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMetaFixer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaFixer.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void deleteRegion(MasterServices services, RegionInfo ri) throws IOException {
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)ri);
        services.getAssignmentManager().getRegionStates().deleteRegion(ri);
    }

    private void testPlugsHolesWithReadReplicaInternal(TableName tn, int replicaCount) throws Exception {
        TEST_UTIL.createMultiRegionTable(tn, replicaCount, new byte[][]{HConstants.CATALOG_FAMILY});
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        int initialSize = services.getAssignmentManager().getRegionStates().getRegionStates().size();
        services.getCatalogJanitor().scan();
        CatalogJanitorReport report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        int originalCount = ris.size();
        for (int i = 0; i < replicaCount; ++i) {
            this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(3 * replicaCount + i));
            this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(i));
            this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(ris.size() - 1 - i));
        }
        Assert.assertEquals((long)(initialSize - 3 * replicaCount), (long)services.getAssignmentManager().getRegionStates().getRegionStates().size());
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertEquals((String)report.toString(), (long)3L, (long)report.getHoles().size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixHoles(report);
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((String)report.toString(), (boolean)report.isEmpty());
        Assert.assertEquals((long)initialSize, (long)services.getAssignmentManager().getRegionStates().getRegionStates().size());
        HBaseTestingUtility.await(50L, () -> TestMetaFixer.lambda$testPlugsHolesWithReadReplicaInternal$0((MasterServices)services));
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertEquals((long)originalCount, (long)ris.size());
    }

    @Test
    public void testPlugsHoles() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        this.testPlugsHolesWithReadReplicaInternal(tn, 1);
    }

    @Test
    public void testPlugsHolesWithReadReplica() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        this.testPlugsHolesWithReadReplicaInternal(tn, 3);
    }

    @Test
    public void testOneRegionTable() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        this.deleteRegion((MasterServices)services, (RegionInfo)ris.get(0));
        services.getCatalogJanitor().scan();
        CatalogJanitorReport report = services.getCatalogJanitor().getLastReport();
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((boolean)ris.isEmpty());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixHoles(report);
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertEquals((long)0L, (long)ris.size());
    }

    private static RegionInfo makeOverlap(MasterServices services, RegionInfo a, RegionInfo b) throws IOException {
        RegionInfo overlapRegion = RegionInfoBuilder.newBuilder((TableName)a.getTable()).setStartKey(a.getStartKey()).setEndKey(b.getEndKey()).build();
        MetaTableAccessor.putsToMetaTable((Connection)services.getConnection(), Collections.singletonList(MetaTableAccessor.makePutFromRegionInfo((RegionInfo)overlapRegion, (long)EnvironmentEdgeManager.currentTime())));
        long assign = services.getAssignmentManager().assign(overlapRegion);
        ProcedureTestingUtility.waitProcedures((ProcedureExecutor)services.getMasterProcedureExecutor(), (long[])new long[]{assign});
        return overlapRegion;
    }

    private void testOverlapCommon(TableName tn) throws Exception {
        Table t = TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY);
        TEST_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((ris.size() > 5 ? 1 : 0) != 0);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        CatalogJanitorReport report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(3));
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(2), (RegionInfo)ris.get(3));
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(2), (RegionInfo)ris.get(4));
    }

    @Test
    public void testOverlap() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        this.testOverlapCommon(tn);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        HbckChore hbckChore = services.getHbckChore();
        CatalogJanitor cj = services.getCatalogJanitor();
        cj.scan();
        CatalogJanitorReport report = cj.getLastReport();
        Assert.assertEquals((long)6L, (long)report.getOverlaps().size());
        Assert.assertEquals((long)1L, (long)MetaFixer.calculateMerges((int)10, (List)report.getOverlaps()).size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixOverlaps(report);
        HBaseTestingUtility.await(10L, () -> {
            try {
                if (cj.scan() > 0) {
                    Map mergedRegions = cj.getLastReport().mergedRegions;
                    for (Map.Entry e : mergedRegions.entrySet()) {
                        List parents = MetaTableAccessor.getMergeRegions((Cell[])((Result)e.getValue()).rawCells());
                        if (parents == null) continue;
                        ProcedureExecutor pe = services.getMasterProcedureExecutor();
                        pe.submitProcedure((Procedure)new GCMultipleMergedRegionsProcedure((MasterProcedureEnv)pe.getEnvironment(), (RegionInfo)e.getKey(), parents));
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HBaseTestingUtility.await(10L, () -> services.getMasterProcedureExecutor().getActiveProcIds().isEmpty());
        hbckChore.choreForTesting();
        HbckReport hbckReport = hbckChore.getLastReport();
        Assert.assertNotNull((Object)hbckReport);
        Assert.assertEquals((long)0L, (long)hbckReport.getOrphanRegionsOnFS().size());
        cj.scan();
        CatalogJanitorReport postReport = cj.getLastReport();
        Assert.assertTrue((boolean)postReport.isEmpty());
    }

    @Test
    public void testMultipleTableOverlaps() throws Exception {
        TableName t1 = TableName.valueOf((String)"t1");
        TableName t2 = TableName.valueOf((String)"t2");
        TEST_UTIL.createMultiRegionTable(t1, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.createMultiRegionTable(t2, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.waitTableAvailable(t2);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        CatalogJanitorReport report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)t1);
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(2));
        ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)t2);
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(2));
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertEquals((String)"Region overlaps count does not match.", (long)4L, (long)report.getOverlaps().size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        List longs = fixer.fixOverlaps(report);
        long[] procIds = longs.stream().mapToLong(l -> l).toArray();
        ProcedureTestingUtility.waitProcedures((ProcedureExecutor)services.getMasterProcedureExecutor(), (long[])procIds);
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((String)"After fix there should not have been any overlaps.", (boolean)report.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverlapWithSmallMergeCount() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.testOverlapCommon(tn);
            HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
            CatalogJanitor cj = services.getCatalogJanitor();
            cj.scan();
            CatalogJanitorReport report = cj.getLastReport();
            Assert.assertEquals((long)6L, (long)report.getOverlaps().size());
            Assert.assertEquals((long)2L, (long)MetaFixer.calculateMerges((int)5, (List)report.getOverlaps()).size());
            TEST_UTIL.getHBaseCluster().getMaster().getConfiguration().setInt("hbase.master.metafixer.max.merge.count", 5);
            HashSet<String> overlapRegions = new HashSet<String>();
            for (Pair pair : report.getOverlaps()) {
                overlapRegions.add(((RegionInfo)pair.getFirst()).getRegionNameAsString());
                overlapRegions.add(((RegionInfo)pair.getSecond()).getRegionNameAsString());
            }
            MetaFixer fixer = new MetaFixer((MasterServices)services);
            fixer.fixOverlaps(report);
            AssignmentManager am = services.getAssignmentManager();
            HBaseTestingUtility.await(200L, () -> {
                try {
                    Pair pair;
                    cj.scan();
                    CatalogJanitorReport postReport = cj.getLastReport();
                    RegionStates regionStates = am.getRegionStates();
                    if (postReport.getOverlaps().size() == 1 && !overlapRegions.contains(((RegionInfo)(pair = (Pair)postReport.getOverlaps().get(0)).getFirst()).getRegionNameAsString()) && regionStates.getRegionState((RegionInfo)pair.getFirst()).isOpened() && !overlapRegions.contains(((RegionInfo)pair.getSecond()).getRegionNameAsString()) && regionStates.getRegionState((RegionInfo)pair.getSecond()).isOpened()) {
                        List firstParents = MetaTableAccessor.getMergeRegions((Connection)services.getConnection(), (RegionInfo)((RegionInfo)pair.getFirst()));
                        List secondParents = MetaTableAccessor.getMergeRegions((Connection)services.getConnection(), (RegionInfo)((RegionInfo)pair.getSecond()));
                        return !(firstParents != null && !firstParents.isEmpty() || secondParents != null && !secondParents.isEmpty());
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            report = cj.getLastReport();
            fixer.fixOverlaps(report);
            HBaseTestingUtility.await(20L, () -> {
                try {
                    return cj.scan() > 0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            cj.scan();
            CatalogJanitorReport postReport = cj.getLastReport();
            Assert.assertTrue((boolean)postReport.isEmpty());
        }
        finally {
            TEST_UTIL.getHBaseCluster().getMaster().getConfiguration().unset("hbase.master.metafixer.max.merge.count");
            TEST_UTIL.deleteTable(tn);
        }
    }

    @Test
    public void testMergeWithMergedChildRegion() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((ris.size() > 5 ? 1 : 0) != 0);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        CatalogJanitor cj = services.getCatalogJanitor();
        cj.scan();
        CatalogJanitorReport report = cj.getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        RegionInfo overlapRegion = TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(2));
        cj.scan();
        report = cj.getLastReport();
        Assert.assertEquals((long)2L, (long)report.getOverlaps().size());
        RegionInfo fakedParentRegion = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(overlapRegion.getStartKey()).build();
        Table meta = MetaTableAccessor.getMetaHTable((Connection)TEST_UTIL.getConnection());
        Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)overlapRegion, (long)Long.MAX_VALUE);
        String qualifier = String.format("merge%04d", 0);
        putOfMerged.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(putOfMerged.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(Bytes.toBytes((String)qualifier)).setTimestamp(putOfMerged.getTimestamp()).setType(Cell.Type.Put).setValue(RegionInfo.toByteArray((RegionInfo)fakedParentRegion)).build());
        meta.put(putOfMerged);
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixOverlaps(report);
        HBaseTestingUtility.await(200L, () -> services.getMasterProcedureExecutor().getActiveProcIds().isEmpty());
        cj.scan();
        report = cj.getLastReport();
        Assert.assertEquals((long)2L, (long)report.getOverlaps().size());
        fixer.fixOverlaps(report);
        HBaseTestingUtility.await(200L, () -> services.getMasterProcedureExecutor().getActiveProcIds().isEmpty());
        cj.scan();
        report = cj.getLastReport();
        Assert.assertEquals((long)0L, (long)report.getOverlaps().size());
    }

    @Test
    public void testOverlapWithMergeOfNonContiguous() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tn, HConstants.CATALOG_FAMILY);
        List ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)tn);
        Assert.assertTrue((ris.size() > 5 ? 1 : 0) != 0);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        services.getCatalogJanitor().scan();
        CatalogJanitorReport report = services.getCatalogJanitor().getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        TestMetaFixer.makeOverlap((MasterServices)services, (RegionInfo)ris.get(1), (RegionInfo)ris.get(5));
        RegionInfo deletedRegion = (RegionInfo)ris.get(3);
        long pid = services.getAssignmentManager().unassign(deletedRegion);
        while (!services.getMasterProcedureExecutor().isFinished(pid)) {
            Threads.sleep((long)100L);
        }
        GCRegionProcedure procedure = new GCRegionProcedure((MasterProcedureEnv)services.getMasterProcedureExecutor().getEnvironment(), (RegionInfo)ris.get(3));
        pid = services.getMasterProcedureExecutor().submitProcedure((Procedure)procedure);
        while (!services.getMasterProcedureExecutor().isFinished(pid)) {
            Threads.sleep((long)100L);
        }
        services.getCatalogJanitor().scan();
        report = services.getCatalogJanitor().getLastReport();
        Assert.assertEquals((long)1L, (long)MetaFixer.calculateMerges((int)10, (List)report.getOverlaps()).size());
        MetaFixer fixer = new MetaFixer((MasterServices)services);
        fixer.fixOverlaps(report);
        HBaseTestingUtility.await(10L, () -> TestMetaFixer.lambda$testOverlapWithMergeOfNonContiguous$8((MasterServices)services));
    }

    private static /* synthetic */ boolean lambda$testOverlapWithMergeOfNonContiguous$8(MasterServices services) {
        try {
            services.getCatalogJanitor().scan();
            CatalogJanitorReport postReport = services.getCatalogJanitor().getLastReport();
            return postReport.isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$testPlugsHolesWithReadReplicaInternal$0(MasterServices services) {
        return services.getMasterProcedureExecutor().getActiveProcIds().size() == 0;
    }
}

