/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestIncrementTimeRange {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIncrementTimeRange.class);
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
    private static final TableName TEST_TABLE = TableName.valueOf((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW_A = Bytes.toBytes((String)"aaa");
    private static final byte[] ROW_B = Bytes.toBytes((String)"bbb");
    private static final byte[] ROW_C = Bytes.toBytes((String)"ccc");
    private static final byte[] qualifierCol1 = Bytes.toBytes((String)"col1");
    private static final byte[] bytes1 = Bytes.toBytes((int)1);
    private static final byte[] bytes2 = Bytes.toBytes((int)2);
    private static final byte[] bytes3 = Bytes.toBytes((int)3);
    private Table hTableInterface;
    private Table table;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", MyObserver.class.getName());
        util.getConfiguration().setInt("hbase.procedure.remote.dispatcher.delay.msec", 0);
        util.startMiniCluster();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mee);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        this.table = util.createTable(TEST_TABLE, TEST_FAMILY);
        Put puta = new Put(ROW_A);
        puta.addColumn(TEST_FAMILY, qualifierCol1, bytes1);
        this.table.put(puta);
        Put putb = new Put(ROW_B);
        putb.addColumn(TEST_FAMILY, qualifierCol1, bytes2);
        this.table.put(putb);
        Put putc = new Put(ROW_C);
        putc.addColumn(TEST_FAMILY, qualifierCol1, bytes3);
        this.table.put(putc);
    }

    @After
    public void after() throws Exception {
        try {
            if (this.table != null) {
                this.table.close();
            }
        }
        finally {
            try {
                util.deleteTable(TEST_TABLE);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void testHTableInterfaceMethods() throws Exception {
        this.hTableInterface = util.getConnection().getTable(TEST_TABLE);
        this.checkHTableInterfaceMethods();
    }

    private void checkHTableInterfaceMethods() throws Exception {
        Object[] results3;
        long time = EnvironmentEdgeManager.currentTime();
        mee.setValue(time);
        this.hTableInterface.put(new Put(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, Bytes.toBytes((long)1L)));
        this.checkRowValue(ROW_A, Bytes.toBytes((long)1L));
        time = EnvironmentEdgeManager.currentTime();
        mee.setValue(time);
        TimeRange range10 = new TimeRange(1L, time + 10L);
        this.hTableInterface.increment(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 10L).setTimeRange(range10.getMin(), range10.getMax()));
        this.checkRowValue(ROW_A, Bytes.toBytes((long)11L));
        Assert.assertEquals((long)MyObserver.tr10.getMin(), (long)range10.getMin());
        Assert.assertEquals((long)MyObserver.tr10.getMax(), (long)range10.getMax());
        time = EnvironmentEdgeManager.currentTime();
        mee.setValue(time);
        TimeRange range2 = new TimeRange(1L, time + 20L);
        List<Row> actions = Arrays.asList(new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L).setTimeRange(range2.getMin(), range2.getMax()), new Increment(ROW_A).addColumn(TEST_FAMILY, qualifierCol1, 2L).setTimeRange(range2.getMin(), range2.getMax()));
        Object[] results1 = results3 = new Object[actions.size()];
        this.hTableInterface.batch(actions, results1);
        Assert.assertEquals((long)MyObserver.tr2.getMin(), (long)range2.getMin());
        Assert.assertEquals((long)MyObserver.tr2.getMax(), (long)range2.getMax());
        for (Object r2 : results1) {
            Assert.assertTrue((boolean)(r2 instanceof Result));
        }
        this.checkRowValue(ROW_A, Bytes.toBytes((long)15L));
        this.hTableInterface.close();
    }

    private void checkRowValue(byte[] row, byte[] expectedValue) throws IOException {
        Get get = new Get(row).addColumn(TEST_FAMILY, qualifierCol1);
        Result result = this.hTableInterface.get(get);
        byte[] actualValue = result.getValue(TEST_FAMILY, qualifierCol1);
        Assert.assertArrayEquals((byte[])expectedValue, (byte[])actualValue);
    }

    public static class MyObserver
    extends SimpleRegionObserver {
        static TimeRange tr10 = null;
        static TimeRange tr2 = null;

        @Override
        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            NavigableMap map = increment.getFamilyCellMap();
            for (Map.Entry entry : map.entrySet()) {
                for (Cell cell : (List)entry.getValue()) {
                    long incr = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
                    if (incr == 10L) {
                        tr10 = increment.getTimeRange();
                        continue;
                    }
                    if (incr != 2L || increment.getTimeRange().isAllTime()) continue;
                    tr2 = increment.getTimeRange();
                }
            }
            return super.preIncrement(e, increment);
        }
    }
}

