/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.FastPathRpcHandler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FastPathBalancedQueueRpcExecutor
extends BalancedQueueRpcExecutor {
    private final Deque<FastPathRpcHandler> fastPathHandlerStack = new ConcurrentLinkedDeque<FastPathRpcHandler>();

    public FastPathBalancedQueueRpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, maxQueueLength, priority, conf, abortable);
    }

    public FastPathBalancedQueueRpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, callQueueType, maxQueueLength, priority, conf, abortable);
    }

    @Override
    protected RpcHandler getHandler(String name, double handlerFailureThreshhold, int handlerCount, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, AtomicInteger failedHandlerCount, Abortable abortable) {
        return new FastPathRpcHandler(name, handlerFailureThreshhold, handlerCount, q, activeHandlerCount, failedHandlerCount, abortable, this.fastPathHandlerStack);
    }

    @Override
    public boolean dispatch(CallRunner callTask) {
        if (this.currentQueueLimit == 0) {
            return false;
        }
        FastPathRpcHandler handler = this.popReadyHandler();
        return handler != null ? handler.loadCallRunner(callTask) : super.dispatch(callTask);
    }

    private FastPathRpcHandler popReadyHandler() {
        return this.fastPathHandlerStack.poll();
    }
}

