package org.apache.hadoop.hbase.generated.master;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskGroup;

public final class startupProgress_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


  private static String printLatestJournals(MonitoredTask task, int count) {
    List<MonitoredTask.StatusJournalEntry> journal = task.getStatusJournal();
    if (journal == null) {
      return "";
    }
    int journalSize = journal.size();
    StringBuilder sb = new StringBuilder();
    int skips = journalSize - count;
    if (skips > 0) {
      sb.append("Current journal size is ").append(journalSize).append(", ");
      sb.append("skip the previous ones and show the latest ").append(count).append(" journals...");
      sb.append(" </br>");
    }
    Iterator<MonitoredTask.StatusJournalEntry> iter = journal.iterator();
    MonitoredTask.StatusJournalEntry previousEntry = null;
    int i = 0;
    while (iter.hasNext()) {
      MonitoredTask.StatusJournalEntry entry = iter.next();
      if (i >= skips) {
        sb.append(entry);
        if (previousEntry != null) {
          long delta = entry.getTimeStamp() - previousEntry.getTimeStamp();
          if (delta != 0) {
            sb.append(" (+").append(delta).append(" ms)");
          }
        }
        sb.append(" </br>");
        previousEntry = entry;
      }
      i++;
    }
    return sb.toString();
  }

  private static String getStartupStatusString(TaskGroup startupTaskGroup) {
      MonitoredTask.State currentState = startupTaskGroup.getState();
      if (currentState.equals(MonitoredTask.State.COMPLETE)) {
        return "Master initialized";
      } else if (currentState.equals(MonitoredTask.State.RUNNING) |
        currentState.equals(MonitoredTask.State.WAITING)) {
        return "Master initialize in progress";
      } else {
        return currentState.toString();
      }
   }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n\n\n\n\n");

  final HMaster master = (HMaster) getServletContext().getAttribute(HMaster.MASTER);

      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "header.jsp" + "?" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode("pageTitle", request.getCharacterEncoding())+ "=" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode((java.lang.String) org.apache.jasper.runtime.PageContextImpl.evaluateExpression("${pageTitle}", java.lang.String.class, (PageContext)_jspx_page_context, null), request.getCharacterEncoding()), out, false);
      out.write("\n\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Startup Progress (\n      ");
 TaskGroup startupTaskGroup = master.getStartupProgress();
         if(startupTaskGroup != null){ 
      out.write("\n         ");
      out.print( getStartupStatusString(startupTaskGroup) );
      out.write("\n         ");
 } else { 
      out.write("\n         ");
      out.print( "");
      out.write("\n         ");
 } 
      out.write("\n      )</h1>\n    </div>\n  </div>\n\n  <table class=\"table table-striped\">\n    <tr>\n      <th>Task</th>\n      <th>Current State</th>\n      <th>Start Time</th>\n      <th>Last status Time</th>\n      <th>Elapsed Time(ms)</th>\n      <th>Journals</th>\n\n    </tr>\n    ");

    if(startupTaskGroup != null){
       for (MonitoredTask task : startupTaskGroup.getTasks()) { 
      out.write("\n    <tr>\n      <td>");
      out.print( task.getDescription() );
      out.write("</td>\n      <td>");
      out.print( task.getState().name() );
      out.write("</td>\n      <td>");
      out.print( new Date(task.getStartTime()) );
      out.write("</td>\n      <td>");
      out.print( new Date(task.getStatusTime()) );
      out.write("</td>\n      <td>");
      out.print( task.getStatusTime() - task.getStartTime() );
      out.write("</td>\n      <td>");
      out.print( printLatestJournals(task, 30) );
      out.write("</td>\n    </tr>\n    ");
 }
    } 
      out.write("\n\n  </table>\n\n</div>\n");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "footer.jsp", out, false);
      out.write('\n');
      out.write('\n');
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
