/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableLocateRegionForDeletedTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableLocateRegionForDeletedTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection ASYNC_CONN;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        Assert.assertFalse((boolean)ASYNC_CONN.isClosed());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)ASYNC_CONN, (boolean)true);
        Assert.assertTrue((boolean)ASYNC_CONN.isClosed());
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, InterruptedException {
        int i;
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            for (i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, VALUE));
            }
        }
        TEST_UTIL.getAdmin().split(TABLE_NAME, Bytes.toBytes((int)50));
        TEST_UTIL.waitFor(60000L, () -> TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).size() == 2);
        table = TEST_UTIL.getConnection().getTable(TABLE_NAME);
        var2_2 = null;
        try {
            for (i = 0; i < 100; ++i) {
                Assert.assertFalse((boolean)table.get(new Get(Bytes.toBytes((int)i))).isEmpty());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var2_2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        AsyncTableRegionLocator locator = ASYNC_CONN.getRegionLocator(TABLE_NAME);
        locator.getRegionLocation(Bytes.toBytes((int)0)).join();
        locator.getRegionLocation(Bytes.toBytes((int)99)).join();
        TEST_UTIL.getAdmin().disableTable(TABLE_NAME);
        TEST_UTIL.getAdmin().deleteTable(TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        Assert.assertFalse((boolean)((Boolean)ASYNC_CONN.getTable(TABLE_NAME).exists(new Get(Bytes.toBytes((int)99))).join()));
    }
}

