/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestShutdownBackupMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShutdownBackupMaster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static volatile CountDownLatch ARRIVE;
    private static volatile CountDownLatch CONTINUE;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", MockHMaster.class, HMaster.class);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(2).numDataNodes(2).build();
        UTIL.startMiniCluster(option);
        UTIL.waitUntilAllSystemRegionsAssigned();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testShutdownWhileBecomingActive() throws InterruptedException {
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HMaster activeMaster = null;
        HMaster backupMaster = null;
        for (JVMClusterUtil.MasterThread t2 : cluster.getMasterThreads()) {
            if (t2.getMaster().isActiveMaster()) {
                activeMaster = t2.getMaster();
                continue;
            }
            backupMaster = t2.getMaster();
        }
        Assert.assertNotNull(activeMaster);
        Assert.assertNotNull(backupMaster);
        ARRIVE = new CountDownLatch(1);
        CONTINUE = new CountDownLatch(1);
        activeMaster.abort("Aborting active master for test");
        ARRIVE.await();
        cluster.getRegionServerThreads().stream().map(t -> t.getRegionServer()).forEachOrdered(rs -> rs.abort("Aborting RS for test"));
        CONTINUE.countDown();
    }

    public static final class MockHMaster
    extends HMaster {
        public MockHMaster(Configuration conf) throws IOException {
            super(conf);
        }

        protected void initClusterSchemaService() throws IOException, InterruptedException {
            if (ARRIVE != null) {
                ARRIVE.countDown();
                CONTINUE.await();
            }
            super.initClusterSchemaService();
        }
    }
}

