/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.region.MasterRegionFlusherAndCompactor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionFlush {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionFlush.class);
    private Configuration conf;
    private HRegion region;
    private MasterRegionFlusherAndCompactor flusher;
    private AtomicInteger flushCalled;
    private AtomicLong memstoreHeapSize;
    private AtomicLong memstoreOffHeapSize;

    @Before
    public void setUp() throws IOException {
        this.conf = HBaseConfiguration.create();
        this.region = (HRegion)Mockito.mock(HRegion.class);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getStorefilesCount()).thenReturn((Object)1);
        Mockito.when((Object)this.region.getStores()).thenReturn(Collections.singletonList(store));
        Mockito.when((Object)this.region.getRegionInfo()).thenReturn((Object)RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"hbase:local")).build());
        this.flushCalled = new AtomicInteger(0);
        this.memstoreHeapSize = new AtomicLong(0L);
        this.memstoreOffHeapSize = new AtomicLong(0L);
        Mockito.when((Object)this.region.getMemStoreHeapSize()).thenAnswer(invocation -> this.memstoreHeapSize.get());
        Mockito.when((Object)this.region.getMemStoreOffHeapSize()).thenAnswer(invocation -> this.memstoreOffHeapSize.get());
        Mockito.when((Object)this.region.flush(ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> {
            Assert.assertTrue((boolean)((Boolean)invocation.getArgument(0)));
            this.memstoreHeapSize.set(0L);
            this.memstoreOffHeapSize.set(0L);
            this.flushCalled.incrementAndGet();
            return null;
        });
    }

    @After
    public void tearDown() {
        if (this.flusher != null) {
            this.flusher.close();
            this.flusher = null;
        }
    }

    private void initFlusher(long flushSize, long flushPerChanges, long flushIntervalMs) {
        this.flusher = new MasterRegionFlusherAndCompactor(this.conf, new Abortable(){

            public boolean isAborted() {
                return false;
            }

            public void abort(String why, Throwable e) {
            }
        }, this.region, flushSize, flushPerChanges, flushIntervalMs, 4, new Path("/tmp"), "");
    }

    @Test
    public void testTriggerFlushBySize() throws IOException, InterruptedException {
        this.initFlusher(0x100000L, 1000000L, TimeUnit.MINUTES.toMillis(15L));
        this.memstoreHeapSize.set(1024000L);
        this.flusher.onUpdate();
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)this.flushCalled.get());
        this.memstoreOffHeapSize.set(1024000L);
        this.flusher.onUpdate();
        Waiter.waitFor((Configuration)this.conf, (long)2000L, () -> this.flushCalled.get() == 1);
    }

    private void assertTriggerFlushByChanges(int changes) throws InterruptedException {
        int currentFlushCalled = this.flushCalled.get();
        for (int i = 0; i < changes; ++i) {
            this.flusher.onUpdate();
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)currentFlushCalled, (long)this.flushCalled.get());
        this.flusher.onUpdate();
        Waiter.waitFor((Configuration)this.conf, (long)5000L, () -> this.flushCalled.get() == currentFlushCalled + 1);
    }

    @Test
    public void testTriggerFlushByChanges() throws InterruptedException {
        this.initFlusher(0x8000000L, 10L, TimeUnit.MINUTES.toMillis(15L));
        this.assertTriggerFlushByChanges(10);
        this.assertTriggerFlushByChanges(10);
    }

    @Test
    public void testPeriodicalFlush() throws InterruptedException {
        this.initFlusher(0x8000000L, 1000000L, TimeUnit.SECONDS.toMillis(1L));
        Assert.assertEquals((long)0L, (long)this.flushCalled.get());
        Thread.sleep(1500L);
        Assert.assertEquals((long)1L, (long)this.flushCalled.get());
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)this.flushCalled.get());
    }
}

