/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas.policies;

import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestBulkLoadCheckingViolationPolicyEnforcement {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBulkLoadCheckingViolationPolicyEnforcement.class);
    FileSystem fs;
    RegionServerServices rss;
    TableName tableName;
    SpaceViolationPolicyEnforcement policy;

    @Before
    public void setup() {
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        this.tableName = TableName.valueOf((String)"foo");
        this.policy = new DefaultViolationPolicyEnforcement();
    }

    @Test
    public void testFilesUnderLimit() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        long length = 102400L;
        for (int i = 0; i < 5; ++i) {
            String path = "/" + i;
            FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)this.fs.getFileStatus(new Path(path))).thenReturn((Object)status);
            Mockito.when((Object)status.getLen()).thenReturn((Object)102400L);
            Mockito.when((Object)status.isFile()).thenReturn((Object)true);
            paths.add(path);
            statuses.add(status);
        }
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 0L, 614400L);
        this.policy.initialize(this.rss, this.tableName, snapshot);
        this.policy.computeBulkLoadSize(this.fs, paths);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFileIsNotAFile() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        String path = "/1";
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)this.fs.getFileStatus(new Path(path))).thenReturn((Object)status);
        Mockito.when((Object)status.getLen()).thenReturn((Object)1000L);
        Mockito.when((Object)status.isFile()).thenReturn((Object)false);
        paths.add(path);
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 0L, Long.MAX_VALUE);
        this.policy.initialize(this.rss, this.tableName, snapshot);
        this.policy.computeBulkLoadSize(this.fs, paths);
    }

    @Test(expected=SpaceLimitingException.class)
    public void testOneFileInBatchOverLimit() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        long length = 1024000L;
        for (int i = 0; i < 5; ++i) {
            String path = "/" + i;
            FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)this.fs.getFileStatus(new Path(path))).thenReturn((Object)status);
            Mockito.when((Object)status.getLen()).thenReturn((Object)1024000L);
            Mockito.when((Object)status.isFile()).thenReturn((Object)true);
            paths.add(path);
            statuses.add(status);
        }
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 0L, 1024L);
        this.policy.initialize(this.rss, this.tableName, snapshot);
        this.policy.computeBulkLoadSize(this.fs, paths);
    }

    @Test(expected=SpaceLimitingException.class)
    public void testSumOfFilesOverLimit() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        long length = 1024L;
        for (int i = 0; i < 5; ++i) {
            String path = "/" + i;
            FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)this.fs.getFileStatus(new Path(path))).thenReturn((Object)status);
            Mockito.when((Object)status.getLen()).thenReturn((Object)1024L);
            Mockito.when((Object)status.isFile()).thenReturn((Object)true);
            paths.add(path);
            statuses.add(status);
        }
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 0L, 5000L);
        this.policy.initialize(this.rss, this.tableName, snapshot);
        this.policy.computeBulkLoadSize(this.fs, paths);
    }
}

