/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.SegmentScanner;
import org.apache.hadoop.hbase.regionserver.ThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public abstract class Segment
implements MemStoreSizing {
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 6 * ClassSize.REFERENCE + 8 + 1));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.ATOMIC_REFERENCE + (long)ClassSize.CELL_SET + (long)(2 * ClassSize.ATOMIC_LONG) + (long)ClassSize.REENTRANT_LOCK;
    private AtomicReference<CellSet> cellSet = new AtomicReference();
    private final CellComparator comparator;
    private ReentrantReadWriteLock updatesLock;
    protected long minSequenceId;
    private MemStoreLAB memStoreLAB;
    protected final MemStoreSizing memStoreSizing;
    protected final TimeRangeTracker timeRangeTracker;
    protected volatile boolean tagsPresent;

    protected Segment(CellComparator comparator, TimeRangeTracker trt) {
        this.comparator = comparator;
        this.memStoreSizing = new ThreadSafeMemStoreSizing();
        this.timeRangeTracker = trt;
    }

    protected Segment(CellComparator comparator, List<ImmutableSegment> segments, TimeRangeTracker trt) {
        long dataSize = 0L;
        long heapSize = 0L;
        long OffHeapSize = 0L;
        int cellsCount = 0;
        for (Segment segment : segments) {
            MemStoreSize memStoreSize = segment.getMemStoreSize();
            dataSize += memStoreSize.getDataSize();
            heapSize += memStoreSize.getHeapSize();
            OffHeapSize += memStoreSize.getOffHeapSize();
            cellsCount += memStoreSize.getCellsCount();
        }
        this.comparator = comparator;
        this.updatesLock = new ReentrantReadWriteLock();
        this.memStoreSizing = new ThreadSafeMemStoreSizing(dataSize, heapSize, OffHeapSize, cellsCount);
        this.timeRangeTracker = trt;
    }

    protected Segment(CellSet cellSet, CellComparator comparator, MemStoreLAB memStoreLAB, TimeRangeTracker trt) {
        this.cellSet.set(cellSet);
        this.comparator = comparator;
        this.updatesLock = new ReentrantReadWriteLock();
        this.minSequenceId = Long.MAX_VALUE;
        this.memStoreLAB = memStoreLAB;
        this.memStoreSizing = new ThreadSafeMemStoreSizing();
        this.tagsPresent = false;
        this.timeRangeTracker = trt;
    }

    protected Segment(Segment segment) {
        this.cellSet.set(segment.getCellSet());
        this.comparator = segment.getComparator();
        this.updatesLock = segment.getUpdatesLock();
        this.minSequenceId = segment.getMinSequenceId();
        this.memStoreLAB = segment.getMemStoreLAB();
        this.memStoreSizing = segment.memStoreSizing;
        this.tagsPresent = segment.isTagsPresent();
        this.timeRangeTracker = segment.getTimeRangeTracker();
    }

    protected KeyValueScanner getScanner(long readPoint) {
        return new SegmentScanner(this, readPoint);
    }

    public List<KeyValueScanner> getScanners(long readPoint) {
        return Collections.singletonList(new SegmentScanner(this, readPoint));
    }

    public boolean isEmpty() {
        return this.getCellSet().isEmpty();
    }

    public void close() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.close();
        }
    }

    public Cell maybeCloneWithAllocator(Cell cell, boolean forceCloneOfBigCell) {
        if (this.memStoreLAB == null) {
            return cell;
        }
        Cell cellFromMslab = forceCloneOfBigCell ? this.memStoreLAB.forceCopyOfBigCellInto(cell) : this.memStoreLAB.copyCellInto(cell);
        return cellFromMslab != null ? cellFromMslab : cell;
    }

    static int getCellLength(Cell cell) {
        return cell.getSerializedSize();
    }

    public boolean shouldSeek(TimeRange tr, long oldestUnexpiredTS) {
        return !this.isEmpty() && (tr.isAllTime() || this.timeRangeTracker.includesTimeRange(tr)) && this.timeRangeTracker.getMax() >= oldestUnexpiredTS;
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }

    public void incScannerCount() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.incScannerCount();
        }
    }

    public void decScannerCount() {
        if (this.memStoreLAB != null) {
            this.memStoreLAB.decScannerCount();
        }
    }

    protected Segment setCellSet(CellSet cellSetOld, CellSet cellSetNew) {
        this.cellSet.compareAndSet(cellSetOld, cellSetNew);
        return this;
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return this.memStoreSizing.getMemStoreSize();
    }

    @Override
    public long getDataSize() {
        return this.memStoreSizing.getDataSize();
    }

    @Override
    public long getHeapSize() {
        return this.memStoreSizing.getHeapSize();
    }

    @Override
    public long getOffHeapSize() {
        return this.memStoreSizing.getOffHeapSize();
    }

    @Override
    public int getCellsCount() {
        return this.memStoreSizing.getCellsCount();
    }

    @Override
    public long incMemStoreSize(long delta, long heapOverhead, long offHeapOverhead, int cellsCount) {
        return this.memStoreSizing.incMemStoreSize(delta, heapOverhead, offHeapOverhead, cellsCount);
    }

    public boolean sharedLock() {
        return this.updatesLock.readLock().tryLock();
    }

    public void sharedUnlock() {
        this.updatesLock.readLock().unlock();
    }

    public void waitForUpdates() {
        if (!this.updatesLock.isWriteLocked()) {
            this.updatesLock.writeLock().lock();
        }
    }

    @Override
    public boolean compareAndSetDataSize(long expected, long updated) {
        return this.memStoreSizing.compareAndSetDataSize(expected, updated);
    }

    public long getMinSequenceId() {
        return this.minSequenceId;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public Cell last() {
        return this.getCellSet().last();
    }

    public Iterator<Cell> iterator() {
        return this.getCellSet().iterator();
    }

    public SortedSet<Cell> headSet(Cell firstKeyOnRow) {
        return this.getCellSet().headSet(firstKeyOnRow);
    }

    public int compare(Cell left, Cell right) {
        return this.getComparator().compare(left, right);
    }

    public int compareRows(Cell left, Cell right) {
        return this.getComparator().compareRows(left, right);
    }

    protected CellSet getCellSet() {
        return this.cellSet.get();
    }

    protected CellComparator getComparator() {
        return this.comparator;
    }

    protected void internalAdd(Cell cell, boolean mslabUsed, MemStoreSizing memstoreSizing, boolean sizeAddedPreOperation) {
        boolean succ = this.getCellSet().add(cell);
        this.updateMetaInfo(cell, succ, mslabUsed, memstoreSizing, sizeAddedPreOperation);
    }

    protected void updateMetaInfo(Cell cellToAdd, boolean succ, boolean mslabUsed, MemStoreSizing memstoreSizing, boolean sizeAddedPreOperation) {
        int cellsCount;
        long delta = 0L;
        long cellSize = Segment.getCellLength(cellToAdd);
        int n = cellsCount = succ ? 1 : 0;
        if (succ || mslabUsed) {
            delta = cellSize;
        }
        if (sizeAddedPreOperation) {
            delta -= cellSize;
        }
        long heapSize = this.heapSizeChange(cellToAdd, succ || mslabUsed);
        long offHeapSize = this.offHeapSizeChange(cellToAdd, succ || mslabUsed);
        this.incMemStoreSize(delta, heapSize, offHeapSize, cellsCount);
        if (memstoreSizing != null) {
            memstoreSizing.incMemStoreSize(delta, heapSize, offHeapSize, cellsCount);
        }
        this.getTimeRangeTracker().includeTimestamp(cellToAdd);
        this.minSequenceId = Math.min(this.minSequenceId, cellToAdd.getSequenceId());
        if (cellToAdd.getTagsLength() > 0) {
            this.tagsPresent = true;
        }
    }

    protected void updateMetaInfo(Cell cellToAdd, boolean succ, MemStoreSizing memstoreSizing) {
        this.updateMetaInfo(cellToAdd, succ, this.getMemStoreLAB() != null, memstoreSizing, false);
    }

    protected long heapSizeChange(Cell cell, boolean allocated) {
        long res = 0L;
        if (allocated) {
            boolean onHeap = true;
            MemStoreLAB memStoreLAB = this.getMemStoreLAB();
            if (memStoreLAB != null) {
                onHeap = memStoreLAB.isOnHeap();
            }
            res += this.indexEntryOnHeapSize(onHeap);
            if (onHeap) {
                res += cell.heapSize();
            }
            res = ClassSize.align((long)res);
        }
        return res;
    }

    protected long offHeapSizeChange(Cell cell, boolean allocated) {
        long res = 0L;
        if (allocated) {
            boolean offHeap = false;
            MemStoreLAB memStoreLAB = this.getMemStoreLAB();
            if (memStoreLAB != null) {
                offHeap = memStoreLAB.isOffHeap();
            }
            res += this.indexEntryOffHeapSize(offHeap);
            if (offHeap) {
                res += cell.heapSize();
            }
            res = ClassSize.align((long)res);
        }
        return res;
    }

    protected long indexEntryOnHeapSize(boolean onHeap) {
        return this.indexEntrySize();
    }

    protected long indexEntryOffHeapSize(boolean offHeap) {
        return 0L;
    }

    protected abstract long indexEntrySize();

    protected SortedSet<Cell> tailSet(Cell firstCell) {
        return this.getCellSet().tailSet(firstCell);
    }

    MemStoreLAB getMemStoreLAB() {
        return this.memStoreLAB;
    }

    void dump(Logger log) {
        for (Cell cell : this.getCellSet()) {
            log.debug(Objects.toString(cell));
        }
    }

    public String toString() {
        String res = "type=" + this.getClass().getSimpleName() + ", ";
        res = res + "empty=" + (this.isEmpty() ? "yes" : "no") + ", ";
        res = res + "cellCount=" + this.getCellsCount() + ", ";
        res = res + "cellSize=" + this.getDataSize() + ", ";
        res = res + "totalHeapSize=" + this.getHeapSize() + ", ";
        res = res + "min timestamp=" + this.timeRangeTracker.getMin() + ", ";
        res = res + "max timestamp=" + this.timeRangeTracker.getMax();
        return res;
    }

    private ReentrantReadWriteLock getUpdatesLock() {
        return this.updatesLock;
    }
}

