// Autogenerated Jamon implementation
// /home/apurtell/RM/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RSGroupListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 5
import java.util.Collections;
// 28, 5
import java.util.List;
// 29, 5
import java.util.Map;
// 30, 5
import java.util.Set;
// 31, 5
import java.util.stream.Collectors;
// 32, 5
import org.apache.hadoop.hbase.master.HMaster;
// 33, 5
import org.apache.hadoop.hbase.RegionMetrics;
// 34, 5
import org.apache.hadoop.hbase.ServerMetrics;
// 35, 5
import org.apache.hadoop.hbase.Size;
// 36, 5
import org.apache.hadoop.hbase.RSGroupTableAccessor;
// 37, 5
import org.apache.hadoop.hbase.master.ServerManager;
// 38, 5
import org.apache.hadoop.hbase.net.Address;
// 39, 5
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
// 40, 5
import org.apache.hadoop.util.StringUtils;
// 41, 5
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RSGroupListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.Intf

{
  private final HMaster master;
  private final ServerManager serverManager;
  protected static org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RSGroupListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    serverManager = p_implData.getServerManager();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 43, 1
    
List<RSGroupInfo> groups = RSGroupTableAccessor.getAllRSGroupInfo(master.getConnection());

    // 46, 1
    if ((groups != null && groups.size() > 0))
    {
      // 46, 45
      jamonWriter.write("\n\n");
      // 48, 1
      
RSGroupInfo [] rsGroupInfos = groups.toArray(new RSGroupInfo[groups.size()]);
Map<Address, ServerMetrics> collectServers = Collections.emptyMap();
if (master.getServerManager() != null) {
  collectServers =
      master.getServerManager().getOnlineServers().entrySet().stream()
          .collect(Collectors.toMap(p -> p.getKey().getAddress(), Map.Entry::getValue));
}

      // 58, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_rsgroup_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_rsgroup_baseStats\">\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__rsgroup_baseStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 68, 97
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_memoryStats\">\n            ");
      // 71, 13
      {
        // 71, 13
        __jamon_innerUnit__rsgroup_memoryStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 71, 99
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_requestStats\">\n            ");
      // 74, 13
      {
        // 74, 13
        __jamon_innerUnit__rsgroup_requestStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 74, 100
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_storeStats\">\n            ");
      // 77, 13
      {
        // 77, 13
        __jamon_innerUnit__rsgroup_storeStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 77, 98
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_compactStats\">\n            ");
      // 80, 13
      {
        // 80, 13
        __jamon_innerUnit__rsgroup_compactStats(jamonWriter, rsGroupInfos, collectServers );
      }
      // 80, 100
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 85, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 388, 1
  private void __jamon_innerUnit__rsGroupLink(final java.io.Writer jamonWriter, final String rsGroupName)
    throws java.io.IOException
  {
    // 392, 5
    jamonWriter.write("<a href=rsgroup.jsp?name=");
    // 392, 30
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
    // 392, 47
    jamonWriter.write(">");
    // 392, 48
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
    // 392, 65
    jamonWriter.write("</a>\n");
  }
  
  
  // 87, 1
  private void __jamon_innerUnit__rsgroup_baseStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 92, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Online Servers</th>\n    <th>Num. Dead Servers</th>\n    <th>Num. Tables</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n    <th>Average Load</th>\n</tr>\n");
    // 102, 1
    
    int totalOnlineServers = 0;
    int totalDeadServers = 0;
    int totalTables = 0;
    int totalRequests = 0;
    int totalRegions = 0;
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      int onlineServers = 0;
      int deadServers = 0;
      int tables = 0;
      long requestsPerSecond = 0;
      int numRegionsOnline = 0;
      Set<Address> servers = rsGroupInfo.getServers();
      for (Address server : servers) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          requestsPerSecond += sl.getRequestCountPerSecond();
          numRegionsOnline += sl.getRegionMetrics().size();
          //rsgroup total
          totalRegions += sl.getRegionMetrics().size();
          totalRequests += sl.getRequestCountPerSecond();
          totalOnlineServers++;
          onlineServers++;
        } else {
          totalDeadServers++;
          deadServers++;
        }
      }
      tables = rsGroupInfo.getTables().size();
      totalTables += tables;
      double avgLoad = onlineServers == 0 ? 0 :
            (double)numRegionsOnline / (double)onlineServers;

    // 136, 1
    jamonWriter.write("<tr>\n    <td>");
    // 137, 9
    {
      // 137, 9
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 137, 52
    jamonWriter.write("</td>\n    <td>");
    // 138, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(onlineServers), jamonWriter);
    // 138, 28
    jamonWriter.write("</td>\n    <td>");
    // 139, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(deadServers), jamonWriter);
    // 139, 26
    jamonWriter.write("</td>\n    <td>");
    // 140, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(tables), jamonWriter);
    // 140, 21
    jamonWriter.write("</td>\n    <td>");
    // 141, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(requestsPerSecond), jamonWriter);
    // 141, 32
    jamonWriter.write("</td>\n    <td>");
    // 142, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 142, 31
    jamonWriter.write("</td>\n    <td>");
    // 143, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.limitDecimalTo2(avgLoad)), jamonWriter);
    // 143, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 145, 1
    
}

    // 148, 1
    jamonWriter.write("<tr><td>Total:");
    // 148, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupInfos.length), jamonWriter);
    // 148, 40
    jamonWriter.write("</td>\n<td>");
    // 149, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalOnlineServers), jamonWriter);
    // 149, 29
    jamonWriter.write("</td>\n<td>");
    // 150, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalDeadServers), jamonWriter);
    // 150, 27
    jamonWriter.write("</td>\n<td>");
    // 151, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalTables), jamonWriter);
    // 151, 22
    jamonWriter.write("</td>\n<td>");
    // 152, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 152, 24
    jamonWriter.write("</td>\n<td>");
    // 153, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 153, 23
    jamonWriter.write("</td>\n<td>");
    // 154, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
    // 154, 82
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 337, 1
  private void __jamon_innerUnit__rsgroup_compactStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 342, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 350, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      int numStores = 0;
      long totalCompactingCells = 0;
      long totalCompactedCells = 0;
      long remainingCells = 0;
      long compactionProgress  = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rl : sl.getRegionMetrics().values()) {
            totalCompactingCells += rl.getCompactingCellCount();
            totalCompactedCells += rl.getCompactedCellCount();
          }
        }
      }
      remainingCells = totalCompactingCells - totalCompactedCells;
      String percentDone = "";
      if  (totalCompactingCells > 0) {
           percentDone = String.format("%.2f", 100 *
              ((float) totalCompactedCells / totalCompactingCells)) + "%";
      }

    // 374, 1
    jamonWriter.write("<tr>\n<td>");
    // 375, 5
    {
      // 375, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 375, 48
    jamonWriter.write("</td>\n<td>");
    // 376, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells), jamonWriter);
    // 376, 31
    jamonWriter.write("</td>\n<td>");
    // 377, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactedCells), jamonWriter);
    // 377, 30
    jamonWriter.write("</td>\n<td>");
    // 378, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(remainingCells), jamonWriter);
    // 378, 25
    jamonWriter.write("</td>\n<td>");
    // 379, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 379, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 381, 1
    
}

    // 384, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 159, 1
  private void __jamon_innerUnit__rsgroup_memoryStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 164, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 172, 1
    
    final String ZEROMB = "0 MB";
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String usedHeapStr = ZEROMB;
      String maxHeapStr = ZEROMB;
      String memstoreSizeStr = ZEROMB;
      String rsGroupName = rsGroupInfo.getName();
      long usedHeap = 0;
      long maxHeap = 0;
      long memstoreSize = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          usedHeap += (long) sl.getUsedHeapSize().get(Size.Unit.MEGABYTE);
          maxHeap += (long) sl.getMaxHeapSize().get(Size.Unit.MEGABYTE);
          memstoreSize += (long) sl.getRegionMetrics().values().stream().mapToDouble(
            rm -> rm.getMemStoreSize().get(Size.Unit.MEGABYTE)).sum();
        }
      }

      if (usedHeap > 0) {
        usedHeapStr = TraditionalBinaryPrefix.long2String(usedHeap
                                      * TraditionalBinaryPrefix.MEGA.value, "B", 1);
      }
      if (maxHeap > 0) {
        maxHeapStr = TraditionalBinaryPrefix.long2String(maxHeap
                                      * TraditionalBinaryPrefix.MEGA.value, "B", 1);
      }
      if (memstoreSize > 0) {
        memstoreSizeStr = TraditionalBinaryPrefix.long2String(memstoreSize
                                      * TraditionalBinaryPrefix.MEGA.value, "B", 1);
      }

    // 205, 1
    jamonWriter.write("<tr>\n    <td>");
    // 206, 9
    {
      // 206, 9
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 206, 52
    jamonWriter.write("</td>\n    <td>");
    // 207, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(usedHeapStr), jamonWriter);
    // 207, 26
    jamonWriter.write("</td>\n    <td>");
    // 208, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(maxHeapStr), jamonWriter);
    // 208, 25
    jamonWriter.write("</td>\n    <td>");
    // 209, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(memstoreSizeStr), jamonWriter);
    // 209, 30
    jamonWriter.write("</td>\n\n</tr>\n");
    // 212, 1
    
}

    // 215, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 218, 1
  private void __jamon_innerUnit__rsgroup_requestStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 223, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 230, 1
    
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String rsGroupName = rsGroupInfo.getName();
      long requestsPerSecond = 0;
      long readRequests = 0;
      long writeRequests = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rm : sl.getRegionMetrics().values()) {
            readRequests += rm.getReadRequestCount();
            writeRequests += rm.getWriteRequestCount();
          }
          requestsPerSecond += sl.getRequestCountPerSecond();
        }
      }

    // 247, 1
    jamonWriter.write("<tr>\n<td>");
    // 248, 5
    {
      // 248, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 248, 48
    jamonWriter.write("</td>\n<td>");
    // 249, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(requestsPerSecond), jamonWriter);
    // 249, 28
    jamonWriter.write("</td>\n<td>");
    // 250, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(readRequests), jamonWriter);
    // 250, 23
    jamonWriter.write("</td>\n<td>");
    // 251, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(writeRequests), jamonWriter);
    // 251, 24
    jamonWriter.write("</td>\n</tr>\n");
    // 253, 1
    
}

    // 256, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 260, 1
  private void __jamon_innerUnit__rsgroup_storeStats(final java.io.Writer jamonWriter, final RSGroupInfo[] rsGroupInfos, final Map<Address,ServerMetrics> collectServers)
    throws java.io.IOException
  {
    // 265, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 275, 1
    
    final String ZEROKB = "0 KB";
    final String ZEROMB = "0 MB";
    for (RSGroupInfo rsGroupInfo: rsGroupInfos) {
      String uncompressedStorefileSizeStr = ZEROMB;
      String storefileSizeStr = ZEROMB;
      String indexSizeStr = ZEROKB;
      String bloomSizeStr = ZEROKB;
      String rsGroupName = rsGroupInfo.getName();
      int numStores = 0;
      long numStorefiles = 0;
      long uncompressedStorefileSize  = 0;
      long storefileSize  = 0;
      long indexSize  = 0;
      long bloomSize  = 0;
      int count = 0;
      for (Address server : rsGroupInfo.getServers()) {
        ServerMetrics sl = collectServers.get(server);
        if (sl != null) {
          for (RegionMetrics rm : sl.getRegionMetrics().values()) {
            numStores += rm.getStoreCount();
            numStorefiles += rm.getStoreFileCount();
            uncompressedStorefileSize += rm.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
            storefileSize += rm.getStoreFileSize().get(Size.Unit.MEGABYTE);
            indexSize += rm.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
            bloomSize += rm.getBloomFilterSize().get(Size.Unit.KILOBYTE);
          }
          count++;
        }
      }
       if (uncompressedStorefileSize > 0) {
          uncompressedStorefileSizeStr = TraditionalBinaryPrefix.
          long2String(uncompressedStorefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1);
       }
       if (storefileSize > 0) {
           storefileSizeStr = TraditionalBinaryPrefix.
           long2String(storefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1);
       }
       if (indexSize > 0) {
          indexSizeStr = TraditionalBinaryPrefix.
          long2String(indexSize * TraditionalBinaryPrefix.KILO.value, "B", 1);
       }
       if (bloomSize > 0) {
           bloomSizeStr = TraditionalBinaryPrefix.
           long2String(bloomSize * TraditionalBinaryPrefix.KILO.value, "B", 1);
       }

    // 322, 1
    jamonWriter.write("<tr>\n<td>");
    // 323, 5
    {
      // 323, 5
      __jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
    }
    // 323, 48
    jamonWriter.write("</td>\n<td>");
    // 324, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numStores), jamonWriter);
    // 324, 20
    jamonWriter.write("</td>\n<td>");
    // 325, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numStorefiles), jamonWriter);
    // 325, 24
    jamonWriter.write("</td>\n<td>");
    // 326, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(uncompressedStorefileSizeStr), jamonWriter);
    // 326, 39
    jamonWriter.write("</td>\n<td>");
    // 327, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storefileSizeStr), jamonWriter);
    // 327, 27
    jamonWriter.write("</td>\n<td>");
    // 328, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(indexSizeStr), jamonWriter);
    // 328, 23
    jamonWriter.write("</td>\n<td>");
    // 329, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bloomSizeStr), jamonWriter);
    // 329, 23
    jamonWriter.write("</td>\n</tr>\n");
    // 331, 1
    
}

    // 334, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
