/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CachedEntryQueue {
    private static final Comparator<Map.Entry<BlockCacheKey, BucketEntry>> COMPARATOR = (a, b) -> BucketEntry.COMPARATOR.compare((BucketEntry)a.getValue(), (BucketEntry)b.getValue());
    private MinMaxPriorityQueue<Map.Entry<BlockCacheKey, BucketEntry>> queue;
    private long cacheSize;
    private long maxSize;

    public CachedEntryQueue(long maxSize, long blockSize) {
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"negative blockSize %s", (long)blockSize);
        Preconditions.checkArgument((maxSize > 0L ? 1 : 0) != 0, (String)"negative maxSize %s", (long)maxSize);
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.orderedBy(COMPARATOR).expectedSize(initialSize).create();
        this.cacheSize = 0L;
        this.maxSize = maxSize;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="head can not be null as cacheSize is greater than maxSize, which means we have something in the queue")
    public void add(Map.Entry<BlockCacheKey, BucketEntry> entry) {
        if (this.cacheSize < this.maxSize) {
            this.queue.add(entry);
            this.cacheSize += (long)entry.getValue().getLength();
        } else {
            BucketEntry head = (BucketEntry)((Map.Entry)this.queue.peek()).getValue();
            if (BucketEntry.COMPARATOR.compare(entry.getValue(), head) > 0) {
                this.cacheSize += (long)entry.getValue().getLength();
                this.cacheSize -= (long)head.getLength();
                if (this.cacheSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.cacheSize += (long)head.getLength();
                }
                this.queue.add(entry);
            }
        }
    }

    public Map.Entry<BlockCacheKey, BucketEntry> poll() {
        return (Map.Entry)this.queue.poll();
    }

    public Map.Entry<BlockCacheKey, BucketEntry> pollLast() {
        return (Map.Entry)this.queue.pollLast();
    }
}

