/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultOperationQuota
implements OperationQuota {
    private static final double MAX_SCAN_ESTIMATE_PROPORTIONAL_LIMIT_CONSUMPTION = 0.9;
    protected final List<QuotaLimiter> limiters;
    private final long writeCapacityUnit;
    private final long readCapacityUnit;
    protected long readAvailable = 0L;
    protected long writeConsumed = 0L;
    protected long readConsumed = 0L;
    protected long writeCapacityUnitConsumed = 0L;
    protected long readCapacityUnitConsumed = 0L;
    private final long[] operationSize;
    protected long writeDiff = 0L;
    protected long readDiff = 0L;
    protected long writeCapacityUnitDiff = 0L;
    protected long readCapacityUnitDiff = 0L;
    private boolean useResultSizeBytes;
    private long blockSizeBytes;
    private long maxScanEstimate;

    public DefaultOperationQuota(Configuration conf, int blockSizeBytes, QuotaLimiter ... limiters) {
        this(conf, Arrays.asList(limiters));
        this.useResultSizeBytes = conf.getBoolean("hbase.quota.use.result.size.bytes", false);
        this.blockSizeBytes = blockSizeBytes;
        long readSizeLimit = Arrays.stream(limiters).mapToLong(QuotaLimiter::getReadLimit).min().orElse(Long.MAX_VALUE);
        this.maxScanEstimate = Math.round(0.9 * (double)readSizeLimit);
    }

    public DefaultOperationQuota(Configuration conf, List<QuotaLimiter> limiters) {
        this.writeCapacityUnit = conf.getLong("hbase.quota.write.capacity.unit", 1024L);
        this.readCapacityUnit = conf.getLong("hbase.quota.read.capacity.unit", 1024L);
        this.limiters = limiters;
        int size = OperationQuota.OperationType.values().length;
        this.operationSize = new long[size];
        for (int i = 0; i < size; ++i) {
            this.operationSize[i] = 0L;
        }
    }

    @Override
    public void checkBatchQuota(int numWrites, int numReads) throws RpcThrottlingException {
        this.updateEstimateConsumeBatchQuota(numWrites, numReads);
        this.checkQuota(numWrites, numReads);
    }

    @Override
    public void checkScanQuota(ClientProtos.ScanRequest scanRequest, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) throws RpcThrottlingException {
        this.updateEstimateConsumeScanQuota(scanRequest, maxScannerResultSize, maxBlockBytesScanned, prevBlockBytesScannedDifference);
        this.checkQuota(0L, 1L);
    }

    private void checkQuota(long numWrites, long numReads) throws RpcThrottlingException {
        this.readAvailable = Long.MAX_VALUE;
        for (QuotaLimiter limiter : this.limiters) {
            if (limiter.isBypass()) continue;
            limiter.checkQuota(numWrites, this.writeConsumed, numReads, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed);
            this.readAvailable = Math.min(this.readAvailable, limiter.getReadAvailable());
        }
        for (QuotaLimiter limiter : this.limiters) {
            limiter.grabQuota(numWrites, this.writeConsumed, numReads, this.readConsumed, this.writeCapacityUnitConsumed, this.readCapacityUnitConsumed);
        }
    }

    @Override
    public void close() {
        this.writeDiff = this.operationSize[OperationQuota.OperationType.MUTATE.ordinal()] - this.writeConsumed;
        long resultSize = this.operationSize[OperationQuota.OperationType.GET.ordinal()] + this.operationSize[OperationQuota.OperationType.SCAN.ordinal()];
        if (this.useResultSizeBytes) {
            this.readDiff = resultSize - this.readConsumed;
        } else {
            long blockBytesScanned = RpcServer.getCurrentCall().map(RpcCallContext::getBlockBytesScanned).orElse(0L);
            this.readDiff = Math.max(blockBytesScanned, resultSize) - this.readConsumed;
        }
        this.writeCapacityUnitDiff = this.calculateWriteCapacityUnitDiff(this.operationSize[OperationQuota.OperationType.MUTATE.ordinal()], this.writeConsumed);
        this.readCapacityUnitDiff = this.calculateReadCapacityUnitDiff(this.operationSize[OperationQuota.OperationType.GET.ordinal()] + this.operationSize[OperationQuota.OperationType.SCAN.ordinal()], this.readConsumed);
        for (QuotaLimiter limiter : this.limiters) {
            if (this.writeDiff != 0L) {
                limiter.consumeWrite(this.writeDiff, this.writeCapacityUnitDiff);
            }
            if (this.readDiff == 0L) continue;
            limiter.consumeRead(this.readDiff, this.readCapacityUnitDiff);
        }
    }

    @Override
    public long getReadAvailable() {
        return this.readAvailable;
    }

    @Override
    public long getReadConsumed() {
        return this.readConsumed;
    }

    @Override
    public void addGetResult(Result result) {
        int n = OperationQuota.OperationType.GET.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(result);
    }

    @Override
    public void addScanResult(List<Result> results) {
        int n = OperationQuota.OperationType.SCAN.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateResultSize(results);
    }

    @Override
    public void addMutation(Mutation mutation) {
        int n = OperationQuota.OperationType.MUTATE.ordinal();
        this.operationSize[n] = this.operationSize[n] + QuotaUtil.calculateMutationSize(mutation);
    }

    protected void updateEstimateConsumeBatchQuota(int numWrites, int numReads) {
        this.writeConsumed = this.estimateConsume(OperationQuota.OperationType.MUTATE, numWrites, 100L);
        this.readConsumed = this.useResultSizeBytes ? this.estimateConsume(OperationQuota.OperationType.GET, numReads, 100L) : (numReads > 0 ? this.blockSizeBytes : 0L);
        this.writeCapacityUnitConsumed = this.calculateWriteCapacityUnit(this.writeConsumed);
        this.readCapacityUnitConsumed = this.calculateReadCapacityUnit(this.readConsumed);
    }

    protected void updateEstimateConsumeScanQuota(ClientProtos.ScanRequest scanRequest, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) {
        if (this.useResultSizeBytes) {
            this.readConsumed = this.estimateConsume(OperationQuota.OperationType.SCAN, 1, 1000L);
        } else {
            long estimate = DefaultOperationQuota.getScanReadConsumeEstimate(this.blockSizeBytes, scanRequest.getNextCallSeq(), maxScannerResultSize, maxBlockBytesScanned, prevBlockBytesScannedDifference);
            this.readConsumed = Math.min(this.maxScanEstimate, estimate);
        }
        this.readCapacityUnitConsumed = this.calculateReadCapacityUnit(this.readConsumed);
    }

    protected static long getScanReadConsumeEstimate(long blockSizeBytes, long nextCallSeq, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) {
        boolean isWorkloadGrowing;
        if (nextCallSeq == 0L) {
            return blockSizeBytes;
        }
        boolean bl = isWorkloadGrowing = prevBlockBytesScannedDifference > blockSizeBytes;
        if (isWorkloadGrowing) {
            return Math.min(maxScannerResultSize, nextCallSeq * maxBlockBytesScanned);
        }
        return maxBlockBytesScanned;
    }

    private long estimateConsume(OperationQuota.OperationType type, int numReqs, long avgSize) {
        if (numReqs > 0) {
            return avgSize * (long)numReqs;
        }
        return 0L;
    }

    private long calculateWriteCapacityUnit(long size) {
        return (long)Math.ceil((double)size * 1.0 / (double)this.writeCapacityUnit);
    }

    private long calculateReadCapacityUnit(long size) {
        return (long)Math.ceil((double)size * 1.0 / (double)this.readCapacityUnit);
    }

    private long calculateWriteCapacityUnitDiff(long actualSize, long estimateSize) {
        return this.calculateWriteCapacityUnit(actualSize) - this.calculateWriteCapacityUnit(estimateSize);
    }

    private long calculateReadCapacityUnitDiff(long actualSize, long estimateSize) {
        return this.calculateReadCapacityUnit(actualSize) - this.calculateReadCapacityUnit(estimateSize);
    }
}

