/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.quotas.AverageIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.FixedIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimeBasedLimiter
implements QuotaLimiter {
    private static final Configuration conf = HBaseConfiguration.create();
    private RateLimiter reqsLimiter = null;
    private RateLimiter reqSizeLimiter = null;
    private RateLimiter writeReqsLimiter = null;
    private RateLimiter writeSizeLimiter = null;
    private RateLimiter readReqsLimiter = null;
    private RateLimiter readSizeLimiter = null;
    private RateLimiter reqCapacityUnitLimiter = null;
    private RateLimiter writeCapacityUnitLimiter = null;
    private RateLimiter readCapacityUnitLimiter = null;

    private TimeBasedLimiter() {
        if (FixedIntervalRateLimiter.class.getName().equals(conf.getClass("hbase.quota.rate.limiter", AverageIntervalRateLimiter.class).getName())) {
            long refillInterval = conf.getLong("hbase.quota.rate.limiter.refill.interval.ms", 1000L);
            this.reqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.reqSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeReqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readReqsLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readSizeLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.reqCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.writeCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
            this.readCapacityUnitLimiter = new FixedIntervalRateLimiter(refillInterval);
        } else {
            this.reqsLimiter = new AverageIntervalRateLimiter();
            this.reqSizeLimiter = new AverageIntervalRateLimiter();
            this.writeReqsLimiter = new AverageIntervalRateLimiter();
            this.writeSizeLimiter = new AverageIntervalRateLimiter();
            this.readReqsLimiter = new AverageIntervalRateLimiter();
            this.readSizeLimiter = new AverageIntervalRateLimiter();
            this.reqCapacityUnitLimiter = new AverageIntervalRateLimiter();
            this.writeCapacityUnitLimiter = new AverageIntervalRateLimiter();
            this.readCapacityUnitLimiter = new AverageIntervalRateLimiter();
        }
    }

    static QuotaLimiter fromThrottle(QuotaProtos.Throttle throttle) {
        TimeBasedLimiter limiter = new TimeBasedLimiter();
        boolean isBypass = true;
        if (throttle.hasReqNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqsLimiter, throttle.getReqNum());
            isBypass = false;
        }
        if (throttle.hasReqSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqSizeLimiter, throttle.getReqSize());
            isBypass = false;
        }
        if (throttle.hasWriteNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeReqsLimiter, throttle.getWriteNum());
            isBypass = false;
        }
        if (throttle.hasWriteSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeSizeLimiter, throttle.getWriteSize());
            isBypass = false;
        }
        if (throttle.hasReadNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readReqsLimiter, throttle.getReadNum());
            isBypass = false;
        }
        if (throttle.hasReadSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readSizeLimiter, throttle.getReadSize());
            isBypass = false;
        }
        if (throttle.hasReqCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqCapacityUnitLimiter, throttle.getReqCapacityUnit());
            isBypass = false;
        }
        if (throttle.hasWriteCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeCapacityUnitLimiter, throttle.getWriteCapacityUnit());
            isBypass = false;
        }
        if (throttle.hasReadCapacityUnit()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readCapacityUnitLimiter, throttle.getReadCapacityUnit());
            isBypass = false;
        }
        return isBypass ? NoopQuotaLimiter.get() : limiter;
    }

    public void update(TimeBasedLimiter other) {
        this.reqsLimiter.update(other.reqsLimiter);
        this.reqSizeLimiter.update(other.reqSizeLimiter);
        this.writeReqsLimiter.update(other.writeReqsLimiter);
        this.writeSizeLimiter.update(other.writeSizeLimiter);
        this.readReqsLimiter.update(other.readReqsLimiter);
        this.readSizeLimiter.update(other.readSizeLimiter);
        this.reqCapacityUnitLimiter.update(other.reqCapacityUnitLimiter);
        this.writeCapacityUnitLimiter.update(other.writeCapacityUnitLimiter);
        this.readCapacityUnitLimiter.update(other.readCapacityUnitLimiter);
    }

    private static void setFromTimedQuota(RateLimiter limiter, QuotaProtos.TimedQuota timedQuota) {
        limiter.set(timedQuota.getSoftLimit(), ProtobufUtil.toTimeUnit((HBaseProtos.TimeUnit)timedQuota.getTimeUnit()));
    }

    @Override
    public void checkQuota(long writeReqs, long estimateWriteSize, long readReqs, long estimateReadSize, long estimateWriteCapacityUnit, long estimateReadCapacityUnit) throws RpcThrottlingException {
        long waitInterval = this.reqsLimiter.getWaitIntervalMs(writeReqs + readReqs);
        if (waitInterval > 0L) {
            RpcThrottlingException.throwNumRequestsExceeded((long)waitInterval);
        }
        if ((waitInterval = this.reqSizeLimiter.getWaitIntervalMs(estimateWriteSize + estimateReadSize)) > 0L) {
            RpcThrottlingException.throwRequestSizeExceeded((long)waitInterval);
        }
        if ((waitInterval = this.reqCapacityUnitLimiter.getWaitIntervalMs(estimateWriteCapacityUnit + estimateReadCapacityUnit)) > 0L) {
            RpcThrottlingException.throwRequestCapacityUnitExceeded((long)waitInterval);
        }
        if (estimateWriteSize > 0L) {
            waitInterval = this.writeReqsLimiter.getWaitIntervalMs(writeReqs);
            if (waitInterval > 0L) {
                RpcThrottlingException.throwNumWriteRequestsExceeded((long)waitInterval);
            }
            if ((waitInterval = this.writeSizeLimiter.getWaitIntervalMs(estimateWriteSize)) > 0L) {
                RpcThrottlingException.throwWriteSizeExceeded((long)waitInterval);
            }
            if ((waitInterval = this.writeCapacityUnitLimiter.getWaitIntervalMs(estimateWriteCapacityUnit)) > 0L) {
                RpcThrottlingException.throwWriteCapacityUnitExceeded((long)waitInterval);
            }
        }
        if (estimateReadSize > 0L) {
            waitInterval = this.readReqsLimiter.getWaitIntervalMs(readReqs);
            if (waitInterval > 0L) {
                RpcThrottlingException.throwNumReadRequestsExceeded((long)waitInterval);
            }
            if ((waitInterval = this.readSizeLimiter.getWaitIntervalMs(estimateReadSize)) > 0L) {
                RpcThrottlingException.throwReadSizeExceeded((long)waitInterval);
            }
            if ((waitInterval = this.readCapacityUnitLimiter.getWaitIntervalMs(estimateReadCapacityUnit)) > 0L) {
                RpcThrottlingException.throwReadCapacityUnitExceeded((long)waitInterval);
            }
        }
    }

    @Override
    public void grabQuota(long writeReqs, long writeSize, long readReqs, long readSize, long writeCapacityUnit, long readCapacityUnit) {
        assert (writeSize != 0L || readSize != 0L);
        this.reqsLimiter.consume(writeReqs + readReqs);
        this.reqSizeLimiter.consume(writeSize + readSize);
        if (writeSize > 0L) {
            this.writeReqsLimiter.consume(writeReqs);
            this.writeSizeLimiter.consume(writeSize);
        }
        if (readSize > 0L) {
            this.readReqsLimiter.consume(readReqs);
            this.readSizeLimiter.consume(readSize);
        }
        if (writeCapacityUnit > 0L) {
            this.reqCapacityUnitLimiter.consume(writeCapacityUnit);
            this.writeCapacityUnitLimiter.consume(writeCapacityUnit);
        }
        if (readCapacityUnit > 0L) {
            this.reqCapacityUnitLimiter.consume(readCapacityUnit);
            this.readCapacityUnitLimiter.consume(readCapacityUnit);
        }
    }

    @Override
    public void consumeWrite(long size, long capacityUnit) {
        this.reqSizeLimiter.consume(size);
        this.writeSizeLimiter.consume(size);
        this.reqCapacityUnitLimiter.consume(capacityUnit);
        this.writeCapacityUnitLimiter.consume(capacityUnit);
    }

    @Override
    public void consumeRead(long size, long capacityUnit) {
        this.reqSizeLimiter.consume(size);
        this.readSizeLimiter.consume(size);
        this.reqCapacityUnitLimiter.consume(capacityUnit);
        this.readCapacityUnitLimiter.consume(capacityUnit);
    }

    @Override
    public boolean isBypass() {
        return false;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeSizeLimiter.getAvailable();
    }

    @Override
    public long getReadAvailable() {
        return this.readSizeLimiter.getAvailable();
    }

    @Override
    public long getReadLimit() {
        return Math.min(this.readSizeLimiter.getLimit(), this.reqSizeLimiter.getLimit());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeBasedLimiter(");
        if (!this.reqsLimiter.isBypass()) {
            builder.append("reqs=" + this.reqsLimiter);
        }
        if (!this.reqSizeLimiter.isBypass()) {
            builder.append(" resSize=" + this.reqSizeLimiter);
        }
        if (!this.writeReqsLimiter.isBypass()) {
            builder.append(" writeReqs=" + this.writeReqsLimiter);
        }
        if (!this.writeSizeLimiter.isBypass()) {
            builder.append(" writeSize=" + this.writeSizeLimiter);
        }
        if (!this.readReqsLimiter.isBypass()) {
            builder.append(" readReqs=" + this.readReqsLimiter);
        }
        if (!this.readSizeLimiter.isBypass()) {
            builder.append(" readSize=" + this.readSizeLimiter);
        }
        if (!this.reqCapacityUnitLimiter.isBypass()) {
            builder.append(" reqCapacityUnit=" + this.reqCapacityUnitLimiter);
        }
        if (!this.writeCapacityUnitLimiter.isBypass()) {
            builder.append(" writeCapacityUnit=" + this.writeCapacityUnitLimiter);
        }
        if (!this.readCapacityUnitLimiter.isBypass()) {
            builder.append(" readCapacityUnit=" + this.readCapacityUnitLimiter);
        }
        builder.append(')');
        return builder.toString();
    }
}

