/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAtomicReadQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAtomicReadQuota.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAtomicReadQuota.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)UUID.randomUUID().toString());
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");

    @AfterClass
    public static void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
        EnvironmentEdgeManager.reset();
        TEST_UTIL.deleteTable(TABLE_NAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 1);
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1000);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        QuotaCache.TEST_FORCE_REFRESH = true;
    }

    @Test
    public void testIncrementCountedAgainstReadCapacity() throws Exception {
        this.setupQuota();
        Increment inc = new Increment(Bytes.toBytes((String)UUID.randomUUID().toString()));
        inc.addColumn(FAMILY, QUALIFIER, 1L);
        this.testThrottle(table -> table.increment(inc));
    }

    @Test
    public void testConditionalRowMutationsCountedAgainstReadCapacity() throws Exception {
        this.setupQuota();
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        Increment inc = new Increment(row);
        inc.addColumn(FAMILY, Bytes.toBytes((String)"doot"), 1L);
        Put put = new Put(row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"doot"), Bytes.toBytes((String)"v"));
        RowMutations rowMutations = new RowMutations(row);
        rowMutations.add((Mutation)inc);
        rowMutations.add(put);
        this.testThrottle(table -> table.mutateRow(rowMutations));
    }

    @Test
    public void testNonConditionalRowMutationsOmittedFromReadCapacity() throws Exception {
        this.setupQuota();
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        Put put = new Put(row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"doot"), Bytes.toBytes((String)"v"));
        RowMutations rowMutations = new RowMutations(row);
        rowMutations.add(put);
        try (Table table = this.getTable();){
            for (int i = 0; i < 100; ++i) {
                table.mutateRow(rowMutations);
            }
        }
    }

    @Test
    public void testNonAtomicPutOmittedFromReadCapacity() throws Exception {
        this.setupQuota();
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        Put put = new Put(row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"doot"), Bytes.toBytes((String)"v"));
        try (Table table = this.getTable();){
            for (int i = 0; i < 100; ++i) {
                table.put(put);
            }
        }
    }

    @Test
    public void testNonAtomicMultiPutOmittedFromReadCapacity() throws Exception {
        this.setupQuota();
        Put put1 = new Put(Bytes.toBytes((String)UUID.randomUUID().toString()));
        put1.addColumn(FAMILY, Bytes.toBytes((String)"doot"), Bytes.toBytes((String)"v"));
        Put put2 = new Put(Bytes.toBytes((String)UUID.randomUUID().toString()));
        put2.addColumn(FAMILY, Bytes.toBytes((String)"doot"), Bytes.toBytes((String)"v"));
        Increment inc = new Increment(Bytes.toBytes((String)UUID.randomUUID().toString()));
        inc.addColumn(FAMILY, Bytes.toBytes((String)"doot"), 1L);
        ArrayList<Put> puts = new ArrayList<Put>(2);
        puts.add(put1);
        puts.add(put2);
        try (Table table = this.getTable();){
            for (int i = 0; i < 100; ++i) {
                table.put(puts);
            }
        }
    }

    @Test
    public void testCheckAndMutateCountedAgainstReadCapacity() throws Exception {
        this.setupQuota();
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        byte[] value = Bytes.toBytes((String)"v");
        Put put = new Put(row);
        put.addColumn(FAMILY, Bytes.toBytes((String)"doot"), value);
        CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])row).ifEquals(FAMILY, QUALIFIER, value).build(put);
        this.testThrottle(table -> table.checkAndMutate(checkAndMutate));
    }

    @Test
    public void testAtomicBatchCountedAgainstReadCapacity() throws Exception {
        this.setupQuota();
        byte[] row = Bytes.toBytes((String)UUID.randomUUID().toString());
        Increment inc = new Increment(row);
        inc.addColumn(FAMILY, Bytes.toBytes((String)"doot"), 1L);
        ArrayList<Increment> incs = new ArrayList<Increment>(2);
        incs.add(inc);
        incs.add(inc);
        this.testThrottle(table -> {
            Object[] results = new Object[incs.size()];
            table.batch(incs, results);
            return results;
        });
    }

    private void setupQuota() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)User.getCurrent().getShortName(), (ThrottleType)ThrottleType.READ_NUMBER, (long)1L, (TimeUnit)TimeUnit.MINUTES));
        }
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
    }

    private void cleanupQuota() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)User.getCurrent().getShortName()));
        }
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testThrottle(ThrowingFunction<Table, ?> request) throws Exception {
        try (Table table = this.getTable();){
            TEST_UTIL.waitFor(60000L, () -> {
                Throwable ex;
                boolean success;
                try {
                    request.run(table);
                    return false;
                }
                catch (RetriesExhaustedWithDetailsException e) {
                    success = e.getCauses().stream().allMatch(t -> t instanceof RpcThrottlingException || t.getCause() instanceof RpcThrottlingException);
                    ex = e;
                }
                catch (Exception e) {
                    success = e.getCause() instanceof RpcThrottlingException;
                    ex = e;
                }
                if (!success) {
                    LOG.error("Unexpected exception", ex);
                }
                return success;
            });
        }
        finally {
            this.cleanupQuota();
        }
    }

    private Table getTable() throws IOException {
        return TEST_UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setOperationTimeout(250).build();
    }

    @FunctionalInterface
    private static interface ThrowingFunction<I, O> {
        public O run(I var1) throws Exception;
    }
}

