/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface BlockCache
extends Iterable<CachedBlock> {
    public void cacheBlock(BlockCacheKey var1, Cacheable var2, boolean var3);

    default public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory, boolean waitWhenCache) {
        this.cacheBlock(cacheKey, buf, inMemory);
    }

    public void cacheBlock(BlockCacheKey var1, Cacheable var2);

    public Cacheable getBlock(BlockCacheKey var1, boolean var2, boolean var3, boolean var4);

    public boolean evictBlock(BlockCacheKey var1);

    public int evictBlocksByHfileName(String var1);

    public CacheStats getStats();

    public void shutdown();

    public long size();

    public long getMaxSize();

    public long getFreeSize();

    public long getCurrentSize();

    public long getCurrentDataSize();

    public long getBlockCount();

    public long getDataBlockCount();

    @Override
    public Iterator<CachedBlock> iterator();

    public BlockCache[] getBlockCaches();

    default public boolean isMetaBlock(BlockType blockType) {
        return blockType != null && blockType.getCategory() != BlockType.BlockCategory.DATA;
    }

    default public void notifyFileCachingCompleted(Path fileName, int totalBlockCount, int dataBlockCount, long size) {
    }

    default public Optional<Boolean> blockFitsIntoTheCache(HFileBlock block) {
        return Optional.empty();
    }

    default public Optional<Boolean> shouldCacheFile(String fileName) {
        return Optional.empty();
    }

    default public Optional<Boolean> isAlreadyCached(BlockCacheKey key) {
        return Optional.empty();
    }

    default public Optional<Integer> getBlockSize(BlockCacheKey key) {
        return Optional.empty();
    }

    default public Optional<Map<String, Pair<String, Long>>> getFullyCachedFiles() {
        return Optional.empty();
    }

    default public Optional<Map<String, Long>> getRegionCachedInfo() {
        return Optional.empty();
    }
}

