package org.apache.hadoop.hbase.generated.master;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;

public final class quotas_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write('\n');
      out.write('\n');

  HMaster master = (HMaster) getServletContext().getAttribute(HMaster.MASTER);
  pageContext.setAttribute("pageTitle", "HBase Master Quotas: " + master.getServerName());
  List<ThrottleSettings> regionServerThrottles = new ArrayList<>();
  List<ThrottleSettings> namespaceThrottles = new ArrayList<>();
  List<ThrottleSettings> userThrottles = new ArrayList<>();
  MasterQuotaManager quotaManager = master.getMasterQuotaManager();
  boolean exceedThrottleQuotaEnabled = false;
  if (quotaManager != null) {
    exceedThrottleQuotaEnabled = quotaManager.isExceedThrottleQuotaEnabled();
    try (QuotaRetriever scanner = new QuotaRetriever(master.getConnection())) {
      for (QuotaSettings quota : scanner) {
        if (quota instanceof ThrottleSettings) {
          ThrottleSettings throttle = (ThrottleSettings) quota;
          if (throttle.getUserName() != null) {
            userThrottles.add(throttle);
          } else if (throttle.getNamespace() != null) {
            namespaceThrottles.add(throttle);
          } else if (throttle.getRegionServer() != null) {
            regionServerThrottles.add(throttle);
          }
        }
      }
    }
  }

      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "header.jsp" + "?" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode("pageTitle", request.getCharacterEncoding())+ "=" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode((java.lang.String) org.apache.jasper.runtime.PageContextImpl.evaluateExpression("${pageTitle}", java.lang.String.class, (PageContext)_jspx_page_context, null), request.getCharacterEncoding()), out, false);
      out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h1>Throttle Quotas</h1>\n    </div>\n  </div>\n</div>\n\n");
if (quotaManager != null) {
      out.write("\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Rpc Throttle Enabled</h2>\n    </div>\n  </div>\n  ");
if (quotaManager.isRpcThrottleEnabled()) {
      out.write("\n  <div class=\"alert alert-success\">\n    Rpc throttle is enabled.\n  </div>\n  ");
 } else {
      out.write("\n  <div class=\"alert alert-info\">\n    Rpc throttle is disabled. All requests will not be throttled.<br/>\n    Use 'enable_rpc_throttle' shell command to enable it.\n  </div>\n  ");
 } 
      out.write("\n</div>\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Exceed Throttle Quota Enabled</h2>\n    </div>\n  </div>\n  ");
if (exceedThrottleQuotaEnabled) {
      out.write("\n  <div class=\"alert alert-success\">\n    Exceed throttle quota is enabled. The user/table/namespace throttle quotas can exceed the limit\n    if a region server has available quotas.<br/>\n    Use 'disable_exceed_throttle_quota' shell command to disable it.\n  </div>\n  ");
 } else {
      out.write("\n  <div class=\"alert alert-info\">\n    Exceed throttle quota is disabled.\n  </div>\n  ");
 } 
      out.write("\n</div>\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>RegionServer Throttle Quotas</h2>\n    </div>\n  </div>\n");

  if (regionServerThrottles.size() > 0) {

      out.write("\n  <table class=\"table table-striped\" width=\"90%\" >\n    <tr>\n      <th>RegionServer</th>\n      <th>Limit</th>\n      <th>Type</th>\n      <th>TimeUnit</th>\n      <th>Scope</th>\n    </tr>\n    ");
 for (ThrottleSettings throttle : regionServerThrottles) { 
      out.write("\n      <tr>\n        <td>");
      out.print( throttle.getRegionServer() == null ? "" : throttle.getRegionServer() );
      out.write("</td>\n        <td>");
      out.print( throttle.getSoftLimit() );
      out.write("</td>\n        <td>");
      out.print( throttle.getThrottleType() );
      out.write("</td>\n        <td>");
      out.print( throttle.getTimeUnit() );
      out.write("</td>\n        <td>");
      out.print( throttle.getQuotaScope() );
      out.write("</td>\n        ");
 if (exceedThrottleQuotaEnabled && throttle.getTimeUnit() != null && throttle.getTimeUnit() != TimeUnit.SECONDS) { 
      out.write("\n        <td style=\"color:red;\">Exceed throttle quota is enabled, but RegionServer throttle is not in SECONDS time unit.</td>\n        ");
 }
      out.write("\n      </tr>\n    ");
 } 
      out.write("\n  </table>\n  ");
 } else if (exceedThrottleQuotaEnabled) { 
      out.write("\n  <div class=\"alert alert-danger\">\n    Exceed throttle quota is enabled, but RegionServer throttle quotas are not set.<br/>\n    Please set RegionServer read and write throttle quotas in SECONDS time unit.<br/>\n    eg. set_quota TYPE => THROTTLE, REGIONSERVER => 'all', THROTTLE_TYPE => WRITE, LIMIT => '20000req/sec'\n  </div>\n  ");
}
      out.write("\n</div>\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>Namespace Throttle Quotas</h2>\n    </div>\n  </div>\n  ");

    if (namespaceThrottles.size() > 0) {
  
      out.write("\n  <table class=\"table table-striped\" width=\"90%\" >\n    <tr>\n      <th>Namespace</th>\n      <th>Limit</th>\n      <th>Type</th>\n      <th>TimeUnit</th>\n      <th>Scope</th>\n    </tr>\n    ");
 for (ThrottleSettings throttle : namespaceThrottles) { 
      out.write("\n    <tr>\n      <td>");
      out.print( throttle.getNamespace() == null ? "" : throttle.getNamespace() );
      out.write("</td>\n      <td>");
      out.print( throttle.getSoftLimit() );
      out.write("</td>\n      <td>");
      out.print( throttle.getThrottleType() );
      out.write("</td>\n      <td>");
      out.print( throttle.getTimeUnit() );
      out.write("</td>\n      <td>");
      out.print( throttle.getQuotaScope() );
      out.write("</td>\n    </tr>\n    ");
 } 
      out.write("\n  </table>\n  ");
 } 
      out.write("\n</div>\n\n<div class=\"container-fluid content\">\n  <div class=\"row\">\n    <div class=\"page-header\">\n      <h2>User Throttle Quotas</h2>\n    </div>\n  </div>\n  ");

    if (userThrottles.size() > 0) {
  
      out.write("\n  <table class=\"table table-striped\" width=\"90%\" >\n    <tr>\n      <th>User</th>\n      <th>Namespace</th>\n      <th>Table</th>\n      <th>Limit</th>\n      <th>Type</th>\n      <th>TimeUnit</th>\n      <th>Scope</th>\n    </tr>\n    ");
 for (ThrottleSettings throttle : userThrottles) { 
      out.write("\n    <tr>\n      <td>");
      out.print( throttle.getUserName() == null ? "" : throttle.getUserName() );
      out.write("</td>\n      <td>");
      out.print( throttle.getNamespace() == null ? "" : throttle.getNamespace() );
      out.write("</td>\n      <td>");
      out.print( throttle.getTableName() == null ? "" : throttle.getTableName() );
      out.write("</td>\n      <td>");
      out.print( throttle.getSoftLimit() );
      out.write("</td>\n      <td>");
      out.print( throttle.getThrottleType() );
      out.write("</td>\n      <td>");
      out.print( throttle.getTimeUnit() );
      out.write("</td>\n      <td>");
      out.print( throttle.getQuotaScope() );
      out.write("</td>\n    </tr>\n    ");
 } 
      out.write("\n  </table>\n  ");
 } 
      out.write("\n</div>\n\n");
 } 
      out.write('\n');
      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "footer.jsp", out, false);
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
