// Autogenerated Jamon implementation
// /home/ndimiduk/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/BlockCacheTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 32, 1
import java.util.Map;
// 33, 1
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
// 34, 1
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil.CachedBlocksByFile;
// 35, 1
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
// 36, 1
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
// 37, 1
import org.apache.hadoop.conf.Configuration;
// 38, 1
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
// 39, 1
import org.apache.hadoop.hbase.io.hfile.BlockCache;
// 40, 1
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
// 41, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
// 42, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
// 43, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
// 44, 1
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator.Bucket;
// 45, 1
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class BlockCacheTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.Intf

{
  private final CacheConfig cacheConfig;
  private final Configuration config;
  private final BlockCache bc;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public BlockCacheTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    cacheConfig = p_implData.getCacheConfig();
    config = p_implData.getConfig();
    bc = p_implData.getBc();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 25, 1
    
  String bcUrl = bc == null ? null : "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
  String bcName = bc == null ? null : bc.getClass().getSimpleName();
  BlockCache [] bcs = bc == null ? null : bc.getBlockCaches();
  boolean evictions = bcs != null && bcs.length > 1;

    // 47, 1
    jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_bc_baseInfo\" data-toggle=\"tab\">Base Info</a></li>\n        <li class=\"\"><a href=\"#tab_bc_config\" data-toggle=\"tab\">Config</a></li>\n        <li class=\"\"><a href=\"#tab_bc_stats\" data-toggle=\"tab\">Stats</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l1\" data-toggle=\"tab\">L1</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l2\" data-toggle=\"tab\">L2</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_bc_baseInfo\">\n            ");
    // 57, 13
    {
      // 57, 13
      __jamon_innerUnit__bc_baseInfo(jamonWriter, bc, bcUrl, bcName);
    }
    // 57, 73
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_config\">\n            ");
    // 60, 13
    {
      // 60, 13
      __jamon_innerUnit__bc_config(jamonWriter, cacheConfig );
    }
    // 60, 55
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_stats\">\n            ");
    // 63, 13
    {
      // 63, 13
      __jamon_innerUnit__bc_stats(jamonWriter, bc );
    }
    // 63, 36
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l1\">\n            ");
    // 66, 13
    {
      // 66, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? bc: bcs[0], "L1", evictions);
    }
    // 66, 90
    jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l2\">\n            ");
    // 69, 13
    {
      // 69, 13
      __jamon_innerUnit__bc_l(jamonWriter, bcs == null? null: bcs.length <= 1? null: bcs[1], "L2", evictions);
    }
    // 69, 115
    jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
  }
  
  
  // 74, 1
  private void __jamon_innerUnit__bc_baseInfo(final java.io.Writer jamonWriter, final BlockCache bc, final String bcUrl, final String bcName)
    throws java.io.IOException
  {
    // 80, 1
    
  BlockCache [] bcs = bc == null? null: bc.getBlockCaches();
  String bcl1Url = null;
  String bcl1Name = null;
  String bcl2Url = null;
  String bcl2Name = null;
  if (bcs != null) {
    BlockCache bcl1 = bcs[0];
    if (bcl1 != null) {
      bcl1Url = "http://hbase.apache.org/devapidocs/" + bcl1.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl1Name = bcl1.getClass().getSimpleName();
    }
    if (bcs.length == 2) {
      BlockCache bcl2 = bcs[1];
      bcl2Url = "http://hbase.apache.org/devapidocs/" + bcl2.getClass().getName().replaceAll("\\.", "/") + ".html";
      bcl2Name = bcl2.getClass().getSimpleName();
    }
  }

    // 99, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 108, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 108, 33
    jamonWriter.write("\">");
    // 108, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcName), jamonWriter);
    // 108, 47
    jamonWriter.write("</a></td>\n        <td>Block cache implementing class</td>\n    </tr>\n</table>\n<p>See <a href=\"http://hbase.apache.org/book.html#block.cache\">block cache</a> in the HBase Reference Guide for help.</p>\n");
  }
  
  
  // 115, 1
  private void __jamon_innerUnit__bc_config(final java.io.Writer jamonWriter, final CacheConfig cacheConfig)
    throws java.io.IOException
  {
    // 119, 1
    if (cacheConfig == null )
    {
      // 119, 28
      jamonWriter.write("\n<p>CacheConfig is null</p>\n");
    }
    // 121, 1
    else
    {
      // 121, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Cache DATA on Read</td>\n        <td>");
      // 130, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnRead()), jamonWriter);
      // 130, 54
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on read\n        (INDEX & BLOOM blocks are always cached)</td>\n    </tr>\n    <tr>\n        <td>Cache DATA on Write</td>\n        <td>");
      // 136, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataOnWrite()), jamonWriter);
      // 136, 55
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on write.</td>\n    </tr>\n    <tr>\n        <td>Cache INDEX on Write</td>\n        <td>");
      // 141, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheIndexesOnWrite()), jamonWriter);
      // 141, 58
      jamonWriter.write("</td>\n        <td>True if INDEX blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Cache BLOOM on Write</td>\n        <td>");
      // 146, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheBloomsOnWrite()), jamonWriter);
      // 146, 57
      jamonWriter.write("</td>\n        <td>True if BLOOM blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Evict blocks on Close</td>\n        <td>");
      // 151, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldEvictOnClose()), jamonWriter);
      // 151, 51
      jamonWriter.write("</td>\n        <td>True if blocks are evicted from cache when an HFile\n        reader is closed</td>\n    </tr>\n    <tr>\n        <td>Cache DATA in compressed format</td>\n        <td>");
      // 157, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldCacheDataCompressed()), jamonWriter);
      // 157, 58
      jamonWriter.write("</td>\n        <td>True if DATA blocks are cached in their compressed form</td>\n    </tr>\n    <tr>\n        <td>Prefetch on Open</td>\n        <td>");
      // 162, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(cacheConfig.shouldPrefetchOnOpen()), jamonWriter);
      // 162, 53
      jamonWriter.write("</td>\n        <td>True if blocks are prefetched into cache on open</td>\n    </tr>\n</table>\n");
    }
    // 166, 7
    jamonWriter.write("\n");
  }
  
  
  // 264, 1
  private void __jamon_innerUnit__bc_l(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 270, 1
    if (bc == null )
    {
      // 270, 19
      jamonWriter.write("\n<p>No ");
      // 271, 7
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
      // 271, 17
      jamonWriter.write(" deployed</p>\n");
    }
    // 272, 1
    else
    {
      // 272, 8
      jamonWriter.write("\n");
      // 273, 1
      {
        // 273, 1
        __jamon_innerUnit__block_cache(jamonWriter, bc, name, evictions);
      }
      // 273, 65
      jamonWriter.write("\n");
    }
    // 274, 7
    jamonWriter.write("\n");
  }
  
  
  // 226, 1
  private void __jamon_innerUnit__bc_stats(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 230, 1
    if (bc == null )
    {
      // 230, 19
      jamonWriter.write("\n<p>BlockCache is null</p>\n");
    }
    // 232, 1
    else
    {
      // 232, 8
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Size</td>\n        <td>");
      // 241, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentSize(),
            "B", 1)), jamonWriter);
      // 242, 23
      jamonWriter.write("</td>\n        <td>Current size of block cache in use</td>\n    </tr>\n    <tr>\n        <td>Free</td>\n        <td>");
      // 247, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getFreeSize(),
            "B", 1)), jamonWriter);
      // 248, 23
      jamonWriter.write("</td>\n        <td>The total free memory currently available to store more cache entries</td>\n    </tr>\n    <tr>\n        <td>Count</td>\n        <td>");
      // 253, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getBlockCount())), jamonWriter);
      // 253, 59
      jamonWriter.write("</td>\n        <td>Number of blocks in block cache</td>\n    </tr>\n    ");
      // 256, 5
      {
        // 256, 5
        __jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
      }
      // 256, 35
      jamonWriter.write("\n    ");
      // 257, 5
      {
        // 257, 5
        __jamon_innerUnit__hits_tmpl(jamonWriter, bc);
      }
      // 257, 30
      jamonWriter.write("\n</table>\n<p>If block cache is made up of more than one cache -- i.e. a L1 and a L2 -- then the above\nare combined counts. Request count is sum of hits and misses.</p>\n");
    }
    // 261, 7
    jamonWriter.write("\n");
  }
  
  
  // 277, 1
  private void __jamon_innerUnit__block_cache(final java.io.Writer jamonWriter, final BlockCache bc, final String name, final boolean evictions)
    throws java.io.IOException
  {
    // 283, 1
    
  String bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
  String bcName = bc.getClass().getSimpleName();
  int maxCachedBlocksByFile = BlockCacheUtil.getMaxCachedBlocksByFile(config);

  boolean lru = bc instanceof LruBlockCache;

  boolean bucketCache = bc.getClass().getSimpleName().equals("BucketCache");
  BucketCacheStats bucketCacheStats = null;
  BucketAllocator bucketAllocator = null;

  if (bucketCache) {
    bucketCacheStats = (BucketCacheStats)bc.getStats();
    bucketAllocator = ((BucketCache)bc).getAllocator();
  }

    // 299, 1
    jamonWriter.write("<table id=\"blocks_summary\" class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
    // 307, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bcUrl), jamonWriter);
    // 307, 33
    jamonWriter.write("\">");
    // 307, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bc.getClass().getSimpleName()), jamonWriter);
    // 307, 70
    jamonWriter.write("</a></td>\n        <td>Class implementing this block cache Level</td>\n    </tr>\n");
    // 310, 1
    if (bucketCache )
    {
      // 310, 20
      jamonWriter.write("\n    <tr>\n        <td>Implementation</td>\n        <td>");
      // 313, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(((BucketCache)bc).getIoEngine()), jamonWriter);
      // 313, 50
      jamonWriter.write("</a></td>\n        <td>IOEngine</td>\n    </tr>\n");
    }
    // 316, 7
    jamonWriter.write("\n    <tr>\n        <td>Cache Size Limit</td>\n        <td>");
    // 319, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getMaxSize(), "B", 1)), jamonWriter);
    // 319, 79
    jamonWriter.write("</td>\n        <td>Max size of cache</td>\n    </tr>\n    <tr>\n        <td>Block Count</td>\n        <td>");
    // 324, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getBlockCount())), jamonWriter);
    // 324, 59
    jamonWriter.write("</td>\n        <td>Count of Blocks</td>\n    </tr>\n");
    // 327, 1
    if (!bucketCache )
    {
      // 327, 21
      jamonWriter.write("\n    <tr>\n        <td>Data Block Count</td>\n        <td>");
      // 330, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getDataBlockCount())), jamonWriter);
      // 330, 63
      jamonWriter.write("</td>\n        <td>Count of DATA Blocks</td>\n    </tr>\n");
    }
    // 333, 7
    jamonWriter.write("\n");
    // 334, 1
    if (lru )
    {
      // 334, 12
      jamonWriter.write("\n    <tr>\n        <td>Index Block Count</td>\n        <td>");
      // 337, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", ((LruBlockCache)bc).getIndexBlockCount())), jamonWriter);
      // 337, 81
      jamonWriter.write("</td>\n        <td>Count of INDEX Blocks</td>\n    </tr>\n    <tr>\n        <td>Bloom Block Count</td>\n        <td>");
      // 342, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", ((LruBlockCache)bc).getBloomBlockCount())), jamonWriter);
      // 342, 81
      jamonWriter.write("</td>\n        <td>Count of BLOOM Blocks</td>\n    </tr>\n");
    }
    // 345, 7
    jamonWriter.write("\n      <tr>\n        <td>Size of Blocks</td>\n        <td>");
    // 348, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentSize(), "B", 1)), jamonWriter);
    // 348, 83
    jamonWriter.write("</td>\n        <td>Size of Blocks</td>\n    </tr>\n");
    // 351, 1
    if (!bucketCache )
    {
      // 351, 21
      jamonWriter.write("\n    <tr>\n        <td>Size of Data Blocks</td>\n        <td>");
      // 354, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(bc.getCurrentDataSize(), "B", 1)), jamonWriter);
      // 354, 87
      jamonWriter.write("</td>\n        <td>Size of DATA Blocks</td>\n    </tr>\n");
    }
    // 357, 7
    jamonWriter.write(" \n");
    // 358, 1
    if (lru )
    {
      // 358, 12
      jamonWriter.write("\n    <tr>\n        <td>Size of Index Blocks</td>\n        <td>");
      // 361, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(((LruBlockCache)bc).getCurrentIndexSize(), "B", 1)), jamonWriter);
      // 361, 105
      jamonWriter.write("</td>\n        <td>Size of INDEX Blocks</td>\n    </tr>\n    <tr>\n        <td>Size of Bloom Blocks</td>\n        <td>");
      // 366, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(((LruBlockCache)bc).getCurrentBloomSize(), "B", 1)), jamonWriter);
      // 366, 105
      jamonWriter.write("</td>\n        <td>Size of BLOOM Blocks</td>\n    </tr>\n");
    }
    // 369, 7
    jamonWriter.write("\n ");
    // 370, 2
    {
      // 370, 2
      __jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
    }
    // 370, 32
    jamonWriter.write("\n");
    // 371, 1
    {
      // 371, 1
      __jamon_innerUnit__hits_tmpl(jamonWriter, bc);
    }
    // 371, 26
    jamonWriter.write("\n\n");
    // 373, 1
    if (bucketCache )
    {
      // 373, 20
      jamonWriter.write("\n    <tr>\n        <td>Hits per Second</td>\n        <td>");
      // 376, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOHitsPerSecond()), jamonWriter);
      // 376, 56
      jamonWriter.write("</td>\n        <td>Block gets against this cache per second</td>\n    </tr>\n    <tr>\n        <td>Time per Hit</td>\n        <td>");
      // 381, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bucketCacheStats.getIOTimePerHit()), jamonWriter);
      // 381, 53
      jamonWriter.write("</td>\n        <td>Time per cache hit</td>\n    </tr>\n");
    }
    // 384, 7
    jamonWriter.write("\n</table>\n<p>\nView block cache <a href=\"?format=json&bcn=");
    // 388, 44
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 388, 54
    jamonWriter.write("\">as JSON</a> | Block cache <a href=\"?format=json&bcn=");
    // 388, 108
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(name), jamonWriter);
    // 388, 118
    jamonWriter.write("&bcv=file\">as JSON by file</a>\n");
    // 389, 1
    if (bc.getBlockCount() > maxCachedBlocksByFile )
    {
      // 389, 51
      jamonWriter.write("\n<br>\n<b>Note</b>: JSON view of block cache will be incomplete, because block count ");
      // 391, 79
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bc.getBlockCount()), jamonWriter);
      // 391, 103
      jamonWriter.write(" is greater than <i>hbase.ui.blockcache.by.file.max</i> value of ");
      // 391, 168
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(maxCachedBlocksByFile), jamonWriter);
      // 391, 195
      jamonWriter.write(".\nIncrease that value to get a complete picture.\n");
    }
    // 393, 7
    jamonWriter.write("\n</p>\n");
  }
  
  
  // 169, 1
  private void __jamon_innerUnit__evictions_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 173, 1
    
  AgeSnapshot ageAtEvictionSnapshot = bc.getStats().getAgeAtEvictionSnapshot();
  // Only show if non-zero mean and stddev as is the case in combinedblockcache

    // 177, 5
    jamonWriter.write("<tr>\n        <td>Evicted</td>\n        <td>");
    // 179, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictedCount())), jamonWriter);
    // 179, 72
    jamonWriter.write("</td>\n        <td>The total number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
    // 184, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getEvictionCount())), jamonWriter);
    // 184, 73
    jamonWriter.write("</td>\n        <td>The total number of times an eviction has occurred</td>\n    </tr>\n    <tr>\n        <td>Mean</td>\n        <td>");
    // 189, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", (long)ageAtEvictionSnapshot.getMean())), jamonWriter);
    // 189, 78
    jamonWriter.write("</td>\n        <td>Mean age of Blocks at eviction time (seconds)</td>\n    </tr>\n");
  }
  
  
  // 194, 1
  private void __jamon_innerUnit__hits_tmpl(final java.io.Writer jamonWriter, final BlockCache bc)
    throws java.io.IOException
  {
    // 198, 5
    jamonWriter.write("<tr>\n        <td>Hits</td>\n        <td>");
    // 200, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCount())), jamonWriter);
    // 200, 68
    jamonWriter.write("</td>\n        <td>Number requests that were cache hits</td>\n    </tr>\n    <tr>\n        <td>Hits Caching</td>\n        <td>");
    // 205, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getHitCachingCount())), jamonWriter);
    // 205, 75
    jamonWriter.write("</td>\n        <td>Cache hit block requests but only requests set to cache block if a miss</td>\n    </tr>\n    <tr>\n        <td>Misses</td>\n        <td>");
    // 210, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
    // 210, 69
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but set to cache missed blocks</td>\n    </tr>\n    <tr>\n        <td>Misses Caching</td>\n        <td>");
    // 215, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", bc.getStats().getMissCachingCount())), jamonWriter);
    // 215, 76
    jamonWriter.write("</td>\n        <td>Block requests that were cache misses but only requests set to use block cache</td>\n    </tr>\n    <tr>\n        <td>Hit Ratio</td>\n        <td>");
    // 220, 13
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,.2f", bc.getStats().getHitRatio() * 100)), jamonWriter);
    // 220, 76
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf("%"), jamonWriter);
    // 220, 85
    jamonWriter.write("</td>\n        <td>Hit Count divided by total requests count</td>\n    </tr>\n\n");
  }
  
  
}
