// Autogenerated Jamon implementation
// /home/ndimiduk/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.commons.lang3.time.FastDateFormat;
// 26, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 27, 9
import org.apache.hadoop.hbase.util.Bytes;
// 28, 9
import org.apache.hadoop.hbase.client.RegionInfo;
// 29, 9
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
// 30, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 31, 9
import org.apache.hadoop.hbase.regionserver.HStoreFile;
// 32, 9
import org.apache.hadoop.hbase.regionserver.Store;
// 33, 9
import org.apache.hadoop.hbase.regionserver.StoreFile;
// 34, 9
import org.apache.hadoop.hbase.ServerName;
// 35, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 36, 9
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
// 37, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos.ServerInfo;
// 38, 9
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 39, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 40, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
// 41, 9
import org.apache.hadoop.util.StringUtils;
// 42, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<RegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 44, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 44, 60
      jamonWriter.write("\n\n    ");
      // 46, 5
      
        Collections.sort(onlineRegions, RegionInfo.COMPARATOR);
    
      // 50, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 60, 17
      {
        // 60, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 60, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 63, 17
      {
        // 63, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 63, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 66, 17
      {
        // 66, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 66, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 69, 17
      {
        // 69, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 69, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 72, 17
      {
        // 72, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 72, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.apache.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 87, 1
    else
    {
      // 87, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 89, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 91, 1
  private void __jamon_innerUnit__baseInfo(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 95, 5
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 106, 9
    for (RegionInfo r: onlineRegions )
    {
      // 106, 45
      jamonWriter.write("\n        <tr>\n            ");
      // 108, 13
      
             String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
               regionServer.getConfiguration());
            
      // 112, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 112, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 112, 66
      jamonWriter.write("\">");
      // 112, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 112, 85
      jamonWriter.write("</a></td>\n            <td>");
      // 113, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getStartKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 114, 77
      jamonWriter.write("</td>\n            <td>");
      // 115, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(RegionInfoDisplay.getEndKeyForDisplay(r,
                                        regionServer.getConfiguration()))), jamonWriter);
      // 116, 77
      jamonWriter.write("</td>\n            <td>");
      // 117, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 117, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 119, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 251, 1
  private void __jamon_innerUnit__compactStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 255, 5
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting Cells</th>\n            <th>Num. Compacted Cells</th>\n            <th>Compaction Progress</th>\n            <th data-date-format=\"yyyymmdd hhmm zz\">Last Major Compaction</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 267, 9
    for (RegionInfo r: onlineRegions )
    {
      // 267, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 270, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            String compactTime = "";
            if  (load != null) {
              if (load.getTotalCompactingKVs() > 0) {
                percentDone = String.format("%.2f", 100 *
                    ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
              }
              if (load.getLastMajorCompactionTs() > 0) {
                FastDateFormat fdf = FastDateFormat.getInstance("yyyy-MM-dd HH:mm (ZZ)");
                compactTime = fdf.format(load.getLastMajorCompactionTs());
              }
            }
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 287, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 287, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 287, 66
      jamonWriter.write("\">");
      // 287, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 287, 85
      jamonWriter.write("</a></td>\n            ");
      // 288, 13
      if (load != null )
      {
        // 288, 33
        jamonWriter.write("\n            <td>");
        // 289, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getTotalCompactingKVs())), jamonWriter);
        // 289, 74
        jamonWriter.write("</td>\n            <td>");
        // 290, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getCurrentCompactedKVs())), jamonWriter);
        // 290, 75
        jamonWriter.write("</td>\n            <td>");
        // 291, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 291, 34
        jamonWriter.write("</td>\n            <td>");
        // 292, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(compactTime), jamonWriter);
        // 292, 34
        jamonWriter.write("</td>\n            ");
      }
      // 293, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 295, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 300, 1
  private void __jamon_innerUnit__memstoreStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 304, 5
    jamonWriter.write("<table id=\"memstoreStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 313, 9
    for (RegionInfo r: onlineRegions )
    {
      // 313, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 316, 9
      
            final String ZEROMB = "0 MB";
            String memStoreSizeMBStr = ZEROMB;
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
              if (load != null) {
              long memStoreSizeMB = load.getMemStoreSizeMB();
              if (memStoreSizeMB > 0) {
              memStoreSizeMBStr = TraditionalBinaryPrefix.long2String(
                         memStoreSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
               }
             }
        
      // 330, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 330, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 330, 66
      jamonWriter.write("\">");
      // 330, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 330, 85
      jamonWriter.write("</a></td>\n            ");
      // 331, 13
      if (load != null )
      {
        // 331, 33
        jamonWriter.write("\n            <td>");
        // 332, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(memStoreSizeMBStr), jamonWriter);
        // 332, 40
        jamonWriter.write("</td>\n            ");
      }
      // 333, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 335, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 124, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 128, 5
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Filtered Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 139, 9
    for (RegionInfo r: onlineRegions )
    {
      // 139, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 142, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
        
      // 147, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 147, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 147, 66
      jamonWriter.write("\">");
      // 147, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 147, 85
      jamonWriter.write("</a></td>\n            ");
      // 148, 13
      if (load != null )
      {
        // 148, 33
        jamonWriter.write("\n            <td>");
        // 149, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getReadRequestsCount())), jamonWriter);
        // 149, 73
        jamonWriter.write("</td>\n            <td>");
        // 150, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getFilteredReadRequestsCount())), jamonWriter);
        // 150, 81
        jamonWriter.write("</td>\n            <td>");
        // 151, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getWriteRequestsCount())), jamonWriter);
        // 151, 74
        jamonWriter.write("</td>\n            ");
      }
      // 152, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 154, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
  // 160, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final List<RegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 164, 5
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n            <th>Len Of Biggest Cell</th>\n            <th>% Cached</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
    // 181, 9
    for (RegionInfo r: onlineRegions )
    {
      // 181, 45
      jamonWriter.write("\n\n        <tr>\n        ");
      // 184, 9
      
            final String ZEROMB = "0 MB";
            final String ZEROKB = "0 KB";
            String uncompressedStorefileSizeStr = ZEROMB;
            String storefileSizeStr = ZEROMB;
            String indexSizeStr = ZEROKB;
            String bloomSizeStr = ZEROKB;
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay(r,
              regionServer.getConfiguration());
             if (load != null) {
             long uncompressedStorefileSize  = load.getStoreUncompressedSizeMB();
             long storefileSize  = load.getStorefileSizeMB();
             long indexSize  = load.getTotalStaticIndexSizeKB();
             long bloomSize  = load.getTotalStaticBloomSizeKB();
             if (uncompressedStorefileSize > 0) {
                uncompressedStorefileSizeStr = TraditionalBinaryPrefix.long2String(
                    uncompressedStorefileSize * TraditionalBinaryPrefix.MEGA.value, "B", 1);
             }
             if (storefileSize > 0) {
                storefileSizeStr = TraditionalBinaryPrefix.long2String(storefileSize
                             * TraditionalBinaryPrefix.MEGA.value, "B", 1);
             }
             if(indexSize > 0) {
               indexSizeStr = TraditionalBinaryPrefix.long2String(indexSize
                                              * TraditionalBinaryPrefix.KILO.value, "B", 1);
             }
             if (bloomSize > 0) {
               bloomSizeStr = TraditionalBinaryPrefix.long2String(bloomSize
                                              * TraditionalBinaryPrefix.KILO.value, "B", 1);
              }
           }
           long lenOfBiggestCellInRegion = -1L;
           Region region = regionServer.getRegion(r.getEncodedName());
           if (region != null) {
             List<? extends Store> stores = region.getStores();
             for (Store store : stores) {
               Collection<? extends StoreFile> storeFiles = store.getStorefiles();
               for (StoreFile sf : storeFiles) {
                 long lenOfBiggestCell = ((HStoreFile)sf).getFileInfo().getHFileInfo().getLenOfBiggestCell();
                 if (lenOfBiggestCellInRegion < lenOfBiggestCell) {
                   lenOfBiggestCellInRegion = lenOfBiggestCell;
                 }
               }
             }
           }

        
      // 232, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 232, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 232, 66
      jamonWriter.write("\">");
      // 232, 68
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(displayName), jamonWriter);
      // 232, 85
      jamonWriter.write("</a></td>\n            ");
      // 233, 13
      if (load != null )
      {
        // 233, 33
        jamonWriter.write("\n            <td>");
        // 234, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getStores())), jamonWriter);
        // 234, 62
        jamonWriter.write("</td>\n            <td>");
        // 235, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", load.getStorefiles())), jamonWriter);
        // 235, 66
        jamonWriter.write("</td>\n            <td>");
        // 236, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(uncompressedStorefileSizeStr), jamonWriter);
        // 236, 51
        jamonWriter.write("</td>\n            <td>");
        // 237, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storefileSizeStr), jamonWriter);
        // 237, 39
        jamonWriter.write("</td>\n            <td>");
        // 238, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(indexSizeStr), jamonWriter);
        // 238, 35
        jamonWriter.write("</td>\n            <td>");
        // 239, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(bloomSizeStr), jamonWriter);
        // 239, 35
        jamonWriter.write("</td>\n            <td>");
        // 240, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 240, 45
        jamonWriter.write("</td>\n            <td>");
        // 241, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,1d", lenOfBiggestCellInRegion)), jamonWriter);
        // 241, 70
        jamonWriter.write("</td>\n            <td>");
        // 242, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatPercent(load.getCurrentRegionCachedRatio(), 2)), jamonWriter);
        // 242, 87
        jamonWriter.write("</td>\n            ");
      }
      // 243, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 245, 16
    jamonWriter.write("\n    </tbody>\n    </table>\n");
  }
  
  
}
