/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncRegionLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncRegionLocator.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static AsyncConnectionImpl CONN;
    private static AsyncRegionLocator LOCATOR;
    private static volatile long SLEEP_MS;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", SleepRegionObserver.class.getName());
        conf.setLong("hbase.client.meta.operation.timeout", 2000L);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration(), (User)User.getCurrent());
        CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
        LOCATOR = CONN.getLocator();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDownAfterTest() {
        LOCATOR.clearCache();
    }

    @Test
    public void testTimeout() throws InterruptedException, ExecutionException {
        SLEEP_MS = 1000L;
        long startNs = System.nanoTime();
        try {
            LOCATOR.getRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.MILLISECONDS.toNanos(500L)).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(TimeoutIOException.class));
        }
        long costMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        Assert.assertTrue((costMs >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((costMs < 1000L ? 1 : 0) != 0);
        Thread.sleep(2000L);
        HRegionLocation loc = (HRegionLocation)LOCATOR.getRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.MILLISECONDS.toNanos(500L)).get();
        Assert.assertEquals((Object)loc.getServerName(), (Object)TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName());
    }

    @Test
    public void testNoCompletionException() {
        SLEEP_MS = 0L;
        AtomicReference errorHolder = new AtomicReference();
        try {
            ((CompletableFuture)LOCATOR.getRegionLocation(TableName.valueOf((String)"NotExist"), HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, TimeUnit.SECONDS.toNanos(1L)).whenComplete((r, e) -> errorHolder.set(e))).join();
            Assert.fail();
        }
        catch (CompletionException e2) {
            MatcherAssert.assertThat((Object)e2.getCause(), (Matcher)CoreMatchers.instanceOf(TableNotFoundException.class));
        }
        MatcherAssert.assertThat(errorHolder.get(), (Matcher)CoreMatchers.instanceOf(TableNotFoundException.class));
    }

    static {
        SLEEP_MS = 0L;
    }

    public static class SleepRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
            if (SLEEP_MS > 0L) {
                Threads.sleepWithoutInterrupt((long)SLEEP_MS);
            }
        }
    }
}

