/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncSingleRequestRpcRetryingCaller {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncSingleRequestRpcRetryingCaller.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] ROW = Bytes.toBytes((String)"row");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnectionImpl CONN;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ConnectionRegistry registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration(), (User)User.getCurrent());
        CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionMove() throws InterruptedException, ExecutionException, IOException {
        HRegionLocation loc = (HRegionLocation)CONN.getRegionLocator(TABLE_NAME).getRegionLocation(ROW).get();
        int index = TEST_UTIL.getHBaseCluster().getServerWith(loc.getRegion().getRegionName());
        TEST_UTIL.getAdmin().move(loc.getRegion().getEncodedNameAsBytes(), TEST_UTIL.getHBaseCluster().getRegionServer(1 - index).getServerName());
        AsyncTable table = CONN.getTableBuilder(TABLE_NAME).setRetryPause(100L, TimeUnit.MILLISECONDS).setMaxRetries(30).build();
        table.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        TEST_UTIL.getAdmin().move(loc.getRegion().getEncodedNameAsBytes(), loc.getServerName());
        Result result = (Result)table.get(new Get(ROW).addColumn(FAMILY, QUALIFIER)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
    }

    private <T> CompletableFuture<T> failedFuture() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("Inject error!"));
        return future;
    }

    @Test
    public void testMaxRetries() throws IOException, InterruptedException {
        try {
            TestAsyncSingleRequestRpcRetryingCaller.CONN.callerFactory.single().table(TABLE_NAME).row(ROW).operationTimeout(1L, TimeUnit.DAYS).maxAttempts(3).pause(10L, TimeUnit.MILLISECONDS).action((controller, loc, stub) -> this.failedFuture()).call().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
        }
    }

    @Test
    public void testOperationTimeout() throws IOException, InterruptedException {
        long startNs = System.nanoTime();
        try {
            TestAsyncSingleRequestRpcRetryingCaller.CONN.callerFactory.single().table(TABLE_NAME).row(ROW).operationTimeout(1L, TimeUnit.SECONDS).pause(100L, TimeUnit.MILLISECONDS).maxAttempts(Integer.MAX_VALUE).action((controller, loc, stub) -> this.failedFuture()).call().get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
        }
        long costNs = System.nanoTime() - startNs;
        Assert.assertTrue((costNs >= TimeUnit.SECONDS.toNanos(1L) ? 1 : 0) != 0);
        Assert.assertTrue((costNs < TimeUnit.SECONDS.toNanos(2L) ? 1 : 0) != 0);
    }

    @Test
    public void testLocateError() throws IOException, InterruptedException, ExecutionException {
        final AtomicBoolean errorTriggered = new AtomicBoolean(false);
        final AtomicInteger count = new AtomicInteger(0);
        final HRegionLocation loc = (HRegionLocation)CONN.getRegionLocator(TABLE_NAME).getRegionLocation(ROW).get();
        final AsyncRegionLocator mockedLocator = new AsyncRegionLocator(CONN, AsyncConnectionImpl.RETRY_TIMER){

            CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, int replicaId, RegionLocateType locateType, long timeoutNs) {
                if (tableName.equals((Object)TABLE_NAME)) {
                    CompletableFuture<HRegionLocation> future = new CompletableFuture<HRegionLocation>();
                    if (count.getAndIncrement() == 0) {
                        errorTriggered.set(true);
                        future.completeExceptionally(new RuntimeException("Inject error!"));
                    } else {
                        future.complete(loc);
                    }
                    return future;
                }
                return super.getRegionLocation(tableName, row, replicaId, locateType, timeoutNs);
            }

            void updateCachedLocationOnError(HRegionLocation loc2, Throwable exception) {
            }
        };
        try (AsyncConnectionImpl mockedConn = new AsyncConnectionImpl(CONN.getConfiguration(), TestAsyncSingleRequestRpcRetryingCaller.CONN.registry, (String)TestAsyncSingleRequestRpcRetryingCaller.CONN.registry.getClusterId().get(), User.getCurrent()){

            AsyncRegionLocator getLocator() {
                return mockedLocator;
            }
        };){
            AsyncTable table = mockedConn.getTableBuilder(TABLE_NAME).setRetryPause(100L, TimeUnit.MILLISECONDS).setMaxRetries(5).build();
            table.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE)).get();
            Assert.assertTrue((boolean)errorTriggered.get());
            errorTriggered.set(false);
            count.set(0);
            Result result = (Result)table.get(new Get(ROW).addColumn(FAMILY, QUALIFIER)).get();
            Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
            Assert.assertTrue((boolean)errorTriggered.get());
        }
    }
}

