/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureBasicSnapshot
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureBasicSnapshot.class);

    @Test
    public void testSimpleSnapshotTable() throws Exception {
        TEST_UTIL.getAdmin().snapshot(this.snapshot);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(TEST_UTIL.getAdmin(), this.snapshotProto);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }

    @Test(expected=SnapshotCreationException.class)
    public void testClientTakingTwoSnapshotOnSameTable() throws Exception {
        Thread first = new Thread("first-client"){

            @Override
            public void run() {
                try {
                    TestSnapshotProcedure.TEST_UTIL.getAdmin().snapshot(TestSnapshotProcedureBasicSnapshot.this.snapshot);
                }
                catch (IOException e) {
                    TestSnapshotProcedure.LOG.error("first client failed taking snapshot", (Throwable)e);
                    Assert.fail((String)"first client failed taking snapshot");
                }
            }
        };
        first.start();
        Thread.sleep(1000L);
        SnapshotDescription snapshotWithSameName = new SnapshotDescription(this.SNAPSHOT_NAME, this.TABLE_NAME, SnapshotType.SKIPFLUSH);
        TEST_UTIL.getAdmin().snapshot(snapshotWithSameName);
    }

    @Test(expected=SnapshotCreationException.class)
    public void testClientTakeSameSnapshotTwice() throws IOException, InterruptedException {
        Thread first = new Thread("first-client"){

            @Override
            public void run() {
                try {
                    TestSnapshotProcedure.TEST_UTIL.getAdmin().snapshot(TestSnapshotProcedureBasicSnapshot.this.snapshot);
                }
                catch (IOException e) {
                    TestSnapshotProcedure.LOG.error("first client failed taking snapshot", (Throwable)e);
                    Assert.fail((String)"first client failed taking snapshot");
                }
            }
        };
        first.start();
        Thread.sleep(1000L);
        TEST_UTIL.getAdmin().snapshot(this.snapshot);
    }
}

