/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureRIT
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureRIT.class);

    @Test
    public void testTableInMergeWhileTakingSnapshot() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        List regions = this.master.getAssignmentManager().getTableRegions(this.TABLE_NAME, true).stream().sorted(RegionInfo.COMPARATOR).collect(Collectors.toList());
        MergeTableRegionsProcedure mergeProc = new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), new RegionInfo[]{(RegionInfo)regions.get(0), (RegionInfo)regions.get(1)}, false);
        long mergeProcId = procExec.submitProcedure((Procedure)mergeProc);
        TEST_UTIL.waitFor(10000L, () -> procExec.getProcedure(mergeProcId).getState() == ProcedureProtos.ProcedureState.RUNNABLE);
        SnapshotProcedure sp = new SnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), this.snapshotProto);
        long snapshotProcId = procExec.submitProcedure((Procedure)sp);
        TEST_UTIL.waitFor(2000L, 1000L, () -> procExec.getProcedure(snapshotProcId) != null && procExec.getProcedure(snapshotProcId).getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)snapshotProcId);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }
}

