/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALSyncTimeoutIOException;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AsyncFSWALProvider;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionWALSyncTimeoutIOException
extends MasterRegionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionWALSyncTimeoutIOException.class);
    private static final Duration WAL_SYNC_TIMEOUT = Duration.ofSeconds(3L);
    private static volatile boolean testWalTimeout = false;

    @Override
    protected void configure(Configuration conf) throws IOException {
        conf.setClass("hbase.wal.provider", SlowAsyncFSWALProvider.class, WALProvider.class);
        conf.setLong("hbase.regionserver.wal.sync.timeout", WAL_SYNC_TIMEOUT.toMillis());
    }

    @Override
    protected void configure(MasterRegionParams params) {
        params.flushIntervalMs(Duration.ofSeconds(1L).toMillis());
    }

    @Test
    public void testUpdateWalSyncWriteException() {
        testWalTimeout = true;
        Assert.assertThrows(WALSyncTimeoutIOException.class, () -> {
            for (int i = 0; i < 10; ++i) {
                this.region.update(r -> r.put(new Put(Bytes.toBytes((String)"0")).addColumn(CF1, QUALIFIER, Bytes.toBytes((String)"0"))));
                Thread.sleep(Duration.ofSeconds(1L).toMillis());
            }
        });
    }

    public static class SlowAsyncFSWALProvider
    extends AsyncFSWALProvider {
        protected AsyncFSWAL createWAL() throws IOException {
            return new SlowAsyncFSWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), this.abortable, CommonFSUtils.getWALRootDir((Configuration)this.conf), SlowAsyncFSWALProvider.getWALDirectoryName((String)this.factory.getFactoryId()), SlowAsyncFSWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null, this.eventLoopGroup, this.channelClass, this.factory.getExcludeDatanodeManager().getStreamSlowMonitor(this.providerId));
        }
    }

    public static class SlowAsyncFSWAL
    extends AsyncFSWAL {
        public SlowAsyncFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass, StreamSlowMonitor monitor) throws FailedLogCloseException, IOException {
            super(fs, abortable, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass, monitor);
        }

        protected void atHeadOfRingBufferEventHandlerAppend() {
            if (testWalTimeout) {
                try {
                    Thread.sleep(WAL_SYNC_TIMEOUT.plusSeconds(1L).toMillis());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.atHeadOfRingBufferEventHandlerAppend();
        }
    }
}

