/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.wal.WAL;

public class FaultyProtobufWALStreamReader
extends ProtobufWALStreamReader {
    Queue<WAL.Entry> nextQueue = new ArrayDeque<WAL.Entry>();
    int numberOfFileEntries = 0;

    FailureType getFailureType() {
        return FailureType.valueOf(this.conf.get("faultyprotobuflogreader.failuretype", "NONE"));
    }

    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        WAL.Entry e;
        if (this.nextQueue.isEmpty()) {
            while (true) {
                e = new WAL.Entry();
                if ((e = super.next(e)) == null) break;
                this.nextQueue.offer(e);
                ++this.numberOfFileEntries;
            }
        }
        if (this.nextQueue.size() == this.numberOfFileEntries && this.getFailureType() == FailureType.BEGINNING) {
            throw new IOException("fake Exception");
        }
        if (this.nextQueue.size() == this.numberOfFileEntries / 2 && this.getFailureType() == FailureType.MIDDLE) {
            throw new IOException("fake Exception");
        }
        if (this.nextQueue.size() == 1 && this.getFailureType() == FailureType.END) {
            throw new IOException("fake Exception");
        }
        e = this.nextQueue.poll();
        if (e.getEdit().isEmpty()) {
            return null;
        }
        return e;
    }

    public static enum FailureType {
        BEGINNING,
        MIDDLE,
        END,
        NONE;

    }
}

