/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyTLSIPCFileWatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyTLSIPCFileWatcher.class);
    private static final Configuration CONF = HBaseConfiguration.create();
    private static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility(CONF);
    private static HRegionServer SERVER;
    private static X509TestContextProvider PROVIDER;
    private static NettyEventLoopGroupConfig EVENT_LOOP_GROUP_CONFIG;
    private X509TestContext x509TestContext;
    @Parameterized.Parameter(value=0)
    public X509KeyType keyType;
    @Parameterized.Parameter(value=1)
    public KeyStoreFileType storeFileType;

    @Parameterized.Parameters(name="{index}: keyType={0}, storeFileType={1}")
    public static List<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (KeyStoreFileType ks : KeyStoreFileType.values()) {
                params.add(new Object[]{caKeyType, ks});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        File dir = new File(UTIL.getDataTestDir(TestNettyTLSIPCFileWatcher.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)dir);
        CONF.setBoolean("hbase.server.netty.tls.enabled", true);
        PROVIDER = new X509TestContextProvider(CONF, dir);
        EVENT_LOOP_GROUP_CONFIG = new NettyEventLoopGroupConfig(CONF, TestNettyTLSIPCFileWatcher.class.getSimpleName());
        SERVER = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)SERVER.getEventLoopGroupConfig()).thenReturn((Object)EVENT_LOOP_GROUP_CONFIG);
    }

    @AfterClass
    public static void tearDownAfterClass() throws InterruptedException {
        Security.removeProvider("BC");
        EVENT_LOOP_GROUP_CONFIG.group().shutdownGracefully().sync();
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        this.x509TestContext = PROVIDER.get(this.keyType, this.keyType, "keyPa$$word".toCharArray());
        this.x509TestContext.setConfigurations(this.storeFileType, this.storeFileType);
        CONF.setBoolean("hbase.server.netty.tls.supportplaintext", false);
        CONF.setBoolean("hbase.client.netty.tls.enabled", true);
        CONF.setBoolean("hbase.rpc.tls.certReload", true);
    }

    @After
    public void tearDown() {
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceServerKeystore() throws IOException, ServiceException, GeneralSecurityException, OperatorCreationException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try {
            String message;
            HBaseRpcControllerImpl pcrc;
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;
            rpcServer.start();
            try (NettyRpcClient client = new NettyRpcClient(clientConf);){
                stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)client, rpcServer.getListenerAddress());
                pcrc = new HBaseRpcControllerImpl();
                message = "hello";
                Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
                Assert.assertNull((Object)pcrc.cellScanner());
            }
            this.x509TestContext.regenerateStores(this.keyType, this.keyType, this.storeFileType, this.storeFileType, new String[0]);
            client = new NettyRpcClient(clientConf);
            var4_4 = null;
            try {
                stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)client, rpcServer.getListenerAddress());
                pcrc = new HBaseRpcControllerImpl();
                message = "hello";
                Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
                Assert.assertNull((Object)pcrc.cellScanner());
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var4_4 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceClientAndServerKeystore() throws GeneralSecurityException, IOException, OperatorCreationException, ServiceException {
        Configuration clientConf = new Configuration(CONF);
        RpcServer rpcServer = this.createRpcServer("testRpcServer", Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, (RpcScheduler)new FifoRpcScheduler(CONF, 1));
        try {
            rpcServer.start();
            try (NettyRpcClient client = new NettyRpcClient(clientConf);){
                TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)client, rpcServer.getListenerAddress());
                HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl();
                String message = "hello";
                Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
                Assert.assertNull((Object)pcrc.cellScanner());
                this.x509TestContext.regenerateStores(this.keyType, this.keyType, this.storeFileType, this.storeFileType, new String[0]);
                client.cancelConnections(ServerName.valueOf((Address)Address.fromSocketAddress((InetSocketAddress)rpcServer.getListenerAddress()), (long)0L));
                Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
                Assert.assertNull((Object)pcrc.cellScanner());
            }
        }
        finally {
            rpcServer.stop();
        }
    }

    private RpcServer createRpcServer(String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return new NettyRpcServer((Server)SERVER, name, services, bindAddress, conf, scheduler, true);
    }
}

