/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.security.AbstractTestSecureIPC;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, LargeTests.class})
public class TestSecureIPC
extends AbstractTestSecureIPC {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureIPC.class);
    @Parameterized.Parameter(value=0)
    public String rpcClientImpl;
    @Parameterized.Parameter(value=1)
    public String rpcServerImpl;

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}, rpcServerImpl={1}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        List<String> rpcClientImpls = Arrays.asList(BlockingRpcClient.class.getName(), NettyRpcClient.class.getName());
        List<String> rpcServerImpls = Arrays.asList(SimpleRpcServer.class.getName(), NettyRpcServer.class.getName());
        for (String rpcClientImpl : rpcClientImpls) {
            for (String rpcServerImpl : rpcServerImpls) {
                params.add(new Object[]{rpcClientImpl, rpcServerImpl});
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TestSecureIPC.initKDCAndConf();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestSecureIPC.stopKDC();
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setUpTest() throws Exception {
        this.setUpPrincipalAndConf();
        this.clientConf.set("hbase.rpc.client.impl", this.rpcClientImpl);
        this.serverConf.set("hbase.rpc.server.impl", this.rpcServerImpl);
    }
}

