/*
 * Generated by the Jasper component of Apache Tomcat
 * Version: JspC/ApacheTomcat9
 * Note: The last modified time of this file was set to
 *       the last modified time of the source file after
 *       generation to assist with modification tracking.
 */
package org.apache.hadoop.hbase.generated.master;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import static org.apache.commons.lang3.StringEscapeUtils.escapeXml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.http.MetaBrowser;
import org.apache.hadoop.hbase.master.http.RegionReplicaInfo;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.Quotas;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.SpaceQuota;
import java.net.URLEncoder;
import java.util.stream.Collectors;

public final class table_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent,
                 org.apache.jasper.runtime.JspSourceImports {


  /**
   * @return An empty region load stamped with the passed in <code>regionInfo</code>
   * region name.
   */
  private static RegionMetrics getEmptyRegionMetrics(final RegionInfo regionInfo) {
    return RegionMetricsBuilder.toRegionMetrics(ClusterStatusProtos.RegionLoad.newBuilder().
            setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().
                    setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).
                    setValue(ByteString.copyFrom(regionInfo.getRegionName())).build()).build());
  }

  /**
   * Given dicey information that may or not be available in meta, render a link to the region on
   * its region server.
   * @return an anchor tag if one can be built, {@code null} otherwise.
   */
  private static String buildRegionLink(final ServerName serverName, final int rsInfoPort,
    final RegionInfo regionInfo, final RegionState.State regionState) {
    if (serverName == null || regionInfo == null) { return null; }

    if (regionState != RegionState.State.OPEN) {
      // region is assigned to RS, but RS knows nothing of it. don't bother with a link.
      return serverName.getServerName();
    }

    final String socketAddress = serverName.getHostname() + ":" + rsInfoPort;
    final String URI = "//" + socketAddress + "/region.jsp"
      + "?name=" + regionInfo.getEncodedName();
    return "<a href=\"" + URI + "\">" + serverName.getServerName() + "</a>";
  }

  /**
   * Render an <td> tag contents server name which the given region deploys.
   * Links to the server rs-status page.
   * <td class="undeployed-region">not deployed</td> instead if can not find the deploy message.
   * @return an <td> tag contents server name links to server rs-status page.
   */
  private static String buildRegionDeployedServerTag(RegionInfo regionInfo, HMaster master,
    Map<RegionInfo, ServerName> regionsToServer) {
    ServerName serverName = regionsToServer.get(regionInfo);

    if (serverName == null) {
      return "<td class=\"undeployed-region\">not deployed</td>";
    }

    String hostName = serverName.getHostname();
    String hostNameEncoded = URLEncoder.encode(hostName);
    // This port might be wrong if RS actually ended up using something else.
    int serverInfoPort = master.getRegionServerInfoPort(serverName);
    String urlRegionServer = "//" + hostNameEncoded + ":" + serverInfoPort + "/rs-status";

    return "<td><a href=\"" + urlRegionServer + "\">" + StringEscapeUtils.escapeHtml4(hostName)
      + ":" + serverInfoPort + "</a></td>";
  }

  /**
   * @return an <p> tag guide user to see all region messages.
   */
  private static String moreRegionsToRender(int numRegionsRendered, int numRegions, String fqtn) {
    if (numRegions > numRegionsRendered) {
      String allRegionsUrl = "?name=" + URLEncoder.encode(fqtn) + "&numRegions=all";

      return "This table has <b>" + numRegions
        + "</b> regions in total, in order to improve the page load time, only <b>"
        + numRegionsRendered + "</b> regions are displayed here, <a href=\""
        + allRegionsUrl + "\">click here</a> to see all regions.</p>";
    }
    return "";
  }

  private static final javax.servlet.jsp.JspFactory _jspxFactory =
          javax.servlet.jsp.JspFactory.getDefaultFactory();

  private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;

  private static final java.util.Set<java.lang.String> _jspx_imports_packages;

  private static final java.util.Set<java.lang.String> _jspx_imports_classes;

  static {
    _jspx_imports_packages = new java.util.LinkedHashSet<>(4);
    _jspx_imports_packages.add("javax.servlet");
    _jspx_imports_packages.add("javax.servlet.http");
    _jspx_imports_packages.add("javax.servlet.jsp");
    _jspx_imports_classes = new java.util.LinkedHashSet<>(78);
    _jspx_imports_classes.add("org.apache.hadoop.hbase.RegionMetricsBuilder");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.TableNotFoundException");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.SpaceQuota");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.RegionState");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.NotServingRegionException");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.http.MetaBrowser");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.HTableDescriptor");
    _jspx_imports_classes.add("java.util.Map");
    _jspx_imports_classes.add("org.apache.hadoop.conf.Configuration");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.ThrottleSettings");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.ColumnFamilyDescriptor");
    _jspx_imports_classes.add("org.apache.commons.lang3.StringEscapeUtils");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot");
    _jspx_imports_classes.add("java.util.Collection");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.AsyncAdmin");
    _jspx_imports_classes.add("static org.apache.commons.lang3.StringEscapeUtils.escapeXml");
    _jspx_imports_classes.add("java.util.Set");
    _jspx_imports_classes.add("java.util.stream.Collectors");
    _jspx_imports_classes.add("java.util.List");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.http.RegionReplicaInfo");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.CompactionState");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionLocator");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos");
    _jspx_imports_classes.add("java.util.Optional");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionInfoBuilder");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.HMaster");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.util.FSUtils");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.ServerMetrics");
    _jspx_imports_classes.add("java.util.HashMap");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.TableState");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.RegionStateNode");
    _jspx_imports_classes.add("java.util.ArrayList");
    _jspx_imports_classes.add("java.util.LinkedHashMap");
    _jspx_imports_classes.add("java.util.HashSet");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.AsyncConnection");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.HConstants");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.QuotaTableUtil");
    _jspx_imports_classes.add("org.apache.hadoop.util.StringUtils");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.http.InfoServer");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.ServerName");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.util.Bytes");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.TableName");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.RegionStates");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos.Quotas");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionReplicaUtil");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.ConnectionFactory");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.quotas.QuotaSettingsFactory");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.RegionMetrics");
    _jspx_imports_classes.add("java.util.concurrent.TimeUnit");
    _jspx_imports_classes.add("java.net.URLEncoder");
    _jspx_imports_classes.add("java.util.TreeMap");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.HRegionLocation");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.Size");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.Table");
    _jspx_imports_classes.add("org.apache.hbase.thirdparty.com.google.protobuf.ByteString");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.client.RegionInfo");
  }

  private volatile javax.el.ExpressionFactory _el_expressionfactory;
  private volatile org.apache.tomcat.InstanceManager _jsp_instancemanager;

  public java.util.Map<java.lang.String,java.lang.Long> getDependants() {
    return _jspx_dependants;
  }

  public java.util.Set<java.lang.String> getPackageImports() {
    return _jspx_imports_packages;
  }

  public java.util.Set<java.lang.String> getClassImports() {
    return _jspx_imports_classes;
  }

  public javax.el.ExpressionFactory _jsp_getExpressionFactory() {
    if (_el_expressionfactory == null) {
      synchronized (this) {
        if (_el_expressionfactory == null) {
          _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
        }
      }
    }
    return _el_expressionfactory;
  }

  public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {
    if (_jsp_instancemanager == null) {
      synchronized (this) {
        if (_jsp_instancemanager == null) {
          _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
        }
      }
    }
    return _jsp_instancemanager;
  }

  public void _jspInit() {
  }

  public void _jspDestroy() {
  }

  public void _jspService(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response)
      throws java.io.IOException, javax.servlet.ServletException {

    if (!javax.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {
      final java.lang.String _jspx_method = request.getMethod();
      if ("OPTIONS".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        return;
      }
      if (!"GET".equals(_jspx_method) && !"POST".equals(_jspx_method) && !"HEAD".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
        return;
      }
    }

    final javax.servlet.jsp.PageContext pageContext;
    javax.servlet.http.HttpSession session = null;
    final javax.servlet.ServletContext application;
    final javax.servlet.ServletConfig config;
    javax.servlet.jsp.JspWriter out = null;
    final java.lang.Object page = this;
    javax.servlet.jsp.JspWriter _jspx_out = null;
    javax.servlet.jsp.PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
      out.write('\n');
      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "header.jsp" + "?" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode("pageTitle", request.getCharacterEncoding())+ "=" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${pageTitle}", java.lang.String.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null), request.getCharacterEncoding()), out, false);
      out.write('\n');
      out.write('\n');

  final String ZEROMB = "0 MB";
  HMaster master = (HMaster)getServletContext().getAttribute(HMaster.MASTER);
  Configuration conf = master.getConfiguration();
  String fqtn = request.getParameter("name");
  // handle the case for fqtn is null or master is not initialized with error message + redirect
  if (fqtn == null || !master.isInitialized()) {

      out.write("\n    <div class=\"container-fluid content\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Table not ready</h1>\n        </div>\n      </div>\n      <p><hr><p>\n      ");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "redirect.jsp", out, false);
      out.write("\n    </div>\n");
  return;
  } 
      out.write('\n');
      out.write('\n');

  final String escaped_fqtn = StringEscapeUtils.escapeHtml4(fqtn);
  Table table = master.getConnection().getTable(TableName.valueOf(fqtn));
  boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
  boolean readOnly = !InfoServer.canUserModifyUI(request, getServletContext(), conf);
  int numMetaReplicas =
    master.getTableDescriptors().get(TableName.META_TABLE_NAME).getRegionReplication();
  Map<String, Integer> frags = null;
  if (showFragmentation) {
    frags = FSUtils.getTableFragmentation(master);
  }
  boolean quotasEnabled = conf.getBoolean("hbase.quota.enabled", false);
  String action = request.getParameter("action");
  String key = request.getParameter("key");
  String left = request.getParameter("left");
  String right = request.getParameter("right");
  long totalStoreFileSizeMB = 0;

  final String numRegionsParam = request.getParameter("numRegions");
  // By default, the page render up to 10000 regions to improve the page load time
  int numRegionsToRender = 10000;
  if (numRegionsParam != null) {
    // either 'all' or a number
    if (numRegionsParam.equals("all")) {
      numRegionsToRender = -1;
    } else {
      try {
        numRegionsToRender = Integer.parseInt(numRegionsParam);
      } catch (NumberFormatException ex) {
        // ignore
      }
    }
  }
  int numRegions = 0;

  String pageTitle;
  if ( !readOnly && action != null ) {
    pageTitle = "HBase Master: " + StringEscapeUtils.escapeHtml4(master.getServerName().toString());
  } else {
    pageTitle = "Table: " + escaped_fqtn;
  }
  pageContext.setAttribute("pageTitle", pageTitle);
  final AsyncConnection connection = ConnectionFactory.createAsyncConnection(master.getConfiguration()).get();
  final AsyncAdmin admin = connection.getAdminBuilder()
    .setOperationTimeout(5, TimeUnit.SECONDS)
    .build();
  final MetaBrowser metaBrowser = new MetaBrowser(connection, request);

      out.write('\n');
      out.write('\n');
 // unknow table
  if (! admin.tableExists(TableName.valueOf(fqtn)).get()) { 
      out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table not found</h1>\n    </div>\n  </div>\n  <p><hr><p>\n  ");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "redirect.jsp", out, false);
      out.write("\n</div>\n");
  return;
  } 
      out.write('\n');
      out.write('\n');
 // table split/compact/merge actions
  if ( !readOnly && action != null ) { 
      out.write("\n<div class=\"container-fluid content\">\n  <div class=\"row inner_header\">\n    <div class=\"page-header\">\n      <h1>Table action request accepted</h1>\n    </div>\n  </div>\n  <p><hr><p>\n");
  if (action.equals("split")) {
      if (key != null && key.length() > 0) {
        admin.split(TableName.valueOf(fqtn), Bytes.toBytes(key));
      } else {
        admin.split(TableName.valueOf(fqtn));
      }


      out.write("    Split request accepted. ");

    } else if (action.equals("major compact")) {
      if (key != null && key.length() > 0) {
        List<RegionInfo> regions = admin.getRegions(TableName.valueOf(fqtn)).get();
        byte[] row = Bytes.toBytes(key);
        for (RegionInfo region : regions) {
          if (region.containsRow(row)) {
            admin.majorCompactRegion(region.getRegionName());
          }
        }
      } else {
        admin.majorCompact(TableName.valueOf(fqtn));
      }

      out.write("    major Compact request accepted. ");

    } else if (action.equals("compact")) {
      if (key != null && key.length() > 0) {
        List<RegionInfo> regions = admin.getRegions(TableName.valueOf(fqtn)).get();
        byte[] row = Bytes.toBytes(key);

        for (RegionInfo region : regions) {
          if (region.containsRow(row)) {
            admin.compactRegion(region.getRegionName());
          }
        }
      } else {
        admin.compact(TableName.valueOf(fqtn));
      }

      out.write("    Compact request accepted. ");

    } else if (action.equals("merge")) {
      if (left != null && left.length() > 0 && right != null && right.length() > 0) {
        admin.mergeRegions(Bytes.toBytesBinary(left), Bytes.toBytesBinary(right), false);
      }

      out.write("    Merge request accepted. ");

    } 
      out.write("\n    ");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "redirect.jsp", out, false);
      out.write("\n    </div>\n");
  return;
  } 
      out.write("\n\n<div class=\"container-fluid content\">\n<div class=\"row inner_header\">\n  <div class=\"page-header\">\n    <h1>Table <small>");
      out.print( escaped_fqtn );
      out.write("</small></h1>\n  </div>\n</div>\n<div class=\"row\">\n");
 //Meta table.
  if(fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) { 
      out.write("\n<h2>Table Regions</h2>\n<div class=\"tabbable\">\n  <ul class=\"nav nav-pills\">\n    <li class=\"active\"><a href=\"#metaTab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n    <li class=\"\"><a href=\"#metaTab_localityStats\" data-toggle=\"tab\">Localities</a></li>\n    <li class=\"\"><a href=\"#metaTab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n  </ul>\n\n  <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n    <div class=\"tab-pane active\" id=\"metaTab_baseStats\">\n      <table id=\"metaTableBaseStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name</th>\n            <th>Region Server</th>\n            <th>ReadRequests</th>\n            <th>WriteRequests</th>\n            <th>Uncompressed StoreFileSize</th>\n            <th>StorefileSize</th>\n            <th>Num.Storefiles</th>\n            <th>MemSize</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n          </tr>\n        </thead>\n        <tbody>\n");
      out.write("        ");

          // NOTE: Presumes meta with one or more replicas
          for (int j = 0; j < numMetaReplicas; j++) {
            RegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica(
                    RegionInfoBuilder.FIRST_META_REGIONINFO, j);
            //If a metaLocation is null, All of its info would be empty here to be displayed.
            RegionStateNode rsn = master.getAssignmentManager().getRegionStates()
              .getRegionStateNode(meta);
            ServerName metaLocation = rsn != null ? rsn.getRegionLocation() : null;
            for (int i = 0; i < 1; i++) {
              //If metaLocation is null, default value below would be displayed in UI.
              String hostAndPort = "";
              String readReq = "N/A";
              String writeReq = "N/A";
              String fileSizeUncompressed = ZEROMB;
              String fileSize = ZEROMB;
              String fileCount = "N/A";
              String memSize = ZEROMB;
              if (metaLocation != null) {
                ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                // The host name portion should be safe, but I don't know how we handle IDNs so err on the side of failing safely.
                hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                if (sl != null) {
                  Map<byte[], RegionMetrics> map = sl.getRegionMetrics();
                  if (map.containsKey(meta.getRegionName())) {
                    RegionMetrics load = map.get(meta.getRegionName());
                    readReq = String.format("%,1d", load.getReadRequestCount());
                    writeReq = String.format("%,1d", load.getWriteRequestCount());
                    double rSize = load.getStoreFileSize().get(Size.Unit.BYTE);
                    if (rSize > 0) {
                      fileSize = StringUtils.byteDesc((long) rSize);
                    }
                    double rSizeUncompressed = load.getUncompressedStoreFileSize().get(Size.Unit.BYTE);
                    if (rSizeUncompressed > 0) {
                      fileSizeUncompressed = StringUtils.byteDesc((long) rSizeUncompressed);
                    }
                    fileCount = String.format("%,1d", load.getStoreFileCount());
                    double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
                    if (mSize > 0) {
                      memSize = StringUtils.byteDesc((long)mSize);
                    }
                  }
                }
              }
            
      out.write("\n          <tr>\n            <td>");
      out.print( escapeXml(meta.getRegionNameAsString()) );
      out.write("</td>\n            <td><a href=\"http://");
      out.print( hostAndPort );
      out.write("/rs-status\">");
      out.print( StringEscapeUtils.escapeHtml4(hostAndPort) );
      out.write("</a></td>\n            <td>");
      out.print( readReq);
      out.write("</td>\n            <td>");
      out.print( writeReq);
      out.write("</td>\n            <td>");
      out.print( fileSizeUncompressed);
      out.write("</td>\n            <td>");
      out.print( fileSize);
      out.write("</td>\n            <td>");
      out.print( fileCount);
      out.write("</td>\n            <td>");
      out.print( memSize);
      out.write("</td>\n            <td>");
      out.print( escapeXml(Bytes.toString(meta.getStartKey())) );
      out.write("</td>\n            <td>");
      out.print( escapeXml(Bytes.toString(meta.getEndKey())) );
      out.write("</td>\n            <td>");
      out.print( meta.getReplicaId() );
      out.write("</td>\n          </tr>\n        ");
  } 
      out.write("\n        ");
} 
      out.write("\n        </tbody>\n      </table>\n    </div>\n    <div class=\"tab-pane\" id=\"metaTab_localityStats\">\n       <table id=\"metaTableLocalityStatsTable\" class=\"tablesorter table table-striped\">\n         <thead>\n           <tr>\n             <th>Name</th>\n             <th>Region Server</th>\n             <th>Locality</th>\n             <th>LocalityForSsd</th>\n           </tr>\n         </thead>\n         <tbody>\n         ");

           // NOTE: Presumes meta with one or more replicas
           for (int j = 0; j < numMetaReplicas; j++) {
             RegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica(
                                     RegionInfoBuilder.FIRST_META_REGIONINFO, j);
             //If a metaLocation is null, All of its info would be empty here to be displayed.
             RegionStateNode rsn = master.getAssignmentManager().getRegionStates()
               .getRegionStateNode(meta);
             ServerName metaLocation = rsn != null ? rsn.getRegionLocation() : null;
             for (int i = 0; i < 1; i++) {
               //If metaLocation is null, default value below would be displayed in UI.
               String hostAndPort = "";
               float locality = 0.0f;
               float localityForSsd = 0.0f;
               if (metaLocation != null) {
                 ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                 hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                 if (sl != null) {
                   Map<byte[], RegionMetrics> map = sl.getRegionMetrics();
                   if (map.containsKey(meta.getRegionName())) {
                     RegionMetrics load = map.get(meta.getRegionName());
                     locality = load.getDataLocality();
                     localityForSsd = load.getDataLocalityForSsd();
                   }
                 }
               }
             
      out.write("\n           <tr>\n             <td>");
      out.print( escapeXml(meta.getRegionNameAsString()) );
      out.write("</td>\n             <td><a href=\"http://");
      out.print( hostAndPort );
      out.write("/rs-status\">");
      out.print( StringEscapeUtils.escapeHtml4(hostAndPort) );
      out.write("</a></td>\n             <td>");
      out.print( locality);
      out.write("</td>\n             <td>");
      out.print( localityForSsd);
      out.write("</td>\n           </tr>\n         ");
  } 
      out.write("\n         ");
} 
      out.write("\n         </tbody>\n       </table>\n     </div>\n    <div class=\"tab-pane\" id=\"metaTab_compactStats\">\n      <table id=\"metaTableCompactStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name</th>\n            <th>Region Server</th>\n            <th>Num. Compacting Cells</th>\n            <th>Num. Compacted Cells</th>\n            <th>Remaining Cells</th>\n            <th>Compaction Progress</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");

          // NOTE: Presumes meta with one or more replicas
          for (int j = 0; j < numMetaReplicas; j++) {
            RegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica(
                        RegionInfoBuilder.FIRST_META_REGIONINFO, j);
            //If a metaLocation is null, All of its info would be empty here to be displayed.
            RegionStateNode rsn = master.getAssignmentManager().getRegionStates()
              .getRegionStateNode(meta);
            ServerName metaLocation = rsn != null ? rsn.getRegionLocation() : null;
            for (int i = 0; i < 1; i++) {
              //If metaLocation is null, default value below would be displayed in UI.
              String hostAndPort = "";
              long compactingCells = 0;
              long compactedCells = 0;
              String compactionProgress = "";
              if (metaLocation != null) {
                ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                if (sl != null) {
                  Map<byte[], RegionMetrics> map = sl.getRegionMetrics();
                  if (map.containsKey(meta.getRegionName())) {
                    RegionMetrics load = map.get(meta.getRegionName());
                    compactingCells = load.getCompactingCellCount();
                    compactedCells = load.getCompactedCellCount();
                    if (compactingCells > 0) {
                      compactionProgress = String.format("%.2f", 100 * ((float)
                              compactedCells / compactingCells)) + "%";
                    }
                  }
                }
              }
        
      out.write("\n          <tr>\n            <td>");
      out.print( escapeXml(meta.getRegionNameAsString()) );
      out.write("</td>\n            <td><a href=\"http://");
      out.print( hostAndPort );
      out.write("/rs-status\">");
      out.print( StringEscapeUtils.escapeHtml4(hostAndPort) );
      out.write("</a></td>\n            <td>");
      out.print( String.format("%,1d", compactingCells));
      out.write("</td>\n            <td>");
      out.print( String.format("%,1d", compactedCells));
      out.write("</td>\n            <td>");
      out.print( String.format("%,1d", compactingCells - compactedCells));
      out.write("</td>\n            <td>");
      out.print( compactionProgress);
      out.write("</td>\n          </tr>\n        ");
  } 
      out.write("\n        ");
} 
      out.write("\n        </tbody>\n      </table>\n    </div>\n  </div>\n</div>\n<h2 id=\"meta-entries\">Meta Entries</h2>\n");

  if (!metaBrowser.getErrorMessages().isEmpty()) {
    for (final String errorMessage : metaBrowser.getErrorMessages()) {

      out.write("\n    <div class=\"alert alert-warning\" role=\"alert\">\n      ");
      out.print( errorMessage );
      out.write("\n    </div>\n");

    }
  }

  String regionInfoColumnName = HConstants.CATALOG_FAMILY_STR + ":" + HConstants.REGIONINFO_QUALIFIER_STR;
  String serverColumnName = HConstants.CATALOG_FAMILY_STR + ":" + HConstants.SERVER_QUALIFIER_STR;
  String startCodeColumnName = HConstants.CATALOG_FAMILY_STR + ":" + HConstants.STARTCODE_QUALIFIER_STR;
  String serverNameColumnName = HConstants.CATALOG_FAMILY_STR + ":" + HConstants.SERVERNAME_QUALIFIER_STR;
  String seqNumColumnName = HConstants.CATALOG_FAMILY_STR + ":" + HConstants.SEQNUM_QUALIFIER_STR;

      out.write("\n    <div style=\"overflow-x: auto\">\n      <table class=\"table table-striped nowrap\">\n        <tr>\n          <th title=\"Region name, stored in ");
      out.print( regionInfoColumnName );
      out.write(" column\">RegionName</th>\n          <th title=\"The startKey of this region\">Start Key</th>\n          <th title=\"The endKey of this region\">End Key</th>\n          <th title=\"Region replica id\">Replica ID</th>\n          <th title=\"State of the region while undergoing transitions\">RegionState</th>\n          <th title=\"Server hosting this region replica, stored in ");
      out.print( serverColumnName );
      out.write(" column\">Server</th>\n          <th title=\"The seqNum for the region at the time the server opened this region replica, stored in ");
      out.print( seqNumColumnName );
      out.write("\">Sequence Number</th>\n          <th title=\"The server to which the region is transiting, stored in ");
      out.print( serverNameColumnName );
      out.write(" column\">Target Server</th>\n          <th title=\"The parents regions if this region is undergoing a merge\">info:merge*</th>\n          <th title=\"The daughter regions if this region is split\">info:split*</th>\n        </tr>\n");

  final boolean metaScanHasMore;
  byte[] lastRow = null;
  try (final MetaBrowser.Results results = metaBrowser.getResults()) {
    for (final RegionReplicaInfo regionReplicaInfo : results) {
      lastRow = Optional.ofNullable(regionReplicaInfo)
        .map(RegionReplicaInfo::getRow)
        .orElse(null);
      if (regionReplicaInfo == null) {

      out.write("\n        <tr>\n          <td colspan=\"6\">Null result</td>\n        </tr>\n");

        continue;
      }

      final String regionNameDisplay = regionReplicaInfo.getRegionName() != null
        ? Bytes.toStringBinary(regionReplicaInfo.getRegionName())
        : "";
      final String startKeyDisplay = regionReplicaInfo.getStartKey() != null
        ? Bytes.toStringBinary(regionReplicaInfo.getStartKey())
        : "";
      final String endKeyDisplay = regionReplicaInfo.getEndKey() != null
        ? Bytes.toStringBinary(regionReplicaInfo.getEndKey())
        : "";
      final String replicaIdDisplay = regionReplicaInfo.getReplicaId() != null
        ? regionReplicaInfo.getReplicaId().toString()
        : "";
      final String regionStateDisplay = regionReplicaInfo.getRegionState() != null
        ? regionReplicaInfo.getRegionState().toString()
        : "";

      final RegionInfo regionInfo = regionReplicaInfo.getRegionInfo();
      final ServerName serverName = regionReplicaInfo.getServerName();
      final RegionState.State regionState = regionReplicaInfo.getRegionState();

      final long seqNum = regionReplicaInfo.getSeqNum();

      final String regionSpanFormat = "<span title=" + HConstants.CATALOG_FAMILY_STR + ":%s>%s</span>";
      final String targetServerName = regionReplicaInfo.getTargetServerName() != null
        ? regionReplicaInfo.getTargetServerName().toString()
        : "";
      final Map<String, RegionInfo> mergeRegions = regionReplicaInfo.getMergeRegionInfo();
      final String mergeRegionNames = (mergeRegions == null) ? "" :
        mergeRegions.entrySet().stream()
          .map(entry -> String.format(regionSpanFormat, entry.getKey(), entry.getValue().getRegionNameAsString()))
          .collect(Collectors.joining("<br/>"));
      final Map<String, RegionInfo> splitRegions = regionReplicaInfo.getSplitRegionInfo();
      final String splitName = (splitRegions == null) ? "" :
        splitRegions.entrySet().stream()
          .map(entry -> String.format(regionSpanFormat, entry.getKey(), entry.getValue().getRegionNameAsString()))
          .collect(Collectors.joining("<br/>"));
  
      out.write("\n    <tr>\n      <td title=\"");
      out.print( regionInfoColumnName );
      out.write('"');
      out.write('>');
      out.print( regionNameDisplay );
      out.write("</td>\n      <td title=\"startKey\">");
      out.print( startKeyDisplay );
      out.write("</td>\n      <td title=\"endKey\">");
      out.print( endKeyDisplay );
      out.write("</td>\n      <td title=\"replicaId\">");
      out.print( replicaIdDisplay );
      out.write("</td>\n      <td title=\"regionState\">");
      out.print( regionStateDisplay );
      out.write("</td>\n      <td title=\"");
      out.print( serverColumnName + "," + startCodeColumnName );
      out.write('"');
      out.write('>');
      out.print( buildRegionLink(serverName, master.getRegionServerInfoPort(serverName), regionInfo, regionState) );
      out.write("</td>\n      <td title=\"");
      out.print( seqNumColumnName );
      out.write('"');
      out.write('>');
      out.print( seqNum );
      out.write("</td>\n      <td title=\"");
      out.print( serverNameColumnName );
      out.write('"');
      out.write('>');
      out.print( targetServerName );
      out.write("</td>\n      <td>");
      out.print( mergeRegionNames );
      out.write("</td>\n      <td>");
      out.print( splitName );
      out.write("</td>\n    </tr>\n  ");

    }

    metaScanHasMore = results.hasMoreResults();
  }

      out.write("\n      </table>\n    </div>\n    <div class=\"row\">\n      <div class=\"col-md-4\">\n        <ul class=\"pagination\" style=\"margin: 20px 0\">\n          <li>\n            <a href=\"");
      out.print( metaBrowser.buildFirstPageUrl() );
      out.write("\" aria-label=\"Previous\">\n              <span aria-hidden=\"true\">&#x21E4;</span>\n            </a>\n          </li>\n          <li");
      out.print( metaScanHasMore ? "" : " class=\"disabled\"" );
      out.write(">\n            <a");
      out.print( metaScanHasMore ? " href=\"" + metaBrowser.buildNextPageUrl(lastRow) + "\"" : "" );
      out.write(" aria-label=\"Next\">\n              <span aria-hidden=\"true\">&raquo;</span>\n            </a>\n          </li>\n        </ul>\n      </div>\n      <div class=\"col-md-8\">\n        <form action=\"/table.jsp\" method=\"get\" class=\"form-inline pull-right\" style=\"margin: 20px 0\">\n          <input type=\"hidden\" name=\"name\" value=\"");
      out.print( TableName.META_TABLE_NAME );
      out.write("\" />\n          <div class=\"form-group\">\n            <label for=\"scan-limit\">Scan Limit</label>\n            <input type=\"text\" id=\"scan-limit\" name=\"");
      out.print( MetaBrowser.SCAN_LIMIT_PARAM );
      out.write("\"\n                              class=\"form-control\" placeholder=\"");
      out.print( MetaBrowser.SCAN_LIMIT_DEFAULT );
      out.write("\"\n                              ");
      out.print( metaBrowser.getScanLimit() != null
                ? "value=\"" + metaBrowser.getScanLimit() + "\""
                : ""
              );
      out.write("\n                              aria-describedby=\"scan-limit\" style=\"display:inline; width:auto\" />\n            <label for=\"table-name-filter\">Table</label>\n            <input type=\"text\" id=\"table-name-filter\" name=\"");
      out.print( MetaBrowser.SCAN_TABLE_PARAM );
      out.write("\"\n                              ");
      out.print( metaBrowser.getScanTable() != null
                ? "value=\"" + metaBrowser.getScanTable() + "\""
                : ""
              );
      out.write("\n                              aria-describedby=\"scan-filter-table\" style=\"display:inline; width:auto\" />\n            <label for=\"region-state-filter\">Region State</label>\n            <select class=\"form-control\" id=\"region-state-filter\" style=\"display:inline; width:auto\"\n                               name=\"");
      out.print( MetaBrowser.SCAN_REGION_STATE_PARAM );
      out.write("\">\n              <option></option>\n");

  for (final RegionState.State state : RegionState.State.values()) {
    final boolean selected = metaBrowser.getScanRegionState() == state;

      out.write("\n              <option");
      out.print( selected ? " selected" : "" );
      out.write('>');
      out.print( state );
      out.write("</option>\n");

  }

      out.write("\n        </select>\n        <button type=\"submit\" class=\"btn btn-primary\" style=\"display:inline; width:auto\">\n          Filter Results\n        </button>\n      </div>\n    </form>\n  </div>\n</div>\n");
} else {
  //Common tables
  RegionStates states = master.getAssignmentManager().getRegionStates();
  Map<RegionState.State, List<RegionInfo>> regionStates = states.getRegionByStateOfTable(table.getName());
  Map<String, RegionState.State> stateMap = new HashMap<>();
  for (RegionState.State regionState : regionStates.keySet()) {
    for (RegionInfo regionInfo : regionStates.get(regionState)) {
      stateMap.put(regionInfo.getEncodedName(), regionState);
    }
  }
  RegionLocator r = master.getConnection().getRegionLocator(table.getName());

  try {

      out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
      out.print( master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED) );
      out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");

  if (master.getTableStateManager().isTableState(table.getName(), TableState.State.ENABLED)) {
    CompactionState compactionState = master.getCompactionState(table.getName());
    
      out.print( compactionState==null?"UNKNOWN":compactionState );

  } else {
  
      out.print( CompactionState.NONE );

  }

      out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
  if (showFragmentation) { 
      out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
      out.print( frags.get(fqtn) != null ? frags.get(fqtn).intValue() + "%" : "n/a" );
      out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
  } 
      out.write('\n');

  if (quotasEnabled) {
    TableName tn = TableName.valueOf(fqtn);
    SpaceQuotaSnapshot masterSnapshot = null;
    Quotas quota = QuotaTableUtil.getTableQuota(master.getConnection(), tn);
    if (quota == null || !quota.hasSpace()) {
      quota = QuotaTableUtil.getNamespaceQuota(master.getConnection(), tn.getNamespaceAsString());
      if (quota != null) {
        masterSnapshot = master.getQuotaObserverChore().getNamespaceQuotaSnapshots()
          .get(tn.getNamespaceAsString());
      }
    } else {
      masterSnapshot = master.getQuotaObserverChore().getTableQuotaSnapshots().get(tn);
    }
    if (quota != null && quota.hasSpace()) {
      SpaceQuota spaceQuota = quota.getSpace();

      out.write("\n  <tr>\n    <td>Space Quota</td>\n    <td>\n      <table>\n        <tr>\n          <th>Property</th>\n          <th>Value</th>\n        </tr>\n        <tr>\n          <td>Limit</td>\n          <td>");
      out.print( StringUtils.byteDesc(spaceQuota.getSoftLimit()) );
      out.write("</td>\n        </tr>\n        <tr>\n          <td>Policy</td>\n          <td>");
      out.print( spaceQuota.getViolationPolicy() );
      out.write("</td>\n        </tr>\n");

      if (masterSnapshot != null) {

      out.write("\n        <tr>\n          <td>Usage</td>\n          <td>");
      out.print( StringUtils.byteDesc(masterSnapshot.getUsage()) );
      out.write("</td>\n        </tr>\n        <tr>\n          <td>State</td>\n          <td>");
      out.print( masterSnapshot.getQuotaStatus().isInViolation() ? "In Violation" : "In Observance" );
      out.write("</td>\n        </tr>\n");

      }

      out.write("\n      </table>\n    </td>\n    <td>Information about a Space Quota on this table, if set.</td>\n  </tr>\n");

    }
  if (quota != null && quota.hasThrottle()) {
    List<ThrottleSettings> throttles = QuotaSettingsFactory.fromTableThrottles(table.getName(), quota.getThrottle());
    if (throttles.size() > 0) {

      out.write("\n  <tr>\n    <td>Throttle Quota</td>\n    <td>\n      <table>\n        <tr>\n          <th>Limit</th>\n          <th>Type</th>\n          <th>TimeUnit</th>\n          <th>Scope</th>\n        </tr>\n");

    for (ThrottleSettings throttle : throttles) {

      out.write("\n        <tr>\n          <td>");
      out.print( throttle.getSoftLimit() );
      out.write("</td>\n          <td>");
      out.print( throttle.getThrottleType() );
      out.write("</td>\n          <td>");
      out.print( throttle.getTimeUnit() );
      out.write("</td>\n          <td>");
      out.print( throttle.getQuotaScope() );
      out.write("</td>\n        </tr>\n");

    }

      out.write("\n      </table>\n    </td>\n    <td>Information about a Throttle Quota on this table, if set.</td>\n  </tr>\n");

    }
   }
 }

      out.write("\n</table>\n<h2>Table Schema</h2>\n<table class=\"table table-striped\">\n");

ColumnFamilyDescriptor[] families = table.getDescriptor().getColumnFamilies();
Set<Bytes> familyKeySet = new HashSet<>();
for (ColumnFamilyDescriptor family: families) {
  familyKeySet.addAll(family.getValues().keySet());
}

      out.write("\n<tr>\n  <th>Property \\ Column Family Name</th>\n  ");

  for (ColumnFamilyDescriptor family: families) {
  
      out.write("\n  <th>\n    ");
      out.print( StringEscapeUtils.escapeHtml4(family.getNameAsString()) );
      out.write("\n  </th>\n  ");
 } 
      out.write("\n</tr>\n  ");

  for (Bytes familyKey: familyKeySet) {
  
      out.write("\n    <tr>\n      <td>\n        ");
      out.print( StringEscapeUtils.escapeHtml4(familyKey.toString()) );
      out.write("\n      </td>\n      ");

      for (ColumnFamilyDescriptor family: families) {
        String familyValue = "-";
        if(family.getValues().containsKey(familyKey)){
          familyValue = family.getValues().get(familyKey).toString();
        }
      
      out.write("\n      <td>\n        ");
      out.print( StringEscapeUtils.escapeHtml4(familyValue) );
      out.write("\n      </td>\n      ");
 } 
      out.write("\n    </tr>\n  ");
 } 
      out.write("\n</table>\n");

  long totalReadReq = 0;
  long totalWriteReq = 0;
  long totalSizeUncompressed = 0;
  long totalSize = 0;
  long totalStoreFileCount = 0;
  long totalMemSize = 0;
  long totalCompactingCells = 0;
  long totalCompactedCells = 0;
  long totalBlocksTotalWeight = 0;
  long totalBlocksLocalWeight = 0;
  long totalBlocksLocalWithSsdWeight = 0;
  String totalCompactionProgress = "";
  String totalMemSizeStr = ZEROMB;
  String totalSizeUncompressedStr = ZEROMB;
  String totalSizeStr = ZEROMB;
  String totalLocality = "";
  String totalLocalityForSsd = "";
  String urlRegionServer = null;
  Map<ServerName, Integer> regDistribution = new TreeMap<>();
  Map<ServerName, Integer> primaryRegDistribution = new TreeMap<>();
  List<HRegionLocation> regions = r.getAllRegionLocations();
  Map<RegionInfo, RegionMetrics> regionsToLoad = new LinkedHashMap<>();
  Map<RegionInfo, ServerName> regionsToServer = new LinkedHashMap<>();
  for (HRegionLocation hriEntry : regions) {
    RegionInfo regionInfo = hriEntry.getRegionInfo();
    ServerName addr = hriEntry.getServerName();
    regionsToServer.put(regionInfo, addr);

    if (addr != null) {
      ServerMetrics sl = master.getServerManager().getLoad(addr);
      if (sl != null) {
        RegionMetrics regionMetrics = sl.getRegionMetrics().get(regionInfo.getRegionName());
        regionsToLoad.put(regionInfo, regionMetrics);
        if (regionMetrics != null) {
          totalReadReq += regionMetrics.getReadRequestCount();
          totalWriteReq += regionMetrics.getWriteRequestCount();
          totalSizeUncompressed += regionMetrics.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
          totalSize += regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE);
          totalStoreFileCount += regionMetrics.getStoreFileCount();
          totalMemSize += regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE);
          totalStoreFileSizeMB += regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE);
          totalCompactingCells += regionMetrics.getCompactingCellCount();
          totalCompactedCells += regionMetrics.getCompactedCellCount();
          totalBlocksTotalWeight += regionMetrics.getBlocksTotalWeight();
          totalBlocksLocalWeight += regionMetrics.getBlocksLocalWeight();
          totalBlocksLocalWithSsdWeight += regionMetrics.getBlocksLocalWithSsdWeight();
        } else {
          RegionMetrics load0 = getEmptyRegionMetrics(regionInfo);
          regionsToLoad.put(regionInfo, load0);
        }
      } else{
        RegionMetrics load0 = getEmptyRegionMetrics(regionInfo);
        regionsToLoad.put(regionInfo, load0);
      }
    } else {
      RegionMetrics load0 = getEmptyRegionMetrics(regionInfo);
      regionsToLoad.put(regionInfo, load0);
    }
  }
  if (totalSize > 0) {
    totalSizeStr = StringUtils.byteDesc(totalSize*1024l*1024);
  }
  if (totalSizeUncompressed > 0){
    totalSizeUncompressedStr = StringUtils.byteDesc(totalSizeUncompressed*1024l*1024);
  }
  if (totalMemSize > 0) {
    totalMemSizeStr = StringUtils.byteDesc(totalMemSize*1024l*1024);
  }
  if (totalCompactingCells > 0) {
    totalCompactionProgress = String.format("%.2f", 100 *
            ((float) totalCompactedCells / totalCompactingCells)) + "%";
  }
  if (totalBlocksTotalWeight > 0) {
    totalLocality = String.format("%.1f",
      ((float) totalBlocksLocalWeight / totalBlocksTotalWeight));
    totalLocalityForSsd = String.format("%.1f",
      ((float) totalBlocksLocalWithSsdWeight / totalBlocksTotalWeight));
  }
  if(regions != null && regions.size() > 0) { 
      out.write("\n<h2>Table Regions</h2>\n<div class=\"tabbable\">\n  <ul class=\"nav nav-pills\">\n    <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n    <li class=\"\"><a href=\"#tab_localityStats\" data-toggle=\"tab\">Localities</a></li>\n    <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n  </ul>\n  <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n    <div class=\"tab-pane active\" id=\"tab_baseStats\">\n      <table id=\"tableBaseStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name(");
      out.print( String.format("%,1d", regions.size()));
      out.write(")</th>\n            <th>Region Server</th>\n            <th>ReadRequests<br>(");
      out.print( String.format("%,1d", totalReadReq));
      out.write(")</th>\n            <th>WriteRequests<br>(");
      out.print( String.format("%,1d", totalWriteReq));
      out.write(")</th>\n            <th>Uncompressed StoreFileSize<br>(");
      out.print( totalSizeUncompressedStr );
      out.write(")</th>\n            <th>StorefileSize<br>(");
      out.print( totalSizeStr );
      out.write(")</th>\n            <th>Num.Storefiles<br>(");
      out.print( String.format("%,1d", totalStoreFileCount));
      out.write(")</th>\n            <th>MemSize<br>(");
      out.print( totalMemSizeStr );
      out.write(")</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>Region State</th>\n            <th>ReplicaID</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");

          List<Map.Entry<RegionInfo, RegionMetrics>> entryList = new ArrayList<>(regionsToLoad.entrySet());
          numRegions = regions.size();
          int numRegionsRendered = 0;
          // render all regions
          if (numRegionsToRender < 0) {
            numRegionsToRender = numRegions;
          }
          for (Map.Entry<RegionInfo, RegionMetrics> hriEntry : entryList) {
            RegionInfo regionInfo = hriEntry.getKey();
            ServerName addr = regionsToServer.get(regionInfo);
            RegionMetrics load = hriEntry.getValue();
            String readReq = "N/A";
            String writeReq = "N/A";
            String regionSizeUncompressed = ZEROMB;
            String regionSize = ZEROMB;
            String fileCount = "N/A";
            String memSize = ZEROMB;
            String state = "N/A";
            if (load != null) {
              readReq = String.format("%,1d", load.getReadRequestCount());
              writeReq = String.format("%,1d", load.getWriteRequestCount());
              double rSize = load.getStoreFileSize().get(Size.Unit.BYTE);
              if (rSize > 0) {
                regionSize = StringUtils.byteDesc((long)rSize);
              }
              double rSizeUncompressed = load.getUncompressedStoreFileSize().get(Size.Unit.BYTE);
              if (rSizeUncompressed > 0) {
                regionSizeUncompressed = StringUtils.byteDesc((long)rSizeUncompressed);
              }
              fileCount = String.format("%,1d", load.getStoreFileCount());
              double mSize = load.getMemStoreSize().get(Size.Unit.BYTE);
              if (mSize > 0) {
                memSize = StringUtils.byteDesc((long)mSize);
              }
            }

            if (stateMap.containsKey(regionInfo.getEncodedName())) {
              state = stateMap.get(regionInfo.getEncodedName()).toString();
            }

            if (addr != null) {
              ServerMetrics sl = master.getServerManager().getLoad(addr);
              if(sl != null) {
                Integer i = regDistribution.get(addr);
                if (null == i) i = Integer.valueOf(0);
                regDistribution.put(addr, i + 1);
                if (RegionReplicaUtil.isDefaultReplica(regionInfo.getReplicaId())) {
                  i = primaryRegDistribution.get(addr);
                  if (null == i) i = Integer.valueOf(0);
                  primaryRegDistribution.put(addr, i+1);
                }
              }
            }
            if (numRegionsRendered < numRegionsToRender) {
              numRegionsRendered++;
        
      out.write("\n        <tr>\n          <td>");
      out.print( escapeXml(Bytes.toStringBinary(regionInfo.getRegionName())) );
      out.write("</td>\n          ");
      out.print( buildRegionDeployedServerTag(regionInfo, master, regionsToServer) );
      out.write("\n          <td>");
      out.print( readReq);
      out.write("</td>\n          <td>");
      out.print( writeReq);
      out.write("</td>\n          <td>");
      out.print( regionSizeUncompressed);
      out.write("</td>\n          <td>");
      out.print( regionSize);
      out.write("</td>\n          <td>");
      out.print( fileCount);
      out.write("</td>\n          <td>");
      out.print( memSize);
      out.write("</td>\n          <td>");
      out.print( escapeXml(Bytes.toStringBinary(regionInfo.getStartKey())));
      out.write("</td>\n          <td>");
      out.print( escapeXml(Bytes.toStringBinary(regionInfo.getEndKey())));
      out.write("</td>\n          <td>");
      out.print( state);
      out.write("</td>\n          <td>");
      out.print( regionInfo.getReplicaId() );
      out.write("</td>\n        </tr>\n        ");
 } 
      out.write("\n        ");
 } 
      out.write("\n        </tbody>\n      </table>\n      ");
      out.print( moreRegionsToRender(numRegionsRendered, numRegions, fqtn) );
      out.write("\n    </div>\n    <div class=\"tab-pane\" id=\"tab_localityStats\">\n      <table id=\"tableLocalityStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name(");
      out.print( String.format("%,1d", regions.size()));
      out.write(")</th>\n            <th>Region Server</th>\n            <th>Locality<br>(");
      out.print( totalLocality );
      out.write(")</th>\n            <th>LocalityForSsd<br>(");
      out.print( totalLocalityForSsd );
      out.write(")</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");

          numRegionsRendered = 0;
          for (Map.Entry<RegionInfo, RegionMetrics> hriEntry : entryList) {
            RegionInfo regionInfo = hriEntry.getKey();
            ServerName addr = regionsToServer.get(regionInfo);
            RegionMetrics load = hriEntry.getValue();
            float locality = 0.0f;
            float localityForSsd = 0.0f;
            String state = "N/A";
            if (load != null) {
              locality = load.getDataLocality();
              localityForSsd = load.getDataLocalityForSsd();
            }

            if (numRegionsRendered < numRegionsToRender) {
              numRegionsRendered++;
        
      out.write("\n        <tr>\n          <td>");
      out.print( escapeXml(Bytes.toStringBinary(regionInfo.getRegionName())) );
      out.write("</td>\n          ");
      out.print( buildRegionDeployedServerTag(regionInfo, master, regionsToServer) );
      out.write("\n          <td>");
      out.print( locality);
      out.write("</td>\n          <td>");
      out.print( localityForSsd);
      out.write("</td>\n        </tr>\n        ");
 } 
      out.write("\n        ");
 } 
      out.write("\n        </tbody>\n      </table>\n      ");
      out.print( moreRegionsToRender(numRegionsRendered, numRegions, fqtn) );
      out.write("\n    </div>\n    <div class=\"tab-pane\" id=\"tab_compactStats\">\n      <table id=\"tableCompactStatsTable\" class=\"tablesorter table table-striped\">\n        <thead>\n          <tr>\n            <th>Name(");
      out.print( String.format("%,1d", regions.size()));
      out.write(")</th>\n            <th>Region Server</th>\n            <th>Num. Compacting Cells<br>(");
      out.print( String.format("%,1d", totalCompactingCells));
      out.write(")</th>\n            <th>Num. Compacted Cells<br>(");
      out.print( String.format("%,1d", totalCompactedCells));
      out.write(")</th>\n            <th>Remaining Cells<br>(");
      out.print( String.format("%,1d", totalCompactingCells-totalCompactedCells));
      out.write(")</th>\n            <th>Compaction Progress<br>(");
      out.print( totalCompactionProgress );
      out.write(")</th>\n          </tr>\n        </thead>\n        <tbody>\n        ");

          numRegionsRendered = 0;
          for (Map.Entry<RegionInfo, RegionMetrics> hriEntry : entryList) {
            RegionInfo regionInfo = hriEntry.getKey();
            ServerName addr = regionsToServer.get(regionInfo);
            RegionMetrics load = hriEntry.getValue();
            long compactingCells = 0;
            long compactedCells = 0;
            String compactionProgress = "";
            if (load != null) {
              compactingCells = load.getCompactingCellCount();
              compactedCells = load.getCompactedCellCount();
              if (compactingCells > 0) {
                compactionProgress = String.format("%.2f", 100 * ((float)
                        compactedCells / compactingCells)) + "%";
              }
            }

            if (numRegionsRendered < numRegionsToRender) {
              numRegionsRendered++;
        
      out.write("\n        <tr>\n          <td>");
      out.print( escapeXml(Bytes.toStringBinary(regionInfo.getRegionName())) );
      out.write("</td>\n          ");
      out.print( buildRegionDeployedServerTag(regionInfo, master, regionsToServer) );
      out.write("\n          <td>");
      out.print( String.format("%,1d", compactingCells));
      out.write("</td>\n          <td>");
      out.print( String.format("%,1d", compactedCells));
      out.write("</td>\n          <td>");
      out.print( String.format("%,1d", compactingCells - compactedCells));
      out.write("</td>\n          <td>");
      out.print( compactionProgress);
      out.write("</td>\n        </tr>\n        ");
 } 
      out.write("\n        ");
 } 
      out.write("\n        </tbody>\n      </table>\n      ");
      out.print( moreRegionsToRender(numRegionsRendered, numRegions, fqtn) );
      out.write("\n    </div>\n  </div>\n</div>\n\n<h2>Regions by Region Server</h2>\n<table id=\"regionServerTable\" class=\"tablesorter table table-striped\">\n  <thead>\n    <tr>\n      <th>Region Server</th><th>Region Count</th><th>Primary Region Count</th>\n    </tr>\n  </thead>\n\n  <tbody>\n  ");

    for (Map.Entry<ServerName, Integer> rdEntry : regDistribution.entrySet()) {
      ServerName addr = rdEntry.getKey();
      String url = "//" + URLEncoder.encode(addr.getHostname()) + ":"
        + master.getRegionServerInfoPort(addr) + "/rs-status";
  
      out.write("\n      <tr>\n        <td><a href=\"");
      out.print( url );
      out.write('"');
      out.write('>');
      out.print( StringEscapeUtils.escapeHtml4(addr.getHostname().toString())
          + ":" + master.getRegionServerInfoPort(addr) );
      out.write("</a></td>\n        <td>");
      out.print( rdEntry.getValue());
      out.write("</td>\n        <td>");
      out.print( primaryRegDistribution.get(addr) == null ? 0 : primaryRegDistribution.get(addr));
      out.write("</td>\n      </tr>\n  ");
 } 
      out.write("\n  </tbody>\n</table>\n\n");
 }
} catch(Exception ex) { 
      out.write("\n  Unknown Issue with Regions\n  <div onclick=\"document.getElementById('closeStackTrace').style.display='block';document.getElementById('openStackTrace').style.display='none';\">\n    <a id=\"openStackTrace\" style=\"cursor:pointer;\"> Show StackTrace</a>\n  </div>\n  <div id=\"closeStackTrace\" style=\"display:none;clear:both;\">\n    <div onclick=\"document.getElementById('closeStackTrace').style.display='none';document.getElementById('openStackTrace').style.display='block';\">\n      <a style=\"cursor:pointer;\"> Close StackTrace</a>\n    </div>\n  ");

  for(StackTraceElement element : ex.getStackTrace()) {
    
      out.print( StringEscapeUtils.escapeHtml4(element.toString() + "\n") );

  }
} finally {
  connection.close();
}
} // end else

      out.write("\n\n      <h2>Table Stats</h2>\n      <table class=\"table table-striped\">\n        <tr>\n          <th>Name</th>\n          <th>Value</th>\n          <th>Description</th>\n        </tr>\n        <tr>\n          <td>Size</td>\n          <td>\n            ");

              if (totalStoreFileSizeMB > 0) {
            
      out.write("\n            ");
      out.print( StringUtils.TraditionalBinaryPrefix.
                    long2String(totalStoreFileSizeMB * 1024 * 1024, "B", 2));
      out.write("</td>\n          ");

          } else {
          
      out.write("\n          0 MB </td>\n          ");

            }
          
      out.write("\n          <td>Total size of store files</td>\n        </tr>\n      </table>\n\n        ");
 if (!readOnly) { 
      out.write("\n      <p><hr/></p>\n      Actions:\n      <p>\n      <center>\n        <table class=\"table\" style=\"border: 0;\" width=\"95%\" >\n          <tr>\n            <form method=\"get\">\n            <input type=\"hidden\" name=\"action\" value=\"major compact\" />\n            <input type=\"hidden\" name=\"name\" value=\"");
      out.print( escaped_fqtn );
      out.write("\" />\n            <td class=\"centered\">\n              <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Major Compact\" class=\"btn\" />\n            </td>\n            <td style=\"text-align: center;\">\n              <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n            </td>\n            <td>\n              This action will force a major compaction of all regions of the table, or,\n              if a key is supplied, only the region major containing the\n              given key.\n            </td>\n            </form>\n          </tr>\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"compact\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
      out.print( escaped_fqtn );
      out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n              </td>\n              <td>\n                This action will force a compaction of all regions of the table, or,\n                if a key is supplied, only the region containing the\n                given key.\n              </td>\n            </form>\n          </tr>\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"split\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
      out.print( escaped_fqtn );
      out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n              </td>\n              <td>\n                This action will force a split of all eligible\n                regions of the table, or, if a key is supplied, only the region containing the\n                given key. An eligible region is one that does not contain any references to\n                other regions. Split requests for noneligible regions will be ignored.\n              </td>\n            </form>\n          </tr>\n          <tr>\n            <form method=\"get\">\n              <input type=\"hidden\" name=\"action\" value=\"merge\" />\n              <input type=\"hidden\" name=\"name\" value=\"");
      out.print( escaped_fqtn );
      out.write("\" />\n              <td class=\"centered\">\n                <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Merge\" class=\"btn\" />\n              </td>\n              <td style=\"text-align: center;\">\n                <input type=\"text\" name=\"left\" size=\"40\" placeholder=\"Region Key (required)\" />\n                <input type=\"text\" name=\"right\" size=\"40\" placeholder=\"Region Key (required)\" />\n              </td>\n              <td>\n                This action will merge two regions of the table, Merge requests for\n                noneligible regions will be ignored.\n              </td>\n            </form>\n          </tr>\n        </table>\n      </center>\n      </p>\n        ");
 } 
      out.write("\n  </div>\n</div>\n\n");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "footer.jsp", out, false);
      out.write("\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n\n<script>\n$(document).ready(function()\n    {\n        $.tablesorter.addParser(\n        {\n            id: 'filesize',\n            is: function(s) {\n                return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n            },\n            format: function(s) {\n                var suf = s.match(new RegExp( /(B|KB|MB|GB|TB)$/ ))[1];\n                var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                switch(suf) {\n                    case 'B':\n                        return num;\n                    case 'KB':\n                        return num * 1024;\n                    case 'MB':\n                        return num * 1024 * 1024;\n                    case 'GB':\n                        return num * 1024 * 1024 * 1024;\n                    case 'TB':\n");
      out.write("                        return num * 1024 * 1024 * 1024 * 1024;\n                }\n            },\n            type: 'numeric'\n        });\n        $.tablesorter.addParser(\n        {\n            id: \"separator\",\n            is: function (s) {\n                return /^[0-9]?[0-9,]*$/.test(s);\n            }, format: function (s) {\n                return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n            }, type: \"numeric\"\n        });\n        $(\"#regionServerTable\").tablesorter({\n            headers: {\n                1: {sorter: 'separator'}\n            }\n        });\n        $(\"#tableBaseStatsTable\").tablesorter({\n            headers: {\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'},\n                4: {sorter: 'filesize'},\n                5: {sorter: 'separator'},\n                6: {sorter: 'filesize'},\n                7: {empty: 'emptyMin'},\n                8: {empty: 'emptyMax'}\n            }\n        });\n        $(\"#metaTableBaseStatsTable\").tablesorter({\n            headers: {\n");
      out.write("                2: {sorter: 'separator'},\n                3: {sorter: 'separator'},\n                4: {sorter: 'filesize'},\n                5: {sorter: 'separator'},\n                6: {sorter: 'filesize'},\n                7: {empty: 'emptyMin'},\n                8: {empty: 'emptyMax'}\n            }\n        });\n        $(\"#tableLocalityStatsTable\").tablesorter({\n            headers: {\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'}\n            }\n        });\n        $(\"#metaTableLocalityStatsTable\").tablesorter({\n            headers: {\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'}\n            }\n        });\n        $(\"#tableCompactStatsTable\").tablesorter({\n            headers: {\n                2: {sorter: 'separator'},\n                3: {sorter: 'separator'},\n                4: {sorter: 'separator'}\n            }\n        });\n        $(\"#metaTableCompactStatsTable\").tablesorter({\n            headers: {\n                2: {sorter: 'separator'},\n");
      out.write("                3: {sorter: 'separator'},\n                4: {sorter: 'separator'}\n            }\n        });\n    }\n);\n</script>\n");
    } catch (java.lang.Throwable t) {
      if (!(t instanceof javax.servlet.jsp.SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try {
            if (response.isCommitted()) {
              out.flush();
            } else {
              out.clearBuffer();
            }
          } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
