/*
 * Generated by the Jasper component of Apache Tomcat
 * Version: JspC/ApacheTomcat9
 * Note: The last modified time of this file was set to
 *       the last modified time of the source file after
 *       generation to assist with modification tracking.
 */
package org.apache.hadoop.hbase.generated.master;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import static org.apache.commons.lang3.StringEscapeUtils.escapeXml;
import java.util.Collections;
import java.util.Comparator;
import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;

public final class rits_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent,
                 org.apache.jasper.runtime.JspSourceImports {

  private static final javax.servlet.jsp.JspFactory _jspxFactory =
          javax.servlet.jsp.JspFactory.getDefaultFactory();

  private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;

  private static final java.util.Set<java.lang.String> _jspx_imports_packages;

  private static final java.util.Set<java.lang.String> _jspx_imports_classes;

  static {
    _jspx_imports_packages = new java.util.LinkedHashSet<>(4);
    _jspx_imports_packages.add("javax.servlet");
    _jspx_imports_packages.add("javax.servlet.http");
    _jspx_imports_packages.add("javax.servlet.jsp");
    _jspx_imports_classes = new java.util.LinkedHashSet<>(19);
    _jspx_imports_classes.add("org.apache.hbase.thirdparty.com.google.gson.Gson");
    _jspx_imports_classes.add("static org.apache.commons.lang3.StringEscapeUtils.escapeXml");
    _jspx_imports_classes.add("java.util.HashMap");
    _jspx_imports_classes.add("java.util.stream.Collectors");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.RegionStateNode");
    _jspx_imports_classes.add("java.util.ArrayList");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.RegionState");
    _jspx_imports_classes.add("java.util.List");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure");
    _jspx_imports_classes.add("java.util.Map");
    _jspx_imports_classes.add("java.util.Comparator");
    _jspx_imports_classes.add("java.util.Collections");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.master.HMaster");
    _jspx_imports_classes.add("org.apache.hadoop.hbase.util.GsonUtil");
  }

  private volatile javax.el.ExpressionFactory _el_expressionfactory;
  private volatile org.apache.tomcat.InstanceManager _jsp_instancemanager;

  public java.util.Map<java.lang.String,java.lang.Long> getDependants() {
    return _jspx_dependants;
  }

  public java.util.Set<java.lang.String> getPackageImports() {
    return _jspx_imports_packages;
  }

  public java.util.Set<java.lang.String> getClassImports() {
    return _jspx_imports_classes;
  }

  public javax.el.ExpressionFactory _jsp_getExpressionFactory() {
    if (_el_expressionfactory == null) {
      synchronized (this) {
        if (_el_expressionfactory == null) {
          _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
        }
      }
    }
    return _el_expressionfactory;
  }

  public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {
    if (_jsp_instancemanager == null) {
      synchronized (this) {
        if (_jsp_instancemanager == null) {
          _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
        }
      }
    }
    return _jsp_instancemanager;
  }

  public void _jspInit() {
  }

  public void _jspDestroy() {
  }

  public void _jspService(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response)
      throws java.io.IOException, javax.servlet.ServletException {

    if (!javax.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {
      final java.lang.String _jspx_method = request.getMethod();
      if ("OPTIONS".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        return;
      }
      if (!"GET".equals(_jspx_method) && !"POST".equals(_jspx_method) && !"HEAD".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
        return;
      }
    }

    final javax.servlet.jsp.PageContext pageContext;
    javax.servlet.http.HttpSession session = null;
    final javax.servlet.ServletContext application;
    final javax.servlet.ServletConfig config;
    javax.servlet.jsp.JspWriter out = null;
    final java.lang.Object page = this;
    javax.servlet.jsp.JspWriter _jspx_out = null;
    javax.servlet.jsp.PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write('\n');
      out.write('\n');

    HMaster master = (HMaster) getServletContext().getAttribute(HMaster.MASTER);
    List<RegionStateNode> rit = master.getAssignmentManager().getRegionsInTransition();
    String table = request.getParameter("table");
    String state = request.getParameter("state");
    if (table != null && state != null && !table.equals("null") && !state.equals("null")) {
        rit = rit.stream().filter(regionStateNode -> regionStateNode.getTable().getNameAsString().equals(table))
                .filter(regionStateNode -> regionStateNode.getState().name().equals(state))
                .collect(Collectors.toList());
    }

    String format = request.getParameter("format");
    if(format == null || format.isEmpty()){
        format = "html";
    }
    String filter = request.getParameter("filter");
    Collections.sort(rit, new Comparator<RegionStateNode>() {
        @Override
        public int compare(RegionStateNode o1, RegionStateNode o2) {
            if (o1.getState() != o2.getState()){
                return o1.getState().ordinal() - o2.getState().ordinal();
            }
            return o1.compareTo(o2);
        }
    });

      out.write('\n');
      out.write('\n');
      out.write('\n');
 if (format.equals("html")) { 
      out.write('\n');
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "header.jsp" + "?" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode("pageTitle", request.getCharacterEncoding())+ "=" + org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode((java.lang.String) org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate("${pageTitle}", java.lang.String.class, (javax.servlet.jsp.PageContext)_jspx_page_context, null), request.getCharacterEncoding()), out, false);
      out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row\">\n        <div class=\"page-header\">\n            <h1>Regions in transition</h1>\n        </div>\n    </div>\n    <div class=\"row\">\n        <div class=\"page-header\">\n            <a href=\"/rits.jsp?format=txt&filter=region&table=");
      out.print(table);
      out.write("&state=");
      out.print(state);
      out.write("\" class=\"btn btn-primary\">Regions in text format</a>\n            <a href=\"/rits.jsp?format=txt&filter=procedure&table=");
      out.print(table);
      out.write("&state=");
      out.print(state);
      out.write("\" class=\"btn btn-info\">Procedures in text format</a>\n            <a href=\"/rits.jsp?format=json&table=");
      out.print(table);
      out.write("&state=");
      out.print(state);
      out.write("\" class=\"btn btn-info\">RIT info as JSON</a>\n            <p>regions and procedures in text format can be copied and passed to command-line utils such as hbck2</p>\n        </div>\n    </div>\n\n    ");
 if (rit != null && rit.size() > 0) { 
      out.write("\n        <table class=\"table table-striped\">\n            <tr>\n                <th>Region</th>\n                <th>Table</th>\n                <th>RegionState</th>\n                <th>Server</th>\n                <th>Procedure</th>\n                <th>ProcedureState</th>\n                <th>Start Time</th>\n                <th>Duration (ms)</th>\n            </tr>\n            ");
 for (RegionStateNode regionStateNode : rit) { 
      out.write("\n            <tr>\n                <td>");
      out.print( regionStateNode.getRegionInfo().getEncodedName() );
      out.write("</td>\n                <td>");
      out.print( regionStateNode.getRegionInfo().getTable() );
      out.write("</td>\n                <td>");
      out.print( regionStateNode.getState() );
      out.write("</td>\n                <td>");
      out.print( regionStateNode.getRegionLocation().getServerName() );
      out.write("</td>\n                ");

                    TransitRegionStateProcedure procedure = regionStateNode.getProcedure();

                    if (procedure == null) {
                
      out.write("\n                    <td></td>\n                    <td></td>\n                ");
 } else { 
      out.write("\n                    <td>");
      out.print( procedure.getProcId() );
      out.write("</td>\n                    <td>");
      out.print( escapeXml(procedure.getState().toString() + (procedure.isBypass() ? "(Bypassed)" : "")) );
      out.write("</td>\n                ");
 } 
      out.write("\n\n                ");
 RegionState rs = regionStateNode.toRegionState(); 
      out.write("\n                <td>");
      out.print( rs.getStamp() );
      out.write("</td>\n                <td>");
      out.print( System.currentTimeMillis() - rs.getStamp() );
      out.write("</td>\n            </tr>\n            ");
 } 
      out.write("\n            <p>");
      out.print( rit.size() );
      out.write(" region(s) in transition.</p>\n        </table>\n    ");
 } else { 
      out.write("\n    <p> no region in transition right now. </p>\n    ");
 } 
      out.write("\n</div>\n");
      org.apache.jasper.runtime.JspRuntimeLibrary.include(request, response, "footer.jsp", out, false);
      out.write('\n');
 } else if (format.equals("json")) { 
      out.write('\n');

    Gson GSON = GsonUtil.createGson().create();
    Map<String, List<Map<String, Object>>> map = new HashMap<>();
    List<Map<String, Object>> rits = new ArrayList<>();
    map.put("rits", rits);
    for (RegionStateNode regionStateNode : rit) {
        Map<String, Object> r = new HashMap<>();
        r.put("region", regionStateNode.getRegionInfo().getEncodedName());
        r.put("table", regionStateNode.getRegionInfo().getTable().getNameAsString());
        r.put("state", regionStateNode.getState());
        r.put("server", regionStateNode.getRegionLocation().getServerName());
        TransitRegionStateProcedure procedure = regionStateNode.getProcedure();
        if (procedure != null) {
          r.put("procedureId", procedure.getProcId());
          r.put("procedureState", procedure.getState().toString());
        }
        RegionState rs = regionStateNode.toRegionState();
        r.put("startTime", rs.getStamp());
        r.put("duration", System.currentTimeMillis() - rs.getStamp());
        rits.add(r);
      }
    
      out.write("\n    ");
      out.print( GSON.toJson(map) );
      out.write('\n');
 } else { 
      out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row\">\n        <p>\n            ");

            if (filter.equals("region")) {
                for (RegionStateNode regionStateNode : rit) { 
      out.write("\n                    ");
      out.print( regionStateNode.getRegionInfo().getEncodedName() );
      out.write("<br>\n            ");
    }
            } else if (filter.equals("procedure")) {
                for (RegionStateNode regionStateNode : rit) { 
      out.write("\n                    ");
      out.print( regionStateNode.getProcedure().getProcId() );
      out.write("<br>\n            ");
    }
            } else { 
      out.write("\n                \"Not a valid filter\"\n            ");
 } 
      out.write("\n        </p>\n    </div>\n</div>\n");
 } 
      out.write('\n');
    } catch (java.lang.Throwable t) {
      if (!(t instanceof javax.servlet.jsp.SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try {
            if (response.isCommitted()) {
              out.flush();
            } else {
              out.clearBuffer();
            }
          } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
