// Autogenerated Jamon implementation
// /home/work/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.net.URLEncoder;
// 34, 1
import java.io.IOException;
// 35, 1
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
// 36, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 37, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 38, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 39, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
// 40, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 41, 1
import org.apache.hadoop.hbase.HConstants;
// 42, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 43, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 44, 1
import org.apache.hadoop.hbase.ServerName;
// 45, 1
import org.apache.hadoop.hbase.TableName;
// 46, 1
import org.apache.hadoop.hbase.RSGroupTableAccessor;
// 47, 1
import org.apache.hadoop.hbase.client.Admin;
// 48, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 49, 1
import org.apache.hadoop.hbase.client.TableState;
// 50, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 51, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 52, 1
import org.apache.hadoop.hbase.master.HMaster;
// 53, 1
import org.apache.hadoop.hbase.master.RegionState;
// 54, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 55, 1
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
// 56, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 57, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 58, 1
import org.apache.hadoop.hbase.security.access.PermissionStorage;
// 59, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 60, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 61, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 62, 1
import org.apache.hadoop.hbase.util.Bytes;
// 63, 1
import org.apache.hadoop.hbase.util.CommonFSUtils;
// 64, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 65, 1
import org.apache.hadoop.hbase.util.PrettyPrinter;
// 66, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 78, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 105, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 69, 1
    if (format.equals("json") )
    {
      // 69, 30
      jamonWriter.write("\n  ");
      // 70, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 70, 68
      jamonWriter.write("\n  ");
      // 71, 3
      return; 
    }
    // 72, 7
    jamonWriter.write("\n");
    // 73, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 125, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 130, 12
    if (master.isActiveMaster() )
    {
      // 130, 43
      jamonWriter.write("Master: ");
    }
    // 130, 51
    else
    {
      // 130, 58
      jamonWriter.write("Backup Master: ");
    }
    // 130, 79
    jamonWriter.write("\n    ");
    // 131, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 131, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 155, 17
    if (master.isActiveMaster() )
    {
      // 155, 48
      jamonWriter.write("\n                    <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                    <li><a href=\"/hbck.jsp\">HBCK Report</a></li>\n                    <li><a href=\"/operationDetails.jsp\">Operation Details</a></li>\n                    ");
      // 159, 21
      if (master.getConfiguration().getBoolean(QuotaUtil.QUOTA_CONF_KEY, false) )
      {
        // 159, 98
        jamonWriter.write("\n                        <li><a href=\"/quotas.jsp\">Quotas</a></li>\n                    ");
      }
      // 161, 27
      jamonWriter.write("\n                ");
    }
    // 162, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li class=\"nav-item dropdown\">\n                  <a class=\"nav-link dropdown-toggle\" href=\"#\" id=\"navbarDropdownMenuLink\" data-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"false\">\n                    Metrics <span class=\"caret\"></span>\n                  </a>\n                  <ul class=\"dropdown-menu\" aria-labelledby=\"navbarDropdownMenuLink\">\n                    <li><a target=\"_blank\" href=\"/jmx\">JMX</a></li>\n                    <li><a target=\"_blank\" href=\"/jmx?description=true\">JMX with description</a></li>\n                    <li><a target=\"_blank\" href=\"/prometheus\">Prometheus</a></li>\n                    <li><a target=\"_blank\" href=\"/prometheus?description=true\">Prometheus with description</a></li>\n                  </ul>\n                </li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 179, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 179, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 181, 23
    jamonWriter.write("\n                <li><a href=\"/startupProgress.jsp\">Startup Progress</a></li>\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 189, 2
    if (master.isActiveMaster() )
    {
      // 189, 33
      jamonWriter.write("\n        <div class=\"row inner_header top_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 192, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 192, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 198, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 198, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 200, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 200, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 205, 15
      jamonWriter.write("\n        ");
      // 206, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 206, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 211, 15
      jamonWriter.write("\n        ");
      // 212, 9
      if (master.isInMaintenanceMode() )
      {
        // 212, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This is because hbase.master.maintenance_mode is\n          set to true. Under the maintenance mode, no quota or no Master coprocessor is loaded.\n          </div>\n        ");
      }
      // 217, 15
      jamonWriter.write("\n        ");
      // 218, 9
      if (!master.isBalancerOn() )
      {
        // 218, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 224, 15
      jamonWriter.write("\n        ");
      // 225, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 225, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 231, 15
      jamonWriter.write("\n        ");
      // 232, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 232, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 238, 15
      jamonWriter.write("\n        ");
      // 239, 9
      if (master.getAssignmentManager() != null )
      {
        // 239, 54
        jamonWriter.write("\n          ");
        // 240, 11
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_8.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 240, 92
        jamonWriter.write("\n        ");
      }
      // 241, 15
      jamonWriter.write("\n        ");
      // 242, 9
      if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null )
      {
        // 242, 91
        jamonWriter.write("\n          ");
        // 243, 11
        if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
            serverManager.getOnlineServersList().size() > 0 )
        {
          // 244, 63
          jamonWriter.write("\n            <section>\n              <h2><a name=\"rsgroup\">RSGroup</a></h2>\n              ");
          // 247, 15
          {
            org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
            __jamon__var_9.renderNoFlush(jamonWriter, master, serverManager);
          }
          // 247, 81
          jamonWriter.write("\n            </section>\n          ");
        }
        // 249, 17
        jamonWriter.write("\n        ");
      }
      // 250, 15
      jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
      // 253, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_10.setServers(servers );
        __jamon__var_10.renderNoFlush(jamonWriter, master);
      }
      // 253, 74
      jamonWriter.write("\n\n            ");
      // 255, 13
      if ((deadServers != null) )
      {
        // 255, 42
        jamonWriter.write("\n                ");
        // 256, 17
        {
          // 256, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 256, 40
        jamonWriter.write("\n            ");
      }
      // 257, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 260, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_11.renderNoFlush(jamonWriter, master );
      }
      // 260, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 278, 25
      if ((metaLocation != null) )
      {
        // 278, 55
        jamonWriter.write("\n                            ");
        // 279, 29
        {
          // 279, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 279, 45
        jamonWriter.write("\n                        ");
      }
      // 280, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 283, 25
      if ((metaLocation != null) )
      {
        // 283, 55
        jamonWriter.write("\n                            ");
        // 284, 29
        {
          // 284, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 284, 48
        jamonWriter.write("\n                        ");
      }
      // 285, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"region_visualizer\"></a>Region Visualizer</h2>\n            ");
      // 294, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionVisualizerTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.master.RegionVisualizerTmpl(this.getTemplateManager());
        __jamon__var_12.renderNoFlush(jamonWriter);
      }
      // 294, 39
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
      // 298, 13
      {
        // 298, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 298, 30
      jamonWriter.write("\n        </section>\n\t");
    }
    // 300, 2
    else
    {
      // 300, 9
      jamonWriter.write("\n        <section>\n            ");
      // 302, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_13 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_13.renderNoFlush(jamonWriter, master );
      }
      // 302, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 304, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 308, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_14 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_14.setFilter(filter);
      __jamon__var_14.setParent("/master-status" );
      __jamon__var_14.renderNoFlush(jamonWriter);
    }
    // 308, 88
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>JVM Version</td>\n                    <td>");
    // 321, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(JvmVersion.getVersion()), jamonWriter);
    // 321, 54
    jamonWriter.write("</td>\n                    <td>JVM vendor and version</td>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 326, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 326, 84
    jamonWriter.write(", revision=");
    // 326, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 326, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 330, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 330, 81
    jamonWriter.write(", ");
    // 330, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 330, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 335, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 335, 88
    jamonWriter.write("</td>\n                    <td>HBase source SHA512 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 340, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 340, 78
    jamonWriter.write(", revision=");
    // 340, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 340, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 345, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 345, 75
    jamonWriter.write(", ");
    // 345, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 345, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 350, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 350, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 355, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 355, 72
    jamonWriter.write(", revision=");
    // 355, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevisionHash()), jamonWriter);
    // 355, 135
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision hash</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 360, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 360, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 366, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 366, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 371, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 371, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
    // 376, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 376, 48
    jamonWriter.write(":");
    // 376, 49
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 376, 102
    jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 381, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(CommonFSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 381, 93
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 386, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 386, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 389, 17
    if (master.isActiveMaster() )
    {
      // 389, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 392, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 392, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 397, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 397, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 402, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 403, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 406, 18
      if (frags != null )
      {
        // 406, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 409, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 409, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 412, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 415, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 416, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 421, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 421, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 424, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/parser-date-iso8601.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jqSpager.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $.tablesorter.addParser(\n            {\n                id: 'filesize',\n                is: function(s) {\n                    return s.match(new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ));\n                },\n                format: function(s) {\n                    var suf = s.match(new RegExp( /(KB|B|GB|MB|TB)$/ ))[1];\n                    var num = parseFloat(s.match( new RegExp( /([\\.0-9]+)\\ (B|KB|MB|GB|TB)/ ))[0]);\n                    switch(suf) {\n                        case 'B':\n                            return num;\n                        case 'KB':\n                           return num * 1024;\n                        case 'MB':\n                            return num * 1024 * 1024;\n                        case 'GB':\n                            return num * 1024 * 1024 * 1024;\n                        case 'TB':\n                            return num * 1024 * 1024 * 1024 * 1024;\n                    }\n                },\n                type: 'numeric'\n            });\n            $.tablesorter.addParser(\n            {\n                id: \"separator\",\n                is: function (s) {\n                    return /^[0-9]?[0-9,]*$/.test(s);\n                }, format: function (s) {\n                    return $.tablesorter.formatFloat( s.replace(/,/g,'') );\n                }, type: \"numeric\"\n            });\n            $.tablesorter.addParser(\n            {\n                id: \"dateTime\",\n                is: function (s) {\n                    return /^([a-zA-Z]{3}\\s){2}\\d{2}\\s\\d{2}:\\d{2}:\\d{2}\\s[a-zA-Z]{3}\\s\\d{4}$/.test(s);\n                }, format: function (s) {\n                    var split = s.split(\" \");\n                    var time = Date.parse(split[1] + \" \" + split[2] + \" \" + split[3] + \" \" + split[5]);\n                    return $.tablesorter.formatFloat(time);\n                }, type: \"numeric\"\n            });\n            $(\"#baseStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'dateTime'},\n                    4: {sorter: 'separator'},\n                    5: {sorter: 'separator'}\n                }\n            });\n            $(\"#memoryStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'filesize'},\n                    2: {sorter: 'filesize'},\n                    3: {sorter: 'filesize'}\n                }\n            });\n            $(\"#requestStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'},\n                    4: {sorter: 'separator'}\n                }\n            });\n            $(\"#storeStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'filesize'},\n                    4: {sorter: 'filesize'},\n                    5: {sorter: 'filesize'},\n                    6: {sorter: 'filesize'}\n                }\n            });\n            $(\"#compactionStatsTable\").tablesorter({\n                headers: {\n                    1: {sorter: 'separator'},\n                    2: {sorter: 'separator'},\n                    3: {sorter: 'separator'}\n                }\n            });\n\n            $(\"#userTables\").tablesorter();\n\n            function showRitPages() {\n                if (!$(\"#rit_page_num\")) {\n                  return;\n                }\n                var ritTotalNum = parseInt($(\"#rit_page_num\").val());\n                if (!ritTotalNum || ritTotalNum < 1) {\n                  return;\n                }\n                var ritPerPage = parseInt($(\"#rit_per_page\").val());\n\n                 $(\"#rit_pagination\").sPage({\n                      page:1,\n                      total:ritTotalNum,\n                      pageSize:ritPerPage,\n                      noData: false,\n                      showPN:true,\n                      prevPage:\"prev\",\n                      nextPage:\"next\",\n                      fastForward: 5,\n                      backFun:function(page){\n                          $(\"div[id^='tab_rits']\").removeClass('active');\n                          $(\"#tab_rits\"+page).addClass('active');\n                      }\n                  });\n\n            }\n            showRitPages();\n\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 559, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 560, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 564, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 564, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 568, 5
      if ((frags != null) )
      {
        // 568, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 570, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 573, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 573, 48
        jamonWriter.write("\n<tr>\n");
        // 575, 1
        TableName tableName = systemTable.getTableName();
        // 576, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 576, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 576, 48
        jamonWriter.write("\">");
        // 576, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 576, 65
        jamonWriter.write("</a></td>\n    ");
        // 577, 5
        if ((frags != null))
        {
          // 577, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 578, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 579, 37
          jamonWriter.write("</td>\n    ");
        }
        // 580, 11
        jamonWriter.write("\n    ");
        // 581, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(PermissionStorage.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 603, 5
        jamonWriter.write("<td>");
        // 603, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 603, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 605, 8
      jamonWriter.write("\n</table>\n");
    }
    // 607, 7
    jamonWriter.write("\n");
  }
  
  
  // 697, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 699, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 699, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n        ");
      // 706, 9
      if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null
            && master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null
            &&  master.getServerManager().getOnlineServersList().size() > 0 )
      {
        // 708, 79
        jamonWriter.write("\n                <th>RSGroup</th>\n        ");
      }
      // 710, 15
      jamonWriter.write("\n    </tr>\n    ");
      // 712, 5
      
      List<RSGroupInfo> groups = null;
      DeadServer deadServerUtil = master.getServerManager().getDeadServers();
      if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null
        && master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null
        && master.getServerManager().getOnlineServersList().size() > 0) {
          groups = RSGroupTableAccessor.getAllRSGroupInfo(master.getConnection());
      }
      ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
      Arrays.sort(deadServerNames);
      for (ServerName deadServerName: deadServerNames) {
        String rsGroupName = null;
        if (groups != null){
          for (RSGroupInfo rsGroupInfo : groups) {
            if (rsGroupInfo.containsServer(deadServerName.getAddress())) {
              rsGroupName = rsGroupInfo.getName();
              break;
            }
          }
          if (rsGroupName == null) {
            rsGroupName = RSGroupInfo.DEFAULT_GROUP;
          }
        }
    
      // 736, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 738, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 738, 33
      jamonWriter.write("</td>\n        <td>");
      // 739, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 739, 64
      jamonWriter.write("</td>\n        ");
      // 740, 9
      if (rsGroupName != null )
      {
        // 740, 36
        jamonWriter.write("\n            <td>");
        // 741, 17
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
        // 741, 34
        jamonWriter.write("</td>\n        ");
      }
      // 742, 15
      jamonWriter.write("\n    </tr>\n    ");
      // 744, 5
      
        }
    
      // 747, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 749, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 749, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 753, 7
    jamonWriter.write("\n");
  }
  
  
  // 756, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 757, 1
    
    List<ReplicationPeerDescription> peers = null;
    if (master.getReplicationPeerManager() != null) {
        peers = master.getReplicationPeerManager().listPeers(null);
    }

    // 763, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
    // 777, 1
    if ((peers != null && peers.size() > 0))
    {
      // 777, 43
      jamonWriter.write("\n    ");
      // 778, 5
      for (ReplicationPeerDescription peer : peers )
      {
        // 778, 53
        jamonWriter.write("\n    ");
        // 779, 5
        
        String peerId = peer.getPeerId();
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
    
        // 783, 5
        jamonWriter.write("<tr>\n        <td>");
        // 784, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 784, 25
        jamonWriter.write("</td>\n        <td>");
        // 785, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 785, 45
        jamonWriter.write("</td>\n        <td>");
        // 786, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
        // 786, 58
        jamonWriter.write("</td>\n        <td>");
        // 787, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
        // 787, 60
        jamonWriter.write("</td>\n        <td>");
        // 788, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
        // 788, 40
        jamonWriter.write("</td>\n        <td>");
        // 789, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 789, 120
        jamonWriter.write("</td>\n        <td>");
        // 790, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
        // 790, 54
        jamonWriter.write("</td>\n        <td>\n           ");
        // 792, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 792, 151
        jamonWriter.write("\n        </td>\n        <td>\n            ");
        // 795, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 795, 166
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 798, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 798, 153
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 801, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 801, 167
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 804, 12
      jamonWriter.write("\n");
    }
    // 805, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 806, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 806, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 610, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 611, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 615, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 615, 52
      jamonWriter.write("\n<p> ");
      // 616, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 616, 23
      jamonWriter.write(" </p>\n");
    }
    // 617, 7
    jamonWriter.write("\n\n");
    // 619, 1
    if ((tables != null && tables.size() > 0))
    {
      // 619, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
      // 625, 9
      if ((frags != null) )
      {
        // 625, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 627, 15
      jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"7\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 643, 5
      for (TableDescriptor desc : tables)
      {
        // 643, 42
        jamonWriter.write("\n    ");
        // 644, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      TableState tableState = master.getTableStateManager().getTableState(tableName);
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int openingRegionsCount = tableRegions.get(RegionState.State.OPENING).size();
      int closedRegionsCount = tableRegions.get(RegionState.State.CLOSED).size();
      int closingRegionsCount = tableRegions.get(RegionState.State.CLOSING).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - offlineRegionsCount - splitRegionsCount
                     - openingRegionsCount - closedRegionsCount
                     - closingRegionsCount;
    String encodedTableName = URLEncoder.encode(tableName.getNameAsString());
    
        // 668, 5
        jamonWriter.write("<tr>\n        <td>");
        // 669, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 669, 51
        jamonWriter.write("</td>\n        ");
        // 670, 9
        if ((tableState.isDisabledOrDisabling()) )
        {
          // 670, 53
          jamonWriter.write(" <td><a style=\"color:red;\" href=table.jsp?name=");
          // 670, 100
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 670, 122
          jamonWriter.write(">");
          // 670, 123
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(URLEncoder.encode(tableName.getQualifierAsString())), jamonWriter);
          // 670, 180
          jamonWriter.write("</a></td> ");
        }
        // 670, 190
        else
        {
          // 670, 197
          jamonWriter.write("<td><a href=table.jsp?name=");
          // 670, 224
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 670, 246
          jamonWriter.write(">");
          // 670, 247
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(URLEncoder.encode(tableName.getQualifierAsString())), jamonWriter);
          // 670, 304
          jamonWriter.write("</a></td> ");
        }
        // 670, 320
        jamonWriter.write("\n        ");
        // 671, 9
        if ((frags != null) )
        {
          // 671, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 672, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 672, 150
          jamonWriter.write("</td>\n        ");
        }
        // 673, 15
        jamonWriter.write("\n        ");
        // 674, 9
        if ((tableState.isDisabledOrDisabling()) )
        {
          // 674, 53
          jamonWriter.write(" <td style=\"color:red;\">");
          // 674, 77
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState().name()), jamonWriter);
          // 674, 111
          jamonWriter.write("</td> ");
        }
        // 674, 117
        else
        {
          // 674, 124
          jamonWriter.write("<td>");
          // 674, 128
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState()), jamonWriter);
          // 674, 155
          jamonWriter.write("</td> ");
        }
        // 674, 167
        jamonWriter.write("\n        <td>");
        // 675, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 675, 35
        jamonWriter.write("</td>\n        ");
        // 676, 9
        if ((openingRegionsCount > 0) )
        {
          // 676, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 676, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 676, 118
          jamonWriter.write("&scan_region_state=OPENING\">");
          // 676, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 676, 171
          jamonWriter.write("</td> ");
        }
        // 676, 177
        else
        {
          // 676, 184
          jamonWriter.write("<td>");
          // 676, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 676, 213
          jamonWriter.write("</td> ");
        }
        // 676, 225
        jamonWriter.write("\n        ");
        // 677, 9
        if ((closedRegionsCount > 0) )
        {
          // 677, 41
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 677, 95
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 677, 117
          jamonWriter.write("&scan_region_state=CLOSED\">");
          // 677, 144
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
          // 677, 168
          jamonWriter.write("</td> ");
        }
        // 677, 174
        else
        {
          // 677, 181
          jamonWriter.write("<td>");
          // 677, 185
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
          // 677, 209
          jamonWriter.write("</td> ");
        }
        // 677, 221
        jamonWriter.write("\n        ");
        // 678, 9
        if ((closingRegionsCount > 0) )
        {
          // 678, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 678, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 678, 118
          jamonWriter.write("&scan_region_state=CLOSING\">");
          // 678, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 678, 171
          jamonWriter.write("</td> ");
        }
        // 678, 177
        else
        {
          // 678, 184
          jamonWriter.write("<td>");
          // 678, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 678, 213
          jamonWriter.write("</td> ");
        }
        // 678, 225
        jamonWriter.write("\n        ");
        // 679, 9
        if ((offlineRegionsCount > 0) )
        {
          // 679, 42
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 679, 96
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 679, 118
          jamonWriter.write("&scan_region_state=OFFLINE\">");
          // 679, 146
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
          // 679, 171
          jamonWriter.write("</td> ");
        }
        // 679, 177
        else
        {
          // 679, 184
          jamonWriter.write("<td>");
          // 679, 188
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
          // 679, 213
          jamonWriter.write("</td> ");
        }
        // 679, 225
        jamonWriter.write("\n        ");
        // 680, 9
        if ((splitRegionsCount > 0) )
        {
          // 680, 40
          jamonWriter.write(" <td><a href=\"/table.jsp?name=hbase%3Ameta&scan_table=");
          // 680, 94
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(encodedTableName), jamonWriter);
          // 680, 116
          jamonWriter.write("&scan_region_state=SPLIT\">");
          // 680, 142
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
          // 680, 165
          jamonWriter.write("</td> ");
        }
        // 680, 171
        else
        {
          // 680, 178
          jamonWriter.write("<td>");
          // 680, 182
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
          // 680, 205
          jamonWriter.write("</td> ");
        }
        // 680, 217
        jamonWriter.write("\n        <td>");
        // 681, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 681, 36
        jamonWriter.write("</td>\n        <td>");
        // 682, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 682, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 684, 12
      jamonWriter.write("\n    <p>");
      // 685, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 685, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]. Click count below to\n    see list of regions currently in 'state' designated by the column title. For 'Other' Region state,\n    browse to <a href=\"/table.jsp?name=hbase%3Ameta\">hbase:meta</a> and adjust filter on 'Meta Entries' to\n    query on states other than those listed here. Queries may take a while if the <i>hbase:meta</i> table\n    is large.</p>\n</tbody>\n</table>\n");
    }
    // 692, 7
    jamonWriter.write("\n");
  }
  
  
}
