// Autogenerated Jamon implementation
// /home/work/hbase-rm/output/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
// 30, 9
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
// 31, 9
import org.apache.hadoop.hbase.RegionMetrics;
// 32, 9
import org.apache.hadoop.hbase.RSGroupTableAccessor;
// 33, 9
import org.apache.hadoop.hbase.ServerMetrics;
// 34, 9
import org.apache.hadoop.hbase.ServerName;
// 35, 9
import org.apache.hadoop.hbase.Size;
// 36, 9
import org.apache.hadoop.hbase.net.Address;
// 37, 9
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
// 38, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 39, 9
import org.apache.hadoop.hbase.util.Pair;
// 40, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 43, 1
    if ((servers != null && servers.size() > 0))
    {
      // 43, 47
      jamonWriter.write("\n\n");
      // 45, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 50, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n        <li class=\"\"><a href=\"#tab_replicationStats\" data-toggle=\"tab\">Replications</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 61, 13
      {
        // 61, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 61, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 64, 13
      {
        // 64, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 64, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 67, 13
      {
        // 67, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 67, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 70, 13
      {
        // 70, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 70, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n            ");
      // 73, 13
      {
        // 73, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 73, 62
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_replicationStats\">\n            ");
      // 76, 13
      {
        // 76, 13
        __jamon_innerUnit__replicationStats(jamonWriter, serverNames);
      }
      // 76, 63
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 81, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 83, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 87, 1
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>State</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n    ");
    // 97, 5
    if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null )
    {
      // 97, 87
      jamonWriter.write("\n      ");
      // 98, 7
      if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
        master.getServerManager().getOnlineServersList().size() > 0 )
      {
        // 99, 71
        jamonWriter.write("\n        <th>RSGroup</th>\n      ");
      }
      // 101, 13
      jamonWriter.write("\n    ");
    }
    // 102, 11
    jamonWriter.write("\n</tr>\n</thead>\n<tbody>\n");
    // 106, 1
    
    int totalRegions = 0;
    int totalRequestsPerSecond = 0;
    int inconsistentNodeNum = 0;
    String state = "Normal";
    String masterVersion = VersionInfo.getVersion();
    Set<ServerName> decommissionedServers = new HashSet<>(master.listDecommissionedRegionServers());

    String rsGroupName = "default";
        List<RSGroupInfo> groups;
        Map<Address, RSGroupInfo> server2GroupMap = new HashMap<>();
        if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null
          && master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null
          && master.getServerManager().getOnlineServersList().size() > 0) {
            groups = RSGroupTableAccessor.getAllRSGroupInfo(master.getConnection());
            groups.forEach(group -> {
              group.getServers().forEach(address -> server2GroupMap.put(address, group));
            });
        }

    for (ServerName serverName: serverNames) {
    if (decommissionedServers.contains(serverName)) {
        state = "Decommissioned";
    }
    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }

    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestCountPerSecond();
        numRegionsOnline = sl.getRegionMetrics().size();
        totalRegions += sl.getRegionMetrics().size();
        totalRequestsPerSecond += sl.getRequestCountPerSecond();
        lastContact = (System.currentTimeMillis() - sl.getReportTimestamp())/1000;
    }
    long startcode = serverName.getStartcode();

    if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null
      && master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null
      && master.getServerManager().getOnlineServersList().size() > 0) {
        rsGroupName = server2GroupMap.get(serverName.getAddress()).getName();
    }

    // 155, 1
    jamonWriter.write("<tr>\n    <td>");
    // 156, 9
    {
      // 156, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 156, 53
    jamonWriter.write("</td>\n    <td>");
    // 157, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(state), jamonWriter);
    // 157, 20
    jamonWriter.write("</td>\n    <td>");
    // 158, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 158, 34
    jamonWriter.write("</td>\n    <td>");
    // 159, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 159, 71
    jamonWriter.write("</td>\n    <td>");
    // 160, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 160, 22
    jamonWriter.write("</td>\n    <td>");
    // 161, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,.0f", requestsPerSecond)), jamonWriter);
    // 161, 56
    jamonWriter.write("</td>\n    <td>");
    // 162, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", numRegionsOnline)), jamonWriter);
    // 162, 53
    jamonWriter.write("</td>\n    ");
    // 163, 5
    if (!master.isInMaintenanceMode() && master.getMasterCoprocessorHost() != null )
    {
      // 163, 87
      jamonWriter.write("\n      ");
      // 164, 7
      if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
        master.getServerManager().getOnlineServersList().size() > 0 )
      {
        // 165, 71
        jamonWriter.write("\n        <td>");
        // 166, 13
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rsGroupName), jamonWriter);
        // 166, 30
        jamonWriter.write("</td>\n      ");
      }
      // 167, 13
      jamonWriter.write("\n    ");
    }
    // 168, 11
    jamonWriter.write("\n</tr>\n");
    // 170, 1
    
}

    // 173, 1
    jamonWriter.write("</tbody>\n<tr><td>Total:");
    // 174, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 174, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n<td></td>\n");
    // 178, 1
    if (inconsistentNodeNum > 0)
    {
      // 178, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 179, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 179, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 180, 1
    else
    {
      // 180, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 182, 7
    jamonWriter.write("\n<td>");
    // 183, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequestsPerSecond), jamonWriter);
    // 183, 33
    jamonWriter.write("</td>\n<td>");
    // 184, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 184, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 380, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 384, 1
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
    // 395, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
long totalCompactingCells = 0;
long totalCompactedCells = 0;
for (RegionMetrics rl : sl.getRegionMetrics().values()) {
  totalCompactingCells += rl.getCompactingCellCount();
  totalCompactedCells += rl.getCompactedCellCount();
}
String percentDone = "";
if  (totalCompactingCells > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) totalCompactedCells / totalCompactingCells)) + "%";
}

    // 412, 1
    jamonWriter.write("<tr>\n<td>");
    // 413, 5
    {
      // 413, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 413, 49
    jamonWriter.write("</td>\n<td>");
    // 414, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactingCells)), jamonWriter);
    // 414, 53
    jamonWriter.write("</td>\n<td>");
    // 415, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactedCells)), jamonWriter);
    // 415, 52
    jamonWriter.write("</td>\n<td>");
    // 416, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", totalCompactingCells - totalCompactedCells)), jamonWriter);
    // 416, 75
    jamonWriter.write("</td>\n<td>");
    // 417, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 417, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 419, 1
    
        }  else {
        
    // 422, 1
    {
      // 422, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 422, 40
    jamonWriter.write("\n");
    // 423, 1
    
    }
}

    // 427, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 513, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 517, 5
    jamonWriter.write("<tr>\n    <td>");
    // 518, 9
    {
      // 518, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 518, 53
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 189, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 193, 1
    jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
    // 204, 1
    
final String ZEROMB = "0 MB";
for (ServerName serverName: serverNames) {
  String usedHeapStr = ZEROMB;
  String maxHeapStr = ZEROMB;
  String memStoreSizeMBStr = ZEROMB;
  ServerMetrics sl = master.getServerManager().getLoad(serverName);
  if (sl != null) {
    long memStoreSizeMB = 0;
    for (RegionMetrics rl : sl.getRegionMetrics().values()) {
      memStoreSizeMB += rl.getMemStoreSize().get(Size.Unit.MEGABYTE);
    }
    if (memStoreSizeMB > 0) {
      memStoreSizeMBStr = TraditionalBinaryPrefix.long2String(memStoreSizeMB
                                * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }

    double usedHeapSizeMB = sl.getUsedHeapSize().get(Size.Unit.MEGABYTE);
    if (usedHeapSizeMB > 0) {
      usedHeapStr = TraditionalBinaryPrefix.long2String((long) usedHeapSizeMB
                          * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    double maxHeapSizeMB = sl.getMaxHeapSize().get(Size.Unit.MEGABYTE);
    if (maxHeapSizeMB > 0) {
      maxHeapStr = TraditionalBinaryPrefix.long2String((long) maxHeapSizeMB
                         * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }

    // 232, 1
    jamonWriter.write("<tr>\n    <td>");
    // 233, 9
    {
      // 233, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 233, 53
    jamonWriter.write("</td>\n    <td>");
    // 234, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(usedHeapStr), jamonWriter);
    // 234, 26
    jamonWriter.write("</td>\n    <td>");
    // 235, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(maxHeapStr), jamonWriter);
    // 235, 25
    jamonWriter.write("</td>\n    <td>");
    // 236, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(memStoreSizeMBStr), jamonWriter);
    // 236, 32
    jamonWriter.write("</td>\n</tr>\n");
    // 238, 1
    
  } else {

    // 241, 1
    {
      // 241, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 241, 40
    jamonWriter.write("\n");
    // 242, 1
    
  }
}

    // 246, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 431, 1
  private void __jamon_innerUnit__replicationStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 435, 1
    
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap
            = master.getReplicationLoad(serverNames);
        List<String> peers = null;
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0){
            peers = new ArrayList<>(replicationLoadSourceMap.keySet());
            Collections.sort(peers);
        }

    // 445, 1
    if ((replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) )
    {
      // 445, 82
      jamonWriter.write("\n\n<div class=\"tabbable\">\n    <ul class=\"nav nav-tabs\">\n        ");
      // 449, 9
      
        String active = "active";
        for (String peer : peers){
        
      // 453, 13
      jamonWriter.write("<li class=");
      // 453, 23
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 453, 35
      jamonWriter.write("><a href=\"#tab_");
      // 453, 50
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 453, 60
      jamonWriter.write("\" data-toggle=\"tab\">Peer ");
      // 453, 85
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 453, 95
      jamonWriter.write("</a> </li>\n        ");
      // 454, 9
      
        active = "";
        }
        
      // 458, 5
      jamonWriter.write("</ul>\n    <div class=\"tab-content\">\n        ");
      // 460, 9
      
            active = "active";
            for (String peer : peers){
        
      // 464, 13
      jamonWriter.write("<div class=\"tab-pane ");
      // 464, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 464, 46
      jamonWriter.write("\" id=\"tab_");
      // 464, 56
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 464, 66
      jamonWriter.write("\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Server</th>\n                        <th>AgeOfLastShippedOp</th>\n                        <th>SizeOfLogQueue</th>\n                        <th>ReplicationLag</th>\n                    </tr>\n\n                    ");
      // 473, 21
      for (Pair<ServerName, ReplicationLoadSource> pair: replicationLoadSourceMap.get(peer) )
      {
        // 473, 110
        jamonWriter.write("\n                    <tr>\n                        <td>");
        // 475, 29
        {
          // 475, 29
          __jamon_innerUnit__serverNameLink(jamonWriter, pair.getFirst());
        }
        // 475, 78
        jamonWriter.write("</td>\n                        <td>");
        // 476, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanTimeDiff(pair.getSecond().getAgeOfLastShippedOp())), jamonWriter);
        // 476, 102
        jamonWriter.write("</td>\n                        <td>");
        // 477, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getSizeOfLogQueue()), jamonWriter);
        // 477, 71
        jamonWriter.write("</td>\n                        <td>");
        // 478, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getReplicationLag() == Long.MAX_VALUE ? "UNKNOWN" : StringUtils.humanTimeDiff(pair.getSecond().getReplicationLag())), jamonWriter);
        // 478, 167
        jamonWriter.write("</td>\n                    </tr>\n                    ");
      }
      // 480, 28
      jamonWriter.write("\n        </table>\n            </div>\n        ");
      // 483, 9
      
                active = "";
                }
        
      // 487, 5
      jamonWriter.write("</div>\n    <p>If the replication delay is UNKNOWN, that means this walGroup doesn't start replicate yet and it may get disabled.</p>\n</div>\n");
    }
    // 490, 1
    else
    {
      // 490, 8
      jamonWriter.write("\n    <p>No Peers Metrics</p>\n");
    }
    // 492, 7
    jamonWriter.write("\n");
  }
  
  
  // 251, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 255, 1
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
    // 266, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long readRequestCount = 0;
  long writeRequestCount = 0;
  long filteredReadRequestCount = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    readRequestCount += rl.getReadRequestCount();
    writeRequestCount += rl.getWriteRequestCount();
    filteredReadRequestCount += rl.getFilteredReadRequestCount();
  }

    // 280, 1
    jamonWriter.write("<tr>\n<td>");
    // 281, 5
    {
      // 281, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 281, 49
    jamonWriter.write("</td>\n<td>");
    // 282, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", sl.getRequestCountPerSecond())), jamonWriter);
    // 282, 62
    jamonWriter.write("</td>\n<td>");
    // 283, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", readRequestCount)), jamonWriter);
    // 283, 49
    jamonWriter.write("</td>\n<td>");
    // 284, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", filteredReadRequestCount)), jamonWriter);
    // 284, 57
    jamonWriter.write("</td>\n<td>");
    // 285, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", writeRequestCount)), jamonWriter);
    // 285, 50
    jamonWriter.write("</td>\n</tr>\n");
    // 287, 1
    
        }  else {
        
    // 290, 1
    {
      // 290, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 290, 40
    jamonWriter.write("\n");
    // 291, 1
    
        }
}

    // 295, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 497, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 501, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 506, 9
    if (infoPort > 0)
    {
      // 506, 28
      jamonWriter.write("\n            <a href=\"");
      // 507, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 507, 31
      jamonWriter.write("\">");
      // 507, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 507, 65
      jamonWriter.write("</a>\n        ");
    }
    // 508, 9
    else
    {
      // 508, 16
      jamonWriter.write("\n            ");
      // 509, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 509, 45
      jamonWriter.write("\n        ");
    }
    // 510, 15
    jamonWriter.write("\n");
  }
  
  
  // 300, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 304, 1
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
    // 317, 1
    
final String ZEROKB = "0 KB";
final String ZEROMB = "0 MB";
for (ServerName serverName: serverNames) {

  String storeUncompressedSizeMBStr = ZEROMB;
  String storeFileSizeMBStr = ZEROMB;
  String totalStaticIndexSizeKBStr = ZEROKB;
  String totalStaticBloomSizeKBStr = ZEROKB;
  ServerMetrics sl = master.getServerManager().getLoad(serverName);
  if (sl != null) {
    long storeCount = 0;
    long storeFileCount = 0;
    long storeUncompressedSizeMB = 0;
    long storeFileSizeMB = 0;
    long totalStaticIndexSizeKB = 0;
    long totalStaticBloomSizeKB = 0;
    for (RegionMetrics rl : sl.getRegionMetrics().values()) {
      storeCount += rl.getStoreCount();
      storeFileCount += rl.getStoreFileCount();
      storeUncompressedSizeMB += rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
      storeFileSizeMB += rl.getStoreFileSize().get(Size.Unit.MEGABYTE);
      totalStaticIndexSizeKB += rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
      totalStaticBloomSizeKB += rl.getBloomFilterSize().get(Size.Unit.KILOBYTE);
    }
    if (storeUncompressedSizeMB > 0) {
      storeUncompressedSizeMBStr = TraditionalBinaryPrefix.
      long2String(storeUncompressedSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    if (storeFileSizeMB > 0) {
      storeFileSizeMBStr = TraditionalBinaryPrefix.
      long2String(storeFileSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1);
    }
    if (totalStaticIndexSizeKB > 0) {
      totalStaticIndexSizeKBStr = TraditionalBinaryPrefix.
      long2String(totalStaticIndexSizeKB * TraditionalBinaryPrefix.KILO.value, "B", 1);
    }
    if (totalStaticBloomSizeKB > 0) {
      totalStaticBloomSizeKBStr = TraditionalBinaryPrefix.
      long2String(totalStaticBloomSizeKB * TraditionalBinaryPrefix.KILO.value, "B", 1);
    }

    // 359, 1
    jamonWriter.write("<tr>\n<td>");
    // 360, 5
    {
      // 360, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 360, 49
    jamonWriter.write("</td>\n<td>");
    // 361, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", storeCount)), jamonWriter);
    // 361, 43
    jamonWriter.write("</td>\n<td>");
    // 362, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%,d", storeFileCount)), jamonWriter);
    // 362, 47
    jamonWriter.write("</td>\n<td>");
    // 363, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeUncompressedSizeMBStr), jamonWriter);
    // 363, 37
    jamonWriter.write("</td>\n<td>");
    // 364, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeFileSizeMBStr), jamonWriter);
    // 364, 29
    jamonWriter.write("</td>\n<td>");
    // 365, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalStaticIndexSizeKBStr), jamonWriter);
    // 365, 36
    jamonWriter.write("</td>\n<td>");
    // 366, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalStaticBloomSizeKBStr), jamonWriter);
    // 366, 36
    jamonWriter.write("</td>\n</tr>\n");
    // 368, 1
    
  } else {

    // 371, 1
    {
      // 371, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 371, 40
    jamonWriter.write("\n");
    // 372, 1
    
  }
}

    // 376, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
}
