/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class RegionRemoteProcedureBase
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionRemoteProcedureBase.class);
    protected RegionInfo region;
    protected ServerName targetServer;
    private MasterProcedureProtos.RegionRemoteProcedureBaseState state = MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_DISPATCH;
    private RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode;
    private long seqId;
    private RetryCounter retryCounter;

    protected RegionRemoteProcedureBase() {
    }

    protected RegionRemoteProcedureBase(TransitRegionStateProcedure parent, RegionInfo region, ServerName targetServer) {
        this.region = region;
        this.targetServer = targetServer;
        parent.attachRemoteProc(this);
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        if (this.state == MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_REPORT_SUCCEED) {
            return Optional.empty();
        }
        return Optional.of(this.newRemoteOperation(env));
    }

    protected abstract RemoteProcedureDispatcher.RemoteOperation newRemoteOperation(MasterProcedureEnv var1);

    public void remoteOperationCompleted(MasterProcedureEnv env) {
        throw new UnsupportedOperationException();
    }

    public void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        throw new UnsupportedOperationException();
    }

    private RegionStateNode getRegionNode(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getRegionStateNode(this.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteCallFailed(MasterProcedureEnv env, ServerName remote, IOException exception) {
        RegionStateNode regionNode = this.getRegionNode(env);
        regionNode.lock();
        try {
            if (!env.getMasterServices().getServerManager().isServerOnline(remote)) {
                LOG.debug("{} for region {}, targetServer {} is dead, SCP will interrupt us, give up", new Object[]{this, regionNode, remote});
                return;
            }
            if (this.state != MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_DISPATCH) {
                LOG.warn("{} for region {}, targetServer={} has already been woken up, ignore", new Object[]{this, regionNode, remote});
                return;
            }
            LOG.warn("The remote operation {} for region {} to server {} failed", new Object[]{this, regionNode, remote, exception});
            this.state = MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_DISPATCH_FAIL;
            regionNode.getProcedureEvent().wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        }
        finally {
            regionNode.unlock();
        }
    }

    @Override
    public TableName getTableName() {
        return this.region.getTable();
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        if (TableName.isMetaTableName((TableName)this.getTableName())) {
            return false;
        }
        AssignmentManager am = env.getAssignmentManager();
        return am.waitMetaLoaded(this) || am.waitMetaAssigned(this, this.region);
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected abstract void checkTransition(RegionStateNode var1, RegionServerStatusProtos.RegionStateTransition.TransitionCode var2, long var3) throws UnexpectedStateException;

    protected abstract void updateTransitionWithoutPersistingToMeta(MasterProcedureEnv var1, RegionStateNode var2, RegionServerStatusProtos.RegionStateTransition.TransitionCode var3, long var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistAndWake(MasterProcedureEnv env, RegionStateNode regionNode) {
        RegionRemoteProcedureBase regionRemoteProcedureBase = this;
        synchronized (regionRemoteProcedureBase) {
            if (this.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) {
                LOG.warn("Procedure {} has already been rolled back, skip persistent", (Object)this);
                return;
            }
            env.getMasterServices().getMasterProcedureExecutor().getStore().update((Procedure)this);
        }
        regionNode.getProcedureEvent().wake((AbstractProcedureScheduler)env.getProcedureScheduler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTransition(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long seqId) throws IOException {
        if (this.state != MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_DISPATCH) {
            return;
        }
        if (!this.targetServer.equals((Object)serverName)) {
            throw new UnexpectedStateException("Received report from " + serverName + ", expected " + this.targetServer + ", " + regionNode + ", proc=" + this);
        }
        this.checkTransition(regionNode, transitionCode, seqId);
        this.state = MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_REPORT_SUCCEED;
        this.transitionCode = transitionCode;
        this.seqId = seqId;
        boolean succ = false;
        try {
            this.persistAndWake(env, regionNode);
            succ = true;
        }
        finally {
            if (!succ) {
                this.state = MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_DISPATCH;
                this.transitionCode = null;
                this.seqId = -1L;
            }
        }
        try {
            this.updateTransitionWithoutPersistingToMeta(env, regionNode, transitionCode, seqId);
        }
        catch (IOException e) {
            throw new AssertionError("should not happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverCrashed(MasterProcedureEnv env, RegionStateNode regionNode, ServerName serverName) {
        if (this.state == MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_SERVER_CRASH) {
            return;
        }
        MasterProcedureProtos.RegionRemoteProcedureBaseState oldState = this.state;
        this.state = MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_SERVER_CRASH;
        boolean succ = false;
        try {
            this.persistAndWake(env, regionNode);
            succ = true;
        }
        finally {
            if (!succ) {
                this.state = oldState;
            }
        }
    }

    protected abstract void restoreSucceedState(AssignmentManager var1, RegionStateNode var2, long var3) throws IOException;

    void stateLoaded(AssignmentManager am, RegionStateNode regionNode) {
        if (this.state == MasterProcedureProtos.RegionRemoteProcedureBaseState.REGION_REMOTE_PROCEDURE_REPORT_SUCCEED) {
            try {
                this.restoreSucceedState(am, regionNode, this.seqId);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private TransitRegionStateProcedure getParent(MasterProcedureEnv env) {
        return (TransitRegionStateProcedure)env.getMasterServices().getMasterProcedureExecutor().getProcedure(this.getParentProcId());
    }

    private void unattach(MasterProcedureEnv env) {
        this.getParent(env).unattachRemoteProc(this);
    }

    protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        RegionStateNode regionNode = this.getRegionNode(env);
        regionNode.lock();
        try {
            switch (this.state) {
                case REGION_REMOTE_PROCEDURE_DISPATCH: {
                    ProcedureEvent<?> event = regionNode.getProcedureEvent();
                    try {
                        env.getRemoteDispatcher().addOperationToNode((Comparable)this.targetServer, this);
                    }
                    catch (FailedRemoteDispatchException e) {
                        LOG.warn("Can not add remote operation {} for region {} to server {}, this usually because the server is alread dead, give up and mark the procedure as complete, the parent procedure will take care of this.", new Object[]{this, this.region, this.targetServer, e});
                        this.unattach(env);
                        Procedure<MasterProcedureEnv>[] procedureArray = null;
                        regionNode.unlock();
                        return procedureArray;
                    }
                    event.suspend();
                    event.suspendIfNotReady((Procedure)this);
                    throw new ProcedureSuspendedException();
                }
                case REGION_REMOTE_PROCEDURE_REPORT_SUCCEED: {
                    env.getAssignmentManager().persistToMeta(regionNode);
                    this.unattach(env);
                    Procedure<MasterProcedureEnv>[] event = null;
                    return event;
                }
                case REGION_REMOTE_PROCEDURE_DISPATCH_FAIL: {
                    this.unattach(env);
                    Procedure<MasterProcedureEnv>[] event = null;
                    return event;
                }
                case REGION_REMOTE_PROCEDURE_SERVER_CRASH: {
                    env.getAssignmentManager().regionClosedAbnormally(regionNode);
                    this.unattach(env);
                    Procedure<MasterProcedureEnv>[] event = null;
                    return event;
                }
            }
            try {
                throw new IllegalStateException("Unknown state: " + this.state);
            }
            catch (IOException e) {
                if (this.retryCounter == null) {
                    this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
                }
                long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                LOG.warn("Failed updating meta, suspend {}secs {}; {};", new Object[]{backoff / 1000L, this, regionNode, e});
                this.setTimeout(Math.toIntExact(backoff));
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                this.skipPersistence();
                throw new ProcedureSuspendedException();
            }
        }
        finally {
            regionNode.unlock();
        }
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    public boolean storeInDispatchedQueue() {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.RegionRemoteProcedureBaseStateData.Builder builder = MasterProcedureProtos.RegionRemoteProcedureBaseStateData.newBuilder().setRegion(ProtobufUtil.toRegionInfo((RegionInfo)this.region)).setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer)).setState(this.state);
        if (this.transitionCode != null) {
            builder.setTransitionCode(this.transitionCode);
            builder.setSeqId(this.seqId);
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.RegionRemoteProcedureBaseStateData data = (MasterProcedureProtos.RegionRemoteProcedureBaseStateData)serializer.deserialize(MasterProcedureProtos.RegionRemoteProcedureBaseStateData.class);
        this.region = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)data.getRegion());
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
        if (data.hasState()) {
            this.state = data.getState();
        }
        if (data.hasTransitionCode()) {
            this.transitionCode = data.getTransitionCode();
            this.seqId = data.getSeqId();
        }
    }

    protected void afterReplay(MasterProcedureEnv env) {
        this.getParent(env).attachRemoteProc(this);
    }

    public String getProcName() {
        return this.getClass().getSimpleName() + " " + this.region.getEncodedName();
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getProcName());
        if (this.targetServer != null) {
            builder.append(", server=");
            builder.append(this.targetServer);
        }
        if (this.retryCounter != null) {
            builder.append(", retry=");
            builder.append(this.retryCounter);
        }
    }
}

