/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManagerUtil;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.RegionSplitRestriction;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.IOExceptionSupplier;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitTableRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.SplitTableRegionState> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitTableRegionProcedure.class);
    private RegionInfo daughterOneRI;
    private RegionInfo daughterTwoRI;
    private byte[] bestSplitRow;
    private RegionSplitPolicy splitPolicy;
    private static final RegionState.State[] EXPECTED_SPLIT_STATES = new RegionState.State[]{RegionState.State.OPEN, RegionState.State.CLOSED};

    public SplitTableRegionProcedure() {
    }

    public SplitTableRegionProcedure(MasterProcedureEnv env, RegionInfo regionToSplit, byte[] splitRow) throws IOException {
        super(env, regionToSplit);
        RegionSplitRestriction splitRestriction;
        byte[] restrictedSplitRow;
        this.preflightChecks(env, true);
        SplitTableRegionProcedure.checkOnline(env, regionToSplit);
        this.bestSplitRow = splitRow;
        TableDescriptor tableDescriptor = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        Configuration conf = env.getMasterConfiguration();
        if (this.hasBestSplitRow() && !Bytes.equals((byte[])this.bestSplitRow, (byte[])(restrictedSplitRow = (splitRestriction = RegionSplitRestriction.create(tableDescriptor, conf)).getRestrictedSplitPoint(this.bestSplitRow)))) {
            LOG.warn("The specified split point {} violates the split restriction of the table. Using {} as a split point.", (Object)Bytes.toStringBinary((byte[])this.bestSplitRow), (Object)Bytes.toStringBinary((byte[])restrictedSplitRow));
            this.bestSplitRow = restrictedSplitRow;
        }
        this.checkSplittable(env, regionToSplit);
        TableName table = regionToSplit.getTable();
        long rid = SplitTableRegionProcedure.getDaughterRegionIdTimestamp(regionToSplit);
        this.daughterOneRI = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(regionToSplit.getStartKey()).setEndKey(this.bestSplitRow).setSplit(false).setRegionId(rid).build();
        this.daughterTwoRI = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(this.bestSplitRow).setEndKey(regionToSplit.getEndKey()).setSplit(false).setRegionId(rid).build();
        if (tableDescriptor.getRegionSplitPolicyClassName() != null) {
            Class<? extends RegionSplitPolicy> clazz = RegionSplitPolicy.getSplitPolicyClass(tableDescriptor, conf);
            this.splitPolicy = (RegionSplitPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        }
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitRegions((Procedure<?>)this, this.getTableName(), this.getParentRegion(), this.daughterOneRI, this.daughterTwoRI)) {
            try {
                LOG.debug(Procedure.LockState.LOCK_EVENT_WAIT + " " + env.getProcedureScheduler().dumpLocks());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegions((Procedure<?>)this, this.getTableName(), this.getParentRegion(), this.daughterOneRI, this.daughterTwoRI);
    }

    public RegionInfo getDaughterOneRI() {
        return this.daughterOneRI;
    }

    public RegionInfo getDaughterTwoRI() {
        return this.daughterTwoRI;
    }

    private boolean hasBestSplitRow() {
        return this.bestSplitRow != null && this.bestSplitRow.length > 0;
    }

    private void checkSplittable(MasterProcedureEnv env, RegionInfo regionToSplit) throws IOException {
        if (regionToSplit.getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't invoke split on non-default regions directly");
        }
        RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getParentRegion());
        IOException splittableCheckIOE = null;
        boolean splittable = false;
        if (node != null) {
            try {
                AdminProtos.GetRegionInfoResponse response;
                if (!this.hasBestSplitRow()) {
                    LOG.info("{} splitKey isn't explicitly specified, will try to find a best split key from RS {}", (Object)node.getRegionInfo().getRegionNameAsString(), (Object)node.getRegionLocation());
                    response = AssignmentManagerUtil.getRegionInfoResponse(env, node.getRegionLocation(), node.getRegionInfo(), true);
                    this.bestSplitRow = response.hasBestSplitRow() ? response.getBestSplitRow().toByteArray() : null;
                } else {
                    response = AssignmentManagerUtil.getRegionInfoResponse(env, node.getRegionLocation(), node.getRegionInfo(), false);
                }
                boolean bl = splittable = response.hasSplittable() && response.getSplittable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Splittable=" + splittable + " " + node.toShortString());
                }
            }
            catch (IOException e) {
                splittableCheckIOE = e;
            }
        }
        if (!splittable) {
            DoNotRetryIOException e = new DoNotRetryIOException(regionToSplit.getShortNameToLog() + " NOT splittable");
            if (splittableCheckIOE != null) {
                e.initCause(splittableCheckIOE);
            }
            throw e;
        }
        if (!this.hasBestSplitRow()) {
            throw new DoNotRetryIOException("Region not splittable because bestSplitPoint = null, maybe table is too small for auto split. For force split, try specifying split row");
        }
        if (Bytes.equals((byte[])regionToSplit.getStartKey(), (byte[])this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is equal to startkey: " + Bytes.toStringBinary((byte[])this.bestSplitRow));
        }
        if (!regionToSplit.containsRow(this.bestSplitRow)) {
            throw new DoNotRetryIOException("Split row is not inside region key range splitKey:" + Bytes.toStringBinary((byte[])this.bestSplitRow) + " region: " + regionToSplit);
        }
    }

    private static long getDaughterRegionIdTimestamp(RegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < hri.getRegionId()) {
            LOG.warn("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid);
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    private void removeNonDefaultReplicas(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.removeNonDefaultReplicas(env, Stream.of(this.getParentRegion()), this.getRegionReplication(env));
    }

    private void checkClosedRegions(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.checkClosedRegion(env, this.getParentRegion());
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_PREPARE: {
                    if (this.prepareSplitRegion(env)) {
                        this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION);
                        break;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.preSplitRegion(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CLOSE_PARENT_REGION);
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    this.addChildProcedure((Procedure[])this.createUnassignProcedures(env));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    this.checkClosedRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: {
                    this.removeNonDefaultReplicas(env);
                    this.createDaughterRegions(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE);
                    break;
                }
                case SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.writeMaxSequenceIdFile(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META: {
                    this.preSplitRegionBeforeMETA(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_UPDATE_META);
                    break;
                }
                case SPLIT_TABLE_REGION_UPDATE_META: {
                    this.updateMeta(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META);
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: {
                    this.preSplitRegionAfterMETA(env);
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS);
                    break;
                }
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: {
                    this.addChildProcedure((Procedure[])this.createAssignProcedures(env));
                    this.setNextState(MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_POST_OPERATION);
                    break;
                }
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    this.postSplitRegion(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            String msg = "Splitting " + this.getParentRegion().getEncodedName() + ", " + this;
            if (!this.isRollbackSupported(state)) {
                LOG.warn(msg, (Throwable)e);
            }
            LOG.error(msg, (Throwable)e);
            this.setFailure("master-split-regions", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SplitTableRegionState state) throws IOException, InterruptedException {
        LOG.trace("{} rollback state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case SPLIT_TABLE_REGION_UPDATE_META: 
                case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: 
                case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
                case SPLIT_TABLE_REGION_POST_OPERATION: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION_BEFORE_META: {
                    break;
                }
                case SPLIT_TABLE_REGION_CREATE_DAUGHTER_REGIONS: 
                case SPLIT_TABLE_REGION_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.deleteDaughterRegions(env);
                    break;
                }
                case SPLIT_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    this.openParentRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_CLOSE_PARENT_REGION: {
                    break;
                }
                case SPLIT_TABLE_REGION_PRE_OPERATION: {
                    this.postRollBackSplitRegion(env);
                    break;
                }
                case SPLIT_TABLE_REGION_PREPARE: {
                    this.rollbackPrepareSplit(env);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("pid=" + this.getProcId() + " failed rollback attempt step " + state + " for splitting the region " + this.getParentRegion().getEncodedName() + " in table " + this.getTableName(), (Throwable)e);
            throw e;
        }
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.SplitTableRegionState state) {
        switch (state) {
            case SPLIT_TABLE_REGION_UPDATE_META: 
            case SPLIT_TABLE_REGION_PRE_OPERATION_AFTER_META: 
            case SPLIT_TABLE_REGION_OPEN_CHILD_REGIONS: 
            case SPLIT_TABLE_REGION_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    protected MasterProcedureProtos.SplitTableRegionState getState(int stateId) {
        return MasterProcedureProtos.SplitTableRegionState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.SplitTableRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.SplitTableRegionState getInitialState() {
        return MasterProcedureProtos.SplitTableRegionState.SPLIT_TABLE_REGION_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData.Builder splitTableRegionMsg = MasterProcedureProtos.SplitTableRegionStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setParentRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.getRegion())).addChildRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.daughterOneRI)).addChildRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.daughterTwoRI));
        serializer.serialize((Message)splitTableRegionMsg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SplitTableRegionStateData splitTableRegionsMsg = (MasterProcedureProtos.SplitTableRegionStateData)serializer.deserialize(MasterProcedureProtos.SplitTableRegionStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(splitTableRegionsMsg.getUserInfo()));
        this.setRegion(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getParentRegionInfo()));
        assert (splitTableRegionsMsg.getChildRegionInfoCount() == 2);
        this.daughterOneRI = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getChildRegionInfo(0));
        this.daughterTwoRI = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)splitTableRegionsMsg.getChildRegionInfo(1));
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", parent=");
        sb.append(this.getParentRegion().getShortNameToLog());
        sb.append(", daughterA=");
        sb.append(this.daughterOneRI.getShortNameToLog());
        sb.append(", daughterB=");
        sb.append(this.daughterTwoRI.getShortNameToLog());
    }

    private RegionInfo getParentRegion() {
        return this.getRegion();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_SPLIT;
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getSplitProcMetrics();
    }

    private byte[] getSplitRow() {
        return this.daughterTwoRI.getStartKey();
    }

    public boolean prepareSplitRegion(MasterProcedureEnv env) throws IOException {
        if (env.getMasterServices().getSnapshotManager().isTableTakingAnySnapshot(this.getParentRegion().getTable())) {
            this.setFailure(new IOException("Skip splitting region " + this.getParentRegion().getShortNameToLog() + ", because we are taking snapshot for the table " + this.getParentRegion().getTable()));
            return false;
        }
        RegionStateNode node = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getParentRegion());
        if (node == null) {
            throw new UnknownRegionException(this.getParentRegion().getRegionNameAsString());
        }
        RegionInfo parentHRI = node.getRegionInfo();
        if (parentHRI == null) {
            LOG.info("Unsplittable; parent region is null; node={}", (Object)node);
            return false;
        }
        if (node.isInState(RegionState.State.SPLIT)) {
            LOG.info("Split of " + parentHRI + " skipped; state is already SPLIT");
            return false;
        }
        if (parentHRI.isSplit() || parentHRI.isOffline()) {
            LOG.info("Split of " + parentHRI + " skipped because offline/split.");
            return false;
        }
        if (!node.isInState(EXPECTED_SPLIT_STATES)) {
            this.setFailure(new IOException("Split " + parentHRI.getRegionNameAsString() + " FAILED because state=" + node.getState() + "; expected " + Arrays.toString(EXPECTED_SPLIT_STATES)));
            return false;
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
            LOG.warn("pid=" + this.getProcId() + " split switch is off! skip split of " + parentHRI);
            this.setFailure(new IOException("Split region " + parentHRI.getRegionNameAsString() + " failed due to split switch off"));
            return false;
        }
        if (!env.getMasterServices().getTableDescriptors().get(this.getTableName()).isSplitEnabled()) {
            LOG.warn("pid={}, split is disabled for the table! Skipping split of {}", (Object)this.getProcId(), (Object)parentHRI);
            this.setFailure(new IOException("Split region " + parentHRI.getRegionNameAsString() + " failed as region split is disabled for the table"));
            return false;
        }
        node.setState(RegionState.State.SPLITTING, new RegionState.State[0]);
        return true;
    }

    private void rollbackPrepareSplit(MasterProcedureEnv env) {
        RegionStateNode parentRegionStateNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(this.getParentRegion());
        if (parentRegionStateNode.getState() == RegionState.State.SPLITTING) {
            parentRegionStateNode.setState(RegionState.State.OPEN, new RegionState.State[0]);
        }
    }

    private void preSplitRegion(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitRegionAction(this.getTableName(), this.getSplitRow(), this.getUser());
        }
        try {
            MasterQuotaManager masterQuotaManager = env.getMasterServices().getMasterQuotaManager();
            if (masterQuotaManager != null) {
                masterQuotaManager.onRegionSplit(this.getParentRegion());
            }
        }
        catch (QuotaExceededException e) {
            env.getMasterServices().getRegionNormalizerManager().planSkipped(NormalizationPlan.PlanType.SPLIT);
            throw e;
        }
    }

    private void postRollBackSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackSplitRegionAction(this.getUser());
        }
    }

    private void openParentRegion(MasterProcedureEnv env) throws IOException {
        AssignmentManagerUtil.reopenRegionsForRollback(env, Collections.singletonList(this.getParentRegion()), this.getRegionReplication(env), this.getParentRegionServerName(env));
    }

    public void createDaughterRegions(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.getParentRegion(), false);
        regionFs.createSplitsDir(this.daughterOneRI, this.daughterTwoRI);
        Pair<List<Path>, List<Path>> expectedReferences = this.splitStoreFiles(env, regionFs);
        this.assertSplitResultFilesCount(fs, ((List)expectedReferences.getFirst()).size(), regionFs.getSplitsDir(this.daughterOneRI));
        regionFs.commitDaughterRegion(this.daughterOneRI, (List)expectedReferences.getFirst(), env);
        this.assertSplitResultFilesCount(fs, ((List)expectedReferences.getFirst()).size(), new Path(tabledir, this.daughterOneRI.getEncodedName()));
        this.assertSplitResultFilesCount(fs, ((List)expectedReferences.getSecond()).size(), regionFs.getSplitsDir(this.daughterTwoRI));
        regionFs.commitDaughterRegion(this.daughterTwoRI, (List)expectedReferences.getSecond(), env);
        this.assertSplitResultFilesCount(fs, ((List)expectedReferences.getSecond()).size(), new Path(tabledir, this.daughterTwoRI.getEncodedName()));
    }

    private void deleteDaughterRegions(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
        HRegionFileSystem.deleteRegionFromFileSystem(env.getMasterConfiguration(), mfs.getFileSystem(), tabledir, this.daughterOneRI);
        HRegionFileSystem.deleteRegionFromFileSystem(env.getMasterConfiguration(), mfs.getFileSystem(), tabledir, this.daughterTwoRI);
    }

    private Pair<List<Path>, List<Path>> splitStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs) throws IOException {
        Configuration conf = env.getMasterConfiguration();
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        int nbFiles = 0;
        HashMap files = new HashMap(htd.getColumnFamilyCount());
        for (ColumnFamilyDescriptor cfd : htd.getColumnFamilies()) {
            String string = cfd.getNameAsString();
            StoreFileTracker tracker = StoreFileTrackerFactory.create(env.getMasterConfiguration(), htd, cfd, regionFs);
            List<StoreFileInfo> sfis = tracker.load();
            if (sfis == null) continue;
            ArrayList<StoreFileInfo> filteredSfis = null;
            for (StoreFileInfo storeFileInfo : sfis) {
                if (storeFileInfo.isReference()) {
                    LOG.info("Skipping split of " + storeFileInfo + "; presuming ready for archiving.");
                    continue;
                }
                if (filteredSfis == null) {
                    filteredSfis = new ArrayList<StoreFileInfo>(sfis.size());
                    files.put(string, filteredSfis);
                }
                filteredSfis.add(storeFileInfo);
                ++nbFiles;
            }
        }
        if (nbFiles == 0) {
            return new Pair(Collections.emptyList(), Collections.emptyList());
        }
        int maxThreads = Math.min(conf.getInt("hbase.regionserver.region.split.threads.max", conf.getInt("hbase.hstore.blockingStoreFiles", 16)), nbFiles);
        LOG.info("pid=" + this.getProcId() + " splitting " + nbFiles + " storefiles, region=" + this.getParentRegion().getShortNameToLog() + ", threads=" + maxThreads);
        ExecutorService threadPool = Executors.newFixedThreadPool(maxThreads, new ThreadFactoryBuilder().setNameFormat("StoreFileSplitter-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        ArrayList<Future<Pair<Path, Path>>> futures = new ArrayList<Future<Pair<Path, Path>>>(nbFiles);
        for (Map.Entry entry : files.entrySet()) {
            byte[] familyName = Bytes.toBytes((String)((String)entry.getKey()));
            ColumnFamilyDescriptor hcd = htd.getColumnFamily(familyName);
            Collection storeFiles = (Collection)entry.getValue();
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            Configuration configuration = StoreUtils.createStoreConfiguration(env.getMasterConfiguration(), htd, hcd);
            for (StoreFileInfo storeFileInfo : storeFiles) {
                storeFileInfo.setConf(configuration);
                StoreFileSplitter sfs = new StoreFileSplitter(regionFs, familyName, new HStoreFile(storeFileInfo, hcd.getBloomFilterType(), CacheConfig.DISABLED));
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        long fileSplitTimeout = conf.getLong("hbase.master.fileSplitTimeout", conf.getLong("hbase.regionserver.fileSplitTimeout", 600000L));
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        ArrayList<Object> daughterA = new ArrayList<Object>();
        ArrayList<Object> daughterB = new ArrayList<Object>();
        for (Future future : futures) {
            try {
                Pair pair = (Pair)future.get();
                if (pair.getFirst() != null) {
                    daughterA.add(pair.getFirst());
                }
                if (pair.getSecond() == null) continue;
                daughterB.add(pair.getSecond());
            }
            catch (InterruptedException interruptedException) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new IOException(executionException);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " split storefiles for region " + this.getParentRegion().getShortNameToLog() + " Daughter A: " + daughterA + " storefiles, Daughter B: " + daughterB + " storefiles.");
        }
        return new Pair(daughterA, daughterB);
    }

    private void assertSplitResultFilesCount(FileSystem fs, int expectedSplitResultFileCount, Path dir) throws IOException {
        int resultFileCount;
        if (expectedSplitResultFileCount != 0 && expectedSplitResultFileCount != (resultFileCount = FSUtils.getRegionReferenceAndLinkFileCount(fs, dir))) {
            throw new IOException("Failing split. Didn't have expected reference and HFileLink files, expected=" + expectedSplitResultFileCount + ", actual=" + resultFileCount);
        }
    }

    private Pair<Path, Path> splitStoreFile(HRegionFileSystem regionFs, byte[] family, HStoreFile sf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " splitting started for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog());
        }
        byte[] splitRow = this.getSplitRow();
        String familyName = Bytes.toString((byte[])family);
        Path path_first = regionFs.splitStoreFile(this.daughterOneRI, familyName, sf, splitRow, false, this.splitPolicy);
        Path path_second = regionFs.splitStoreFile(this.daughterTwoRI, familyName, sf, splitRow, true, this.splitPolicy);
        if (LOG.isDebugEnabled()) {
            LOG.debug("pid=" + this.getProcId() + " splitting complete for store file: " + sf.getPath() + " for region: " + this.getParentRegion().getShortNameToLog());
        }
        return new Pair((Object)path_first, (Object)path_second);
    }

    private void preSplitRegionBeforeMETA(MasterProcedureEnv env) throws IOException, InterruptedException {
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitBeforeMETAAction(this.getSplitRow(), metaEntries, this.getUser());
            try {
                for (Mutation p : metaEntries) {
                    RegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error("pid=" + this.getProcId() + " row key of mutation from coprocessor not parsable as region name.Mutations from coprocessor should only for hbase:meta table.");
                throw e;
            }
        }
    }

    private void updateMeta(MasterProcedureEnv env) throws IOException {
        env.getAssignmentManager().markRegionAsSplit(this.getParentRegion(), this.getParentRegionServerName(env), this.daughterOneRI, this.daughterTwoRI);
    }

    private void preSplitRegionAfterMETA(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSplitAfterMETAAction(this.getUser());
        }
    }

    private void postSplitRegion(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedSplitRegionAction(this.daughterOneRI, this.daughterTwoRI, this.getUser());
        }
    }

    private ServerName getParentRegionServerName(MasterProcedureEnv env) {
        return env.getMasterServices().getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.getParentRegion());
    }

    private TransitRegionStateProcedure[] createUnassignProcedures(MasterProcedureEnv env) throws IOException {
        return AssignmentManagerUtil.createUnassignProceduresForSplitOrMerge(env, Stream.of(this.getParentRegion()), this.getRegionReplication(env));
    }

    private TransitRegionStateProcedure[] createAssignProcedures(MasterProcedureEnv env) throws IOException {
        ArrayList<RegionInfo> hris = new ArrayList<RegionInfo>(2);
        hris.add(this.daughterOneRI);
        hris.add(this.daughterTwoRI);
        return AssignmentManagerUtil.createAssignProceduresForSplitDaughters(env, hris, this.getRegionReplication(env), this.getParentRegionServerName(env));
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        return htd.getRegionReplication();
    }

    private void writeMaxSequenceIdFile(MasterProcedureEnv env) throws IOException {
        MasterFileSystem fs = env.getMasterFileSystem();
        long maxSequenceId = WALSplitUtil.getMaxRegionSequenceId(env.getMasterConfiguration(), this.getParentRegion(), (IOExceptionSupplier<FileSystem>)((IOExceptionSupplier)fs::getFileSystem), (IOExceptionSupplier<FileSystem>)((IOExceptionSupplier)fs::getWALFileSystem));
        if (maxSequenceId > 0L) {
            WALSplitUtil.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.daughterOneRI), maxSequenceId);
            WALSplitUtil.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.daughterTwoRI), maxSequenceId);
        }
    }

    protected boolean abort(MasterProcedureEnv env) {
        return this.isRollbackSupported((MasterProcedureProtos.SplitTableRegionState)this.getCurrentState()) ? super.abort((Object)env) : false;
    }

    private class StoreFileSplitter
    implements Callable<Pair<Path, Path>> {
        private final HRegionFileSystem regionFs;
        private final byte[] family;
        private final HStoreFile sf;

        public StoreFileSplitter(HRegionFileSystem regionFs, byte[] family, HStoreFile sf) {
            this.regionFs = regionFs;
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Pair<Path, Path> call() throws IOException {
            return SplitTableRegionProcedure.this.splitStoreFile(this.regionFs, this.family, this.sf);
        }
    }
}

