/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestAppendFromClientSide {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAppendFromClientSide.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAppendWithCustomTimestamp() throws IOException {
        TableName TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(TABLENAME, FAMILY);
        long timestamp = 999L;
        Append append = new Append(ROW);
        append.add(CellUtil.createCell((byte[])ROW, (byte[])FAMILY, (byte[])QUALIFIER, (long)timestamp, (byte)KeyValue.Type.Put.getCode(), (byte[])Bytes.toBytes((long)100L)));
        Result r = table.append(append);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.get(new Get(ROW));
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.append(append);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertNotEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
        r = table.get(new Get(ROW));
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertNotEquals((long)timestamp, (long)r.rawCells()[0].getTimestamp());
    }
}

