/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableSnapshotScanner;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestTableSnapshotScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableSnapshotScanner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTableSnapshotScanner.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_REGION_SERVERS = 2;
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2")};
    public static byte[] bbb = Bytes.toBytes((String)"bbb");
    public static byte[] yyy = Bytes.toBytes((String)"yyy");
    private FileSystem fs;
    private Path rootDir;
    private boolean clusterUp;
    @Rule
    public TestName name = new TestName();

    public static void blockUntilSplitFinished(HBaseTestingUtility util, TableName tableName, int expectedRegionSize) throws Exception {
        List hRegionInfoList;
        for (int i = 0; i < 100 && (hRegionInfoList = util.getAdmin().getTableRegions(tableName)).size() < expectedRegionSize; ++i) {
            Thread.sleep(1000L);
        }
    }

    @Before
    public void setupCluster() throws Exception {
        this.setupConf(this.UTIL.getConfiguration());
        StartMiniClusterOption option = StartMiniClusterOption.builder().numRegionServers(2).numDataNodes(2).createRootDir(true).build();
        this.UTIL.startMiniCluster(option);
        this.clusterUp = true;
        this.rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.fs = this.rootDir.getFileSystem(this.UTIL.getConfiguration());
    }

    @After
    public void tearDownCluster() throws Exception {
        if (this.clusterUp) {
            this.UTIL.shutdownMiniCluster();
        }
    }

    protected void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
    }

    public static void createTableAndSnapshot(HBaseTestingUtility util, TableName tableName, String snapshotName, int numRegions) throws Exception {
        try {
            util.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numRegions > 1) {
            util.createTable(tableName, FAMILIES, 1, bbb, yyy, numRegions);
        } else {
            util.createTable(tableName, FAMILIES);
        }
        Admin admin = util.getAdmin();
        Table table = util.getConnection().getTable(tableName);
        util.loadTable(table, FAMILIES);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)util.getConfiguration());
        FileSystem fs = rootDir.getFileSystem(util.getConfiguration());
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
        byte[] value = Bytes.toBytes((String)"after_snapshot_value");
        util.loadTable(table, FAMILIES, value);
        admin.flush(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDuplicateResultsWhenSplitting() throws Exception {
        TableName tableName = TableName.valueOf((String)"testNoDuplicateResultsWhenSplitting");
        String snapshotName = "testSnapshotBug";
        try {
            if (this.UTIL.getAdmin().tableExists(tableName)) {
                this.UTIL.deleteTable(tableName);
            }
            this.UTIL.createTable(tableName, FAMILIES);
            Admin admin = this.UTIL.getAdmin();
            Table table = this.UTIL.getConnection().getTable(tableName);
            this.UTIL.loadTable(table, FAMILIES);
            admin.split(tableName, Bytes.toBytes((String)"eee"));
            TestTableSnapshotScanner.blockUntilSplitFinished(this.UTIL, tableName, 2);
            Path rootDir = CommonFSUtils.getRootDir((Configuration)this.UTIL.getConfiguration());
            FileSystem fs = rootDir.getFileSystem(this.UTIL.getConfiguration());
            SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
            byte[] value = Bytes.toBytes((String)"after_snapshot_value");
            this.UTIL.loadTable(table, FAMILIES, value);
            admin.flush(tableName);
            table.close();
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(bbb).withStopRow(yyy);
            TableSnapshotScanner scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanLimit() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = tableName + "Snapshot";
        TableSnapshotScanner scanner = null;
        try {
            Result result;
            TestTableSnapshotScanner.createTableAndSnapshot(this.UTIL, tableName, snapshotName, 50);
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(bbb).setLimit(100);
            scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            int count = 0;
            while ((result = scanner.next()) != null) {
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testWithSingleRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithSingleRegion", 1, false);
    }

    @Test
    public void testWithMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 10, false);
    }

    @Test
    public void testWithOfflineHBaseMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 20, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanMetrics createTableSnapshotScannerAndGetScanMetrics(boolean enableScanMetrics, boolean enableScanMetricsByRegion, byte[] endKey) throws Exception {
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + "_TABLE"));
        String snapshotName = this.name.getMethodName() + "_SNAPSHOT";
        try {
            TestTableSnapshotScanner.createTableAndSnapshot(this.UTIL, tableName, snapshotName, 50);
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(bbb).withStopRow(endKey);
            scan.setScanMetricsEnabled(enableScanMetrics);
            scan.setEnableScanMetricsByRegion(enableScanMetricsByRegion);
            Configuration conf = this.UTIL.getConfiguration();
            TableSnapshotScanner snapshotScanner = new TableSnapshotScanner(conf, restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)snapshotScanner, bbb, endKey);
            ScanMetrics scanMetrics = snapshotScanner.getScanMetrics();
            return scanMetrics;
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testScanMetricsDisabled() throws Exception {
        ScanMetrics scanMetrics = this.createTableSnapshotScannerAndGetScanMetrics(false, false, yyy);
        Assert.assertNull((Object)scanMetrics);
    }

    @Test
    public void testScanMetricsWithScanMetricsByRegionDisabled() throws Exception {
        ScanMetrics scanMetrics = this.createTableSnapshotScannerAndGetScanMetrics(true, false, yyy);
        Assert.assertNotNull((Object)scanMetrics);
        int rowsScanned = 0;
        for (byte[] row : HBaseTestingUtility.ROWS) {
            if (Bytes.compareTo((byte[])row, (byte[])bbb) < 0 || Bytes.compareTo((byte[])row, (byte[])yyy) >= 0) continue;
            ++rowsScanned;
        }
        Map metricsMap = scanMetrics.getMetricsMap();
        Assert.assertEquals((long)rowsScanned, (long)((Long)metricsMap.get("ROWS_SCANNED")));
    }

    @Test
    public void testScanMetricsByRegionForSingleRegion() throws Exception {
        byte[] bbc = Bytes.toBytes((String)"bbc");
        ScanMetrics scanMetrics = this.createTableSnapshotScannerAndGetScanMetrics(true, true, bbc);
        Assert.assertNotNull((Object)scanMetrics);
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
        Assert.assertEquals((long)1L, (long)scanMetricsByRegion.size());
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            Map metricsMap = (Map)entry.getValue();
            Assert.assertNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("ROWS_SCANNED")));
        }
    }

    @Test
    public void testScanMetricsByRegionForMultiRegion() throws Exception {
        ScanMetrics scanMetrics = this.createTableSnapshotScannerAndGetScanMetrics(true, true, yyy);
        Assert.assertNotNull((Object)scanMetrics);
        Map scanMetricsByRegion = scanMetrics.collectMetricsByRegion();
        for (Map.Entry entry : scanMetricsByRegion.entrySet()) {
            ScanMetricsRegionInfo scanMetricsRegionInfo = (ScanMetricsRegionInfo)entry.getKey();
            Map metricsMap = (Map)entry.getValue();
            Assert.assertNull((Object)scanMetricsRegionInfo.getServerName());
            Assert.assertNotNull((Object)scanMetricsRegionInfo.getEncodedRegionName());
            Assert.assertEquals((long)1L, (long)((Long)metricsMap.get("REGIONS_SCANNED")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScannerWithRestoreScanner() throws Exception {
        TableName tableName = TableName.valueOf((String)"testScanner");
        String snapshotName = "testScannerWithRestoreScanner";
        try {
            TestTableSnapshotScanner.createTableAndSnapshot(this.UTIL, tableName, snapshotName, 50);
            Path restoreDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbb, yyy);
            Configuration conf = this.UTIL.getConfiguration();
            Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
            TableSnapshotScanner scanner0 = new TableSnapshotScanner(conf, restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)scanner0, bbb, yyy);
            scanner0.close();
            RestoreSnapshotHelper.copySnapshotForScanner((Configuration)conf, (FileSystem)this.fs, (Path)rootDir, (Path)restoreDir, (String)snapshotName);
            TableSnapshotScanner scanner = new TableSnapshotScanner(conf, rootDir, restoreDir, snapshotName, scan, true);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
            scanner = new TableSnapshotScanner(conf, rootDir, restoreDir, snapshotName, scan, true);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
            RestoreSnapshotHelper.copySnapshotForScanner((Configuration)conf, (FileSystem)this.fs, (Path)rootDir, (Path)restoreDir, (String)snapshotName);
            scanner = new TableSnapshotScanner(conf, rootDir, restoreDir, snapshotName, scan, true);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanner(HBaseTestingUtility util, String snapshotName, int numRegions, boolean shutdownCluster) throws Exception {
        TableName tableName = TableName.valueOf((String)"testScanner");
        try {
            TestTableSnapshotScanner.createTableAndSnapshot(util, tableName, snapshotName, numRegions);
            if (shutdownCluster) {
                util.shutdownMiniHBaseCluster();
                this.clusterUp = false;
            }
            Path restoreDir = util.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbb, yyy);
            TableSnapshotScanner scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            scanner.close();
        }
        finally {
            if (this.clusterUp) {
                util.getAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    private void verifyScanner(ResultScanner scanner, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        Result result;
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        while ((result = scanner.next()) != null) {
            TestTableSnapshotScanner.verifyRow(result);
            rowTracker.addRow(result.getRow());
        }
        rowTracker.validate();
    }

    private static void verifyRow(Result result) throws IOException {
        byte[] row = result.getRow();
        CellScanner scanner = result.cellScanner();
        while (scanner.advance()) {
            Cell cell = scanner.current();
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])row, (int)0, (int)row.length, (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        for (int j = 0; j < FAMILIES.length; ++j) {
            byte[] actual = result.getValue(FAMILIES[j], FAMILIES[j]);
            Assert.assertArrayEquals((String)("Row in snapshot does not match, expected:" + Bytes.toString((byte[])row) + " ,actual:" + Bytes.toString((byte[])actual)), (byte[])row, (byte[])actual);
        }
    }

    @Test
    public void testMergeRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMergeRegion");
        String snapshotName = tableName.getNameAsString() + "_snapshot";
        Configuration conf = this.UTIL.getConfiguration();
        Path rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        long timeout = 20000L;
        try (Admin admin = this.UTIL.getAdmin();){
            List serverList = admin.getRegionServers().stream().map(sn -> sn.getServerName()).collect(Collectors.toList());
            Table table = this.UTIL.createTable(tableName, FAMILIES, 1, bbb, yyy, 3);
            List regions = admin.getRegions(tableName);
            Assert.assertEquals((long)3L, (long)regions.size());
            RegionInfo region0 = (RegionInfo)regions.get(0);
            RegionInfo region1 = (RegionInfo)regions.get(1);
            RegionInfo region2 = (RegionInfo)regions.get(2);
            this.UTIL.loadTable(table, FAMILIES);
            admin.flush(tableName);
            this.UTIL.waitFor(timeout, () -> {
                try {
                    Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tableName);
                    for (RegionInfo region : regions) {
                        Path regionDir = new Path(tableDir, region.getEncodedName());
                        Iterator iterator = FSUtils.getFamilyDirs((FileSystem)this.fs, (Path)regionDir).iterator();
                        if (!iterator.hasNext()) continue;
                        Path familyDir = (Path)iterator.next();
                        for (FileStatus fs : this.fs.listStatus(familyDir)) {
                            if (fs.getPath().getName().equals(".filelist")) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.warn("Failed check if flush is finished", (Throwable)e);
                    return false;
                }
            });
            admin.compactionSwitch(false, serverList);
            admin.mergeRegionsAsync(region0.getEncodedNameAsBytes(), region1.getEncodedNameAsBytes(), true);
            this.UTIL.waitFor(timeout, () -> admin.getRegions(tableName).size() == 2);
            List mergedRegions = admin.getRegions(tableName);
            RegionInfo mergedRegion = ((RegionInfo)mergedRegions.get(0)).getEncodedName().equals(region2.getEncodedName()) ? (RegionInfo)mergedRegions.get(1) : (RegionInfo)mergedRegions.get(0);
            admin.snapshot(snapshotName, tableName);
            Assert.assertEquals((long)1L, (long)admin.listSnapshots().size());
            admin.compactionSwitch(true, serverList);
            admin.majorCompactRegion(mergedRegion.getRegionName());
            this.UTIL.waitFor(timeout, () -> {
                try {
                    for (JVMClusterUtil.RegionServerThread regionServerThread : this.UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
                        HRegionServer regionServer = regionServerThread.getRegionServer();
                        for (HRegion subRegion : regionServer.getRegions(tableName)) {
                            if (!subRegion.getRegionInfo().getEncodedName().equals(mergedRegion.getEncodedName())) continue;
                            regionServer.getCompactedHFilesDischarger().chore();
                        }
                    }
                    Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tableName);
                    HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem((Configuration)this.UTIL.getConfiguration(), (FileSystem)this.fs, (Path)tableDir, (RegionInfo)mergedRegion, (boolean)true);
                    return !regionFs.hasReferences(admin.getDescriptor(tableName));
                }
                catch (IOException e) {
                    LOG.warn("Failed check merged region has no reference", (Throwable)e);
                    return false;
                }
            });
            this.UTIL.getMiniHBaseCluster().getMaster().getCatalogJanitor().choreForTesting();
            this.UTIL.waitFor(timeout, () -> {
                try {
                    Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)tableName);
                    for (FileStatus fileStatus : this.fs.listStatus(tableDir)) {
                        String name = fileStatus.getPath().getName();
                        if (!name.equals(region0.getEncodedName()) && !name.equals(region1.getEncodedName())) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.warn("Check if parent regions are archived error", (Throwable)e);
                    return false;
                }
            });
            long time = EnvironmentEdgeManager.currentTime() - 300000000L;
            this.traverseAndSetFileTime(HFileArchiveUtil.getArchivePath((Configuration)conf), time);
            this.UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().triggerCleanerNow().get();
            try (TableSnapshotScanner scanner = new TableSnapshotScanner(conf, this.UTIL.getDataTestDirOnTestFS(snapshotName), snapshotName, new Scan(bbb, yyy));){
                this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            }
        }
        catch (Exception e) {
            LOG.error("scan snapshot error", (Throwable)e);
            Assert.fail((String)("Should not throw Exception: " + e.getMessage()));
            Assert.fail((String)"Should not throw FileNotFoundException");
            Assert.assertTrue((e.getCause() != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof FileNotFoundException));
        }
    }

    @Test
    public void testDeleteTableWithMergedRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = tableName.getNameAsString() + "_snapshot";
        Configuration conf = this.UTIL.getConfiguration();
        try (Admin admin = this.UTIL.getConnection().getAdmin();){
            admin.compactionSwitch(false, admin.getRegionServers().stream().map(s -> s.getServerName()).collect(Collectors.toList()));
            Table table = this.UTIL.createTable(tableName, FAMILIES, 1, bbb, yyy, 3);
            List regions = admin.getRegions(tableName);
            Assert.assertEquals((long)3L, (long)regions.size());
            this.UTIL.loadTable(table, FAMILIES);
            admin.mergeRegionsAsync((byte[][])new byte[][]{((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes()}, false).get();
            regions = admin.getRegions(tableName);
            Assert.assertEquals((long)2L, (long)regions.size());
            admin.snapshot(snapshotName, tableName);
            try (TableSnapshotScanner scanner = new TableSnapshotScanner(conf, this.UTIL.getDataTestDirOnTestFS(snapshotName), snapshotName, new Scan().withStartRow(bbb).withStopRow(yyy));){
                this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            }
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            scanner = new TableSnapshotScanner(conf, this.UTIL.getDataTestDirOnTestFS(snapshotName), snapshotName, new Scan().withStartRow(bbb).withStopRow(yyy));
            var9_11 = null;
            try {
                this.verifyScanner((ResultScanner)scanner, bbb, yyy);
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var9_11 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    private void traverseAndSetFileTime(Path path, long time) throws IOException {
        this.fs.setTimes(path, time, -1L);
        if (this.fs.isDirectory(path)) {
            List<FileStatus> allPaths = Arrays.asList(this.fs.listStatus(path));
            List subDirs = allPaths.stream().filter(FileStatus::isDirectory).collect(Collectors.toList());
            List files = allPaths.stream().filter(FileStatus::isFile).collect(Collectors.toList());
            for (FileStatus subDir : subDirs) {
                this.traverseAndSetFileTime(subDir.getPath(), time);
            }
            for (FileStatus file : files) {
                this.fs.setTimes(file.getPath(), time, -1L);
            }
        }
    }
}

