/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTableProcedureWaitingQueueCleanup {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableProcedureWaitingQueueCleanup.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableDescriptor TD = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void testCreateDelete(Procedure<MasterProcedureEnv> proc) throws Exception {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)procExec, proc);
        Assert.assertTrue((boolean)UTIL.getAdmin().tableExists(TD.getTableName()));
        UTIL.getAdmin().disableTable(TD.getTableName());
        UTIL.getAdmin().deleteTable(TD.getTableName());
    }

    @Test
    public void testNonTableProcedure() throws Exception {
        this.testCreateDelete(new NonTableProcedure());
    }

    @Test
    public void testNotSameTable() throws Exception {
        this.testCreateDelete(new MetaTableProcedure());
    }

    public static class MetaTableProcedure
    extends Procedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        private boolean created = false;

        public TableName getTableName() {
            return TableName.META_TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.EDIT;
        }

        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (this.created) {
                return null;
            }
            this.created = true;
            return new Procedure[]{new CreateTableProcedure(env, TD, new RegionInfo[]{RegionInfoBuilder.newBuilder((TableName)TD.getTableName()).build()})};
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }

    public static class NonTableProcedure
    extends Procedure<MasterProcedureEnv>
    implements PeerProcedureInterface {
        private boolean created = false;

        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (this.created) {
                return null;
            }
            this.created = true;
            return new Procedure[]{new CreateTableProcedure(env, TD, new RegionInfo[]{RegionInfoBuilder.newBuilder((TableName)TD.getTableName()).build()})};
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        public String getPeerId() {
            return "peer";
        }

        public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
            return PeerProcedureInterface.PeerOperationType.ENABLE;
        }
    }
}

